/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 0.8.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class StatusResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(SERIALIZED_NAME_START_TIME)
    private OffsetDateTime startTime;

    public static final String SERIALIZED_NAME_PLAYERS = "players";
    @SerializedName(SERIALIZED_NAME_PLAYERS)
    private Integer players;

    public static final String SERIALIZED_NAME_SERVER_VERSION = "server_version";
    @SerializedName(SERIALIZED_NAME_SERVER_VERSION)
    private String serverVersion;

    public static final String SERIALIZED_NAME_VIP = "vip";
    @SerializedName(SERIALIZED_NAME_VIP)
    private Boolean vip;

    public StatusResponse startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Server start timestamp
     * 
     * @return startTime
     **/
    @ApiModelProperty(required = true, value = "Server start timestamp")
    public OffsetDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public StatusResponse players(Integer players) {
        this.players = players;
        return this;
    }

    /**
     * Current online player count
     * 
     * @return players
     **/
    @ApiModelProperty(required = true, value = "Current online player count")
    public Integer getPlayers() {
        return players;
    }

    public void setPlayers(Integer players) {
        this.players = players;
    }

    public StatusResponse serverVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    /**
     * Running version as string
     * 
     * @return serverVersion
     **/
    @ApiModelProperty(required = true, value = "Running version as string")
    public String getServerVersion() {
        return serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public StatusResponse vip(Boolean vip) {
        this.vip = vip;
        return this;
    }

    /**
     * If the server is in VIP mode
     * 
     * @return vip
     **/
    @ApiModelProperty(value = "If the server is in VIP mode")
    public Boolean getVip() {
        return vip;
    }

    public void setVip(Boolean vip) {
        this.vip = vip;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StatusResponse statusResponse = (StatusResponse) o;
        return Objects.equals(this.startTime, statusResponse.startTime)
                && Objects.equals(this.players, statusResponse.players)
                && Objects.equals(this.serverVersion, statusResponse.serverVersion)
                && Objects.equals(this.vip, statusResponse.vip);
    }

    @Override
    public int hashCode() {
        return Objects.hash(startTime, players, serverVersion, vip);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusResponse {\n");
        sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
        sb.append("    players: ").append(toIndentedString(players)).append("\n");
        sb.append("    serverVersion: ").append(toIndentedString(serverVersion)).append("\n");
        sb.append("    vip: ").append(toIndentedString(vip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
