/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 0.8.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.InsurancePriceLevel;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class InsurancePricesResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(SERIALIZED_NAME_TYPE_ID)
    private Integer typeId;

    public static final String SERIALIZED_NAME_LEVELS = "levels";
    @SerializedName(SERIALIZED_NAME_LEVELS)
    private List<InsurancePriceLevel> levels = new ArrayList<>();

    public InsurancePricesResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * type_id integer
     * 
     * @return typeId
     **/
    @ApiModelProperty(required = true, value = "type_id integer")
    public Integer getTypeId() {
        return typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public InsurancePricesResponse levels(List<InsurancePriceLevel> levels) {
        this.levels = levels;
        return this;
    }

    public InsurancePricesResponse addLevelsItem(InsurancePriceLevel levelsItem) {
        this.levels.add(levelsItem);
        return this;
    }

    /**
     * A list of a available insurance levels for this ship type
     * 
     * @return levels
     **/
    @ApiModelProperty(required = true, value = "A list of a available insurance levels for this ship type")
    public List<InsurancePriceLevel> getLevels() {
        return levels;
    }

    public void setLevels(List<InsurancePriceLevel> levels) {
        this.levels = levels;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InsurancePricesResponse insurancePricesResponse = (InsurancePricesResponse) o;
        return Objects.equals(this.typeId, insurancePricesResponse.typeId)
                && Objects.equals(this.levels, insurancePricesResponse.levels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(typeId, levels);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsurancePricesResponse {\n");
        sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
        sb.append("    levels: ").append(toIndentedString(levels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
