/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 0.8.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CorporationAlliancesHistoryResponse;
import net.troja.eve.esi.model.CorporationBlueprintsResponse;
import net.troja.eve.esi.model.CorporationContainersLogsResponse;
import net.troja.eve.esi.model.CorporationDivisionsResponse;
import net.troja.eve.esi.model.CorporationFacilitiesResponse;
import net.troja.eve.esi.model.CorporationIconsResponse;
import net.troja.eve.esi.model.CorporationMedalsIssuedResponse;
import net.troja.eve.esi.model.CorporationMedalsResponse;
import net.troja.eve.esi.model.CorporationMemberTrackingResponse;
import net.troja.eve.esi.model.CorporationMembersTitlesResponse;
import net.troja.eve.esi.model.CorporationResponse;
import net.troja.eve.esi.model.CorporationRolesHistoryResponse;
import net.troja.eve.esi.model.CorporationRolesResponse;
import net.troja.eve.esi.model.CorporationShareholdersResponse;
import net.troja.eve.esi.model.CorporationStandingsResponse;
import net.troja.eve.esi.model.CorporationStarbaseResponse;
import net.troja.eve.esi.model.CorporationStarbasesResponse;
import net.troja.eve.esi.model.CorporationStructuresResponse;
import net.troja.eve.esi.model.CorporationTitlesResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CorporationApi {
    private ApiClient localVarApiClient;

    public CorporationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CorporationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getCorporationsCorporationId
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdCall(Integer corporationId, String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v4/corporations/{corporation_id}/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdValidateBeforeCall(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationId(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdCall(corporationId, datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get corporation information Public information about a corporation ---
     * This route is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return CorporationResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CorporationResponse getCorporationsCorporationId(Integer corporationId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<CorporationResponse> localVarResp = getCorporationsCorporationIdWithHttpInfo(corporationId,
                datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get corporation information Public information about a corporation ---
     * This route is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;CorporationResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CorporationResponse> getCorporationsCorporationIdWithHttpInfo(Integer corporationId,
            String datasource, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CorporationResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation information (asynchronously) Public information about a
     * corporation --- This route is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdAsync(Integer corporationId, String datasource, String ifNoneMatch,
            final ApiCallback<CorporationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<CorporationResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdAlliancehistory
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdAlliancehistoryCall(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/corporations/{corporation_id}/alliancehistory/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdAlliancehistoryValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdAlliancehistory(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdAlliancehistoryCall(corporationId, datasource,
                ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get alliance history Get a list of all the alliances a corporation has
     * been a member of --- This route is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;CorporationAlliancesHistoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationAlliancesHistoryResponse> getCorporationsCorporationIdAlliancehistory(Integer corporationId,
            String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<CorporationAlliancesHistoryResponse>> localVarResp = getCorporationsCorporationIdAlliancehistoryWithHttpInfo(
                corporationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get alliance history Get a list of all the alliances a corporation has
     * been a member of --- This route is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return 
     *         ApiResponse&lt;List&lt;CorporationAlliancesHistoryResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationAlliancesHistoryResponse>> getCorporationsCorporationIdAlliancehistoryWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdAlliancehistoryValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<CorporationAlliancesHistoryResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get alliance history (asynchronously) Get a list of all the alliances a
     * corporation has been a member of --- This route is cached for up to 3600
     * seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdAlliancehistoryAsync(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback<List<CorporationAlliancesHistoryResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdAlliancehistoryValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationAlliancesHistoryResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdBlueprints
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdBlueprintsCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/corporations/{corporation_id}/blueprints/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdBlueprintsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdBlueprints(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdBlueprintsCall(corporationId, datasource, ifNoneMatch,
                page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation blueprints Returns a list of blueprints the corporation
     * owns --- This route is cached for up to 3600 seconds --- Requires one of
     * the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_blueprints.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationBlueprintsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationBlueprintsResponse> getCorporationsCorporationIdBlueprints(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationBlueprintsResponse>> localVarResp = getCorporationsCorporationIdBlueprintsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation blueprints Returns a list of blueprints the corporation
     * owns --- This route is cached for up to 3600 seconds --- Requires one of
     * the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_blueprints.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationBlueprintsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationBlueprintsResponse>> getCorporationsCorporationIdBlueprintsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdBlueprintsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationBlueprintsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation blueprints (asynchronously) Returns a list of blueprints
     * the corporation owns --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_blueprints.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdBlueprintsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationBlueprintsResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdBlueprintsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationBlueprintsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdContainersLogs
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdContainersLogsCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/corporations/{corporation_id}/containers/logs/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdContainersLogsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdContainersLogs(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdContainersLogsCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        return localVarCall;

    }

    /**
     * Get all corporation ALSC logs Returns logs recorded in the past seven
     * days from all audit log secure containers (ALSC) owned by a given
     * corporation --- This route is cached for up to 600 seconds --- Requires
     * one of the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_container_logs.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationContainersLogsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationContainersLogsResponse> getCorporationsCorporationIdContainersLogs(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationContainersLogsResponse>> localVarResp = getCorporationsCorporationIdContainersLogsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get all corporation ALSC logs Returns logs recorded in the past seven
     * days from all audit log secure containers (ALSC) owned by a given
     * corporation --- This route is cached for up to 600 seconds --- Requires
     * one of the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_container_logs.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationContainersLogsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationContainersLogsResponse>> getCorporationsCorporationIdContainersLogsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdContainersLogsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationContainersLogsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all corporation ALSC logs (asynchronously) Returns logs recorded in
     * the past seven days from all audit log secure containers (ALSC) owned by
     * a given corporation --- This route is cached for up to 600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_container_logs.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdContainersLogsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationContainersLogsResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdContainersLogsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationContainersLogsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdDivisions
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdDivisionsCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/divisions/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdDivisionsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdDivisions(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdDivisionsCall(corporationId, datasource, ifNoneMatch,
                token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation divisions Return corporation hangar and wallet division
     * names, only show if a division is not using the default name --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_divisions.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return CorporationDivisionsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CorporationDivisionsResponse getCorporationsCorporationIdDivisions(Integer corporationId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CorporationDivisionsResponse> localVarResp = getCorporationsCorporationIdDivisionsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation divisions Return corporation hangar and wallet division
     * names, only show if a division is not using the default name --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_divisions.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;CorporationDivisionsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CorporationDivisionsResponse> getCorporationsCorporationIdDivisionsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdDivisionsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CorporationDivisionsResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation divisions (asynchronously) Return corporation hangar and
     * wallet division names, only show if a division is not using the default
     * name --- This route is cached for up to 3600 seconds --- Requires one of
     * the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_divisions.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdDivisionsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<CorporationDivisionsResponse> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdDivisionsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CorporationDivisionsResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdFacilities
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdFacilitiesCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/facilities/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdFacilitiesValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdFacilities(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdFacilitiesCall(corporationId, datasource, ifNoneMatch,
                token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation facilities Return a corporation&#39;s facilities --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Factory_Manager SSO Scope:
     * esi-corporations.read_facilities.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationFacilitiesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationFacilitiesResponse> getCorporationsCorporationIdFacilities(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationFacilitiesResponse>> localVarResp = getCorporationsCorporationIdFacilitiesWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation facilities Return a corporation&#39;s facilities --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Factory_Manager SSO Scope:
     * esi-corporations.read_facilities.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationFacilitiesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationFacilitiesResponse>> getCorporationsCorporationIdFacilitiesWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdFacilitiesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationFacilitiesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation facilities (asynchronously) Return a corporation&#39;s
     * facilities --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Factory_Manager SSO Scope:
     * esi-corporations.read_facilities.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdFacilitiesAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CorporationFacilitiesResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdFacilitiesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationFacilitiesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdIcons
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdIconsCall(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/icons/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdIconsValidateBeforeCall(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdIcons(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdIconsCall(corporationId, datasource, ifNoneMatch,
                _callback);
        return localVarCall;

    }

    /**
     * Get corporation icon Get the icon urls for a corporation --- This route
     * is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return CorporationIconsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CorporationIconsResponse getCorporationsCorporationIdIcons(Integer corporationId, String datasource,
            String ifNoneMatch) throws ApiException {
        ApiResponse<CorporationIconsResponse> localVarResp = getCorporationsCorporationIdIconsWithHttpInfo(
                corporationId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get corporation icon Get the icon urls for a corporation --- This route
     * is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;CorporationIconsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CorporationIconsResponse> getCorporationsCorporationIdIconsWithHttpInfo(Integer corporationId,
            String datasource, String ifNoneMatch) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdIconsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CorporationIconsResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation icon (asynchronously) Get the icon urls for a corporation
     * --- This route is cached for up to 3600 seconds
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdIconsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback<CorporationIconsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdIconsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<CorporationIconsResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdMedals
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdMedalsCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/medals/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdMedalsValidateBeforeCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMedals(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdMedalsCall(corporationId, datasource, ifNoneMatch,
                page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation medals Returns a corporation&#39;s medals --- This route
     * is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_medals.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMedalsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMedalsResponse> getCorporationsCorporationIdMedals(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationMedalsResponse>> localVarResp = getCorporationsCorporationIdMedalsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation medals Returns a corporation&#39;s medals --- This route
     * is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_medals.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationMedalsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMedalsResponse>> getCorporationsCorporationIdMedalsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdMedalsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation medals (asynchronously) Returns a corporation&#39;s
     * medals --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_medals.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdMedalsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<CorporationMedalsResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdMedalsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdMedalsIssued
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdMedalsIssuedCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/medals/issued/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdMedalsIssuedValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMedalsIssued(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdMedalsIssuedCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation issued medals Returns medals issued by a corporation ---
     * This route is cached for up to 3600 seconds --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_medals.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMedalsIssuedResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMedalsIssuedResponse> getCorporationsCorporationIdMedalsIssued(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationMedalsIssuedResponse>> localVarResp = getCorporationsCorporationIdMedalsIssuedWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation issued medals Returns medals issued by a corporation ---
     * This route is cached for up to 3600 seconds --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_medals.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationMedalsIssuedResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMedalsIssuedResponse>> getCorporationsCorporationIdMedalsIssuedWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdMedalsIssuedValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsIssuedResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation issued medals (asynchronously) Returns medals issued by a
     * corporation --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_medals.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdMedalsIssuedAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationMedalsIssuedResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdMedalsIssuedValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMedalsIssuedResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdMembers
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembersCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/corporations/{corporation_id}/members/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdMembersValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembers(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersCall(corporationId, datasource, ifNoneMatch,
                token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation members Return the current member list of a corporation,
     * the token&#39;s character need to be a member of the corporation. ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getCorporationsCorporationIdMembers(Integer corporationId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getCorporationsCorporationIdMembersWithHttpInfo(corporationId,
                datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation members Return the current member list of a corporation,
     * the token&#39;s character need to be a member of the corporation. ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getCorporationsCorporationIdMembersWithHttpInfo(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation members (asynchronously) Return the current member list
     * of a corporation, the token&#39;s character need to be a member of the
     * corporation. --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembersAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdMembersLimit
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembersLimitCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/members/limit/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdMembersLimitValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembersLimit(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersLimitCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation member limit Return a corporation&#39;s member limit, not
     * including CEO himself --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.track_members.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return Integer
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public Integer getCorporationsCorporationIdMembersLimit(Integer corporationId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<Integer> localVarResp = getCorporationsCorporationIdMembersLimitWithHttpInfo(corporationId,
                datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation member limit Return a corporation&#39;s member limit, not
     * including CEO himself --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.track_members.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Integer> getCorporationsCorporationIdMembersLimitWithHttpInfo(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersLimitValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<Integer>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation member limit (asynchronously) Return a corporation&#39;s
     * member limit, not including CEO himself --- This route is cached for up
     * to 3600 seconds --- Requires one of the following EVE corporation
     * role(s): Director SSO Scope: esi-corporations.track_members.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembersLimitAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<Integer> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersLimitValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<Integer>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdMembersTitles
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembersTitlesCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/members/titles/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdMembersTitlesValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembersTitles(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersTitlesCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation&#39;s members&#39; titles Returns a corporation&#39;s
     * members&#39; titles --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_titles.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMembersTitlesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMembersTitlesResponse> getCorporationsCorporationIdMembersTitles(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationMembersTitlesResponse>> localVarResp = getCorporationsCorporationIdMembersTitlesWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation&#39;s members&#39; titles Returns a corporation&#39;s
     * members&#39; titles --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_titles.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationMembersTitlesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMembersTitlesResponse>> getCorporationsCorporationIdMembersTitlesWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersTitlesValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMembersTitlesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation&#39;s members&#39; titles (asynchronously) Returns a
     * corporation&#39;s members&#39; titles --- This route is cached for up to
     * 3600 seconds --- Requires one of the following EVE corporation role(s):
     * Director SSO Scope: esi-corporations.read_titles.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembersTitlesAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CorporationMembersTitlesResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembersTitlesValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMembersTitlesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdMembertracking
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembertrackingCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/membertracking/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdMembertrackingValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdMembertracking(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembertrackingCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        return localVarCall;

    }

    /**
     * Track corporation members Returns additional information about a
     * corporation&#39;s members which helps tracking their activities --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Director SSO Scope:
     * esi-corporations.track_members.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMemberTrackingResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMemberTrackingResponse> getCorporationsCorporationIdMembertracking(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationMemberTrackingResponse>> localVarResp = getCorporationsCorporationIdMembertrackingWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Track corporation members Returns additional information about a
     * corporation&#39;s members which helps tracking their activities --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Director SSO Scope:
     * esi-corporations.track_members.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationMemberTrackingResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMemberTrackingResponse>> getCorporationsCorporationIdMembertrackingWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdMembertrackingValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMemberTrackingResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Track corporation members (asynchronously) Returns additional information
     * about a corporation&#39;s members which helps tracking their activities
     * --- This route is cached for up to 3600 seconds --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.track_members.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdMembertrackingAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CorporationMemberTrackingResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdMembertrackingValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationMemberTrackingResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdRoles
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdRolesCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/roles/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdRolesValidateBeforeCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdRoles(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdRolesCall(corporationId, datasource, ifNoneMatch,
                token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation member roles Return the roles of all members if the
     * character has the personnel manager role or any grantable role. --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationRolesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationRolesResponse> getCorporationsCorporationIdRoles(Integer corporationId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationRolesResponse>> localVarResp = getCorporationsCorporationIdRolesWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation member roles Return the roles of all members if the
     * character has the personnel manager role or any grantable role. --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationRolesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationRolesResponse>> getCorporationsCorporationIdRolesWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdRolesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationRolesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation member roles (asynchronously) Return the roles of all
     * members if the character has the personnel manager role or any grantable
     * role. --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdRolesAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CorporationRolesResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdRolesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationRolesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdRolesHistory
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdRolesHistoryCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/roles/history/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdRolesHistoryValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdRolesHistory(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdRolesHistoryCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation member roles history Return how roles have changed for a
     * coporation&#39;s members, up to a month --- This route is cached for up
     * to 3600 seconds --- Requires one of the following EVE corporation
     * role(s): Director SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationRolesHistoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationRolesHistoryResponse> getCorporationsCorporationIdRolesHistory(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationRolesHistoryResponse>> localVarResp = getCorporationsCorporationIdRolesHistoryWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation member roles history Return how roles have changed for a
     * coporation&#39;s members, up to a month --- This route is cached for up
     * to 3600 seconds --- Requires one of the following EVE corporation
     * role(s): Director SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationRolesHistoryResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationRolesHistoryResponse>> getCorporationsCorporationIdRolesHistoryWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdRolesHistoryValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationRolesHistoryResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation member roles history (asynchronously) Return how roles
     * have changed for a coporation&#39;s members, up to a month --- This route
     * is cached for up to 3600 seconds --- Requires one of the following EVE
     * corporation role(s): Director SSO Scope:
     * esi-corporations.read_corporation_membership.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdRolesHistoryAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationRolesHistoryResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdRolesHistoryValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationRolesHistoryResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdShareholders
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdShareholdersCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/shareholders/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdShareholdersValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdShareholders(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdShareholdersCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation shareholders Return the current shareholders of a
     * corporation. --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Director SSO Scope:
     * esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationShareholdersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationShareholdersResponse> getCorporationsCorporationIdShareholders(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationShareholdersResponse>> localVarResp = getCorporationsCorporationIdShareholdersWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation shareholders Return the current shareholders of a
     * corporation. --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Director SSO Scope:
     * esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationShareholdersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationShareholdersResponse>> getCorporationsCorporationIdShareholdersWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdShareholdersValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationShareholdersResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation shareholders (asynchronously) Return the current
     * shareholders of a corporation. --- This route is cached for up to 3600
     * seconds --- Requires one of the following EVE corporation role(s):
     * Director SSO Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdShareholdersAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationShareholdersResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdShareholdersValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationShareholdersResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdStandings
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdStandingsCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/standings/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdStandingsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStandings(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdStandingsCall(corporationId, datasource, ifNoneMatch,
                page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation standings Return corporation standings from agents, NPC
     * corporations, and factions --- This route is cached for up to 3600
     * seconds SSO Scope: esi-corporations.read_standings.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationStandingsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationStandingsResponse> getCorporationsCorporationIdStandings(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationStandingsResponse>> localVarResp = getCorporationsCorporationIdStandingsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation standings Return corporation standings from agents, NPC
     * corporations, and factions --- This route is cached for up to 3600
     * seconds SSO Scope: esi-corporations.read_standings.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationStandingsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationStandingsResponse>> getCorporationsCorporationIdStandingsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdStandingsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationStandingsResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation standings (asynchronously) Return corporation standings
     * from agents, NPC corporations, and factions --- This route is cached for
     * up to 3600 seconds SSO Scope: esi-corporations.read_standings.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdStandingsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationStandingsResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdStandingsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationStandingsResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdStarbases
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdStarbasesCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/starbases/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdStarbasesValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback _callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStarbases(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdStarbasesCall(corporationId, datasource, ifNoneMatch,
                page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation starbases (POSes) Returns list of corporation starbases
     * (POSes) --- This route is cached for up to 3600 seconds --- Requires one
     * of the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_starbases.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationStarbasesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationStarbasesResponse> getCorporationsCorporationIdStarbases(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationStarbasesResponse>> localVarResp = getCorporationsCorporationIdStarbasesWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation starbases (POSes) Returns list of corporation starbases
     * (POSes) --- This route is cached for up to 3600 seconds --- Requires one
     * of the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_starbases.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationStarbasesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationStarbasesResponse>> getCorporationsCorporationIdStarbasesWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdStarbasesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationStarbasesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation starbases (POSes) (asynchronously) Returns list of
     * corporation starbases (POSes) --- This route is cached for up to 3600
     * seconds --- Requires one of the following EVE corporation role(s):
     * Director SSO Scope: esi-corporations.read_starbases.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdStarbasesAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationStarbasesResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdStarbasesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationStarbasesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdStarbasesStarbaseId
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param starbaseId
     *            An EVE starbase (POS) ID (required)
     * @param systemId
     *            The solar system this starbase (POS) is located in, (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdStarbasesStarbaseIdCall(Integer corporationId, Long starbaseId,
            Integer systemId, String datasource, String ifNoneMatch, String token, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/starbases/{starbase_id}/".replaceAll(
                "\\{" + "corporation_id" + "\\}", localVarApiClient.escapeString(corporationId.toString())).replaceAll(
                "\\{" + "starbase_id" + "\\}", localVarApiClient.escapeString(starbaseId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (systemId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("system_id", systemId));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdStarbasesStarbaseIdValidateBeforeCall(Integer corporationId,
            Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token,
            final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStarbasesStarbaseId(Async)");
        }

        // verify the required parameter 'starbaseId' is set
        if (starbaseId == null) {
            throw new ApiException(
                    "Missing the required parameter 'starbaseId' when calling getCorporationsCorporationIdStarbasesStarbaseId(Async)");
        }

        // verify the required parameter 'systemId' is set
        if (systemId == null) {
            throw new ApiException(
                    "Missing the required parameter 'systemId' when calling getCorporationsCorporationIdStarbasesStarbaseId(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdStarbasesStarbaseIdCall(corporationId, starbaseId,
                systemId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;

    }

    /**
     * Get starbase (POS) detail Returns various settings and fuels of a
     * starbase (POS) --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_starbases.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param starbaseId
     *            An EVE starbase (POS) ID (required)
     * @param systemId
     *            The solar system this starbase (POS) is located in, (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return CorporationStarbaseResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CorporationStarbaseResponse getCorporationsCorporationIdStarbasesStarbaseId(Integer corporationId,
            Long starbaseId, Integer systemId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CorporationStarbaseResponse> localVarResp = getCorporationsCorporationIdStarbasesStarbaseIdWithHttpInfo(
                corporationId, starbaseId, systemId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get starbase (POS) detail Returns various settings and fuels of a
     * starbase (POS) --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_starbases.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param starbaseId
     *            An EVE starbase (POS) ID (required)
     * @param systemId
     *            The solar system this starbase (POS) is located in, (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;CorporationStarbaseResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CorporationStarbaseResponse> getCorporationsCorporationIdStarbasesStarbaseIdWithHttpInfo(
            Integer corporationId, Long starbaseId, Integer systemId, String datasource, String ifNoneMatch,
            String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdStarbasesStarbaseIdValidateBeforeCall(corporationId,
                starbaseId, systemId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CorporationStarbaseResponse>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get starbase (POS) detail (asynchronously) Returns various settings and
     * fuels of a starbase (POS) --- This route is cached for up to 3600 seconds
     * --- Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-corporations.read_starbases.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param starbaseId
     *            An EVE starbase (POS) ID (required)
     * @param systemId
     *            The solar system this starbase (POS) is located in, (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdStarbasesStarbaseIdAsync(Integer corporationId, Long starbaseId,
            Integer systemId, String datasource, String ifNoneMatch, String token,
            final ApiCallback<CorporationStarbaseResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdStarbasesStarbaseIdValidateBeforeCall(corporationId,
                starbaseId, systemId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CorporationStarbaseResponse>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdStructures
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdStructuresCall(Integer corporationId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, Integer page, String token,
            final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/corporations/{corporation_id}/structures/".replaceAll("\\{" + "corporation_id"
                + "\\}", localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("language", language));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", localVarApiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdStructuresValidateBeforeCall(Integer corporationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token,
            final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdStructures(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdStructuresCall(corporationId, acceptLanguage,
                datasource, ifNoneMatch, language, page, token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation structures Get a list of corporation structures. This
     * route&#39;s version includes the changes to structures detailed in this
     * blog:
     * https://www.eveonline.com/article/upwell-2.0-structures-changes-coming
     * -on-february-13th --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Station_Manager
     * SSO Scope: esi-corporations.read_structures.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationStructuresResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationStructuresResponse> getCorporationsCorporationIdStructures(Integer corporationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, Integer page, String token)
            throws ApiException {
        ApiResponse<List<CorporationStructuresResponse>> localVarResp = getCorporationsCorporationIdStructuresWithHttpInfo(
                corporationId, acceptLanguage, datasource, ifNoneMatch, language, page, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation structures Get a list of corporation structures. This
     * route&#39;s version includes the changes to structures detailed in this
     * blog:
     * https://www.eveonline.com/article/upwell-2.0-structures-changes-coming
     * -on-february-13th --- This route is cached for up to 3600 seconds ---
     * Requires one of the following EVE corporation role(s): Station_Manager
     * SSO Scope: esi-corporations.read_structures.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationStructuresResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationStructuresResponse>> getCorporationsCorporationIdStructuresWithHttpInfo(
            Integer corporationId, String acceptLanguage, String datasource, String ifNoneMatch, String language,
            Integer page, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdStructuresValidateBeforeCall(corporationId,
                acceptLanguage, datasource, ifNoneMatch, language, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationStructuresResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation structures (asynchronously) Get a list of corporation
     * structures. This route&#39;s version includes the changes to structures
     * detailed in this blog:
     * https://www.eveonline.com/article/upwell-2.0-structures
     * -changes-coming-on-february-13th --- This route is cached for up to 3600
     * seconds --- Requires one of the following EVE corporation role(s):
     * Station_Manager SSO Scope: esi-corporations.read_structures.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdStructuresAsync(Integer corporationId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, Integer page, String token,
            final ApiCallback<List<CorporationStructuresResponse>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdStructuresValidateBeforeCall(corporationId,
                acceptLanguage, datasource, ifNoneMatch, language, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationStructuresResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsCorporationIdTitles
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsCorporationIdTitlesCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/titles/".replaceAll("\\{" + "corporation_id" + "\\}",
                localVarApiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsCorporationIdTitlesValidateBeforeCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback _callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdTitles(Async)");
        }

        okhttp3.Call localVarCall = getCorporationsCorporationIdTitlesCall(corporationId, datasource, ifNoneMatch,
                token, _callback);
        return localVarCall;

    }

    /**
     * Get corporation titles Returns a corporation&#39;s titles --- This route
     * is cached for up to 3600 seconds --- Requires one of the following EVE
     * corporation role(s): Director SSO Scope: esi-corporations.read_titles.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationTitlesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationTitlesResponse> getCorporationsCorporationIdTitles(Integer corporationId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationTitlesResponse>> localVarResp = getCorporationsCorporationIdTitlesWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    /**
     * Get corporation titles Returns a corporation&#39;s titles --- This route
     * is cached for up to 3600 seconds --- Requires one of the following EVE
     * corporation role(s): Director SSO Scope: esi-corporations.read_titles.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationTitlesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationTitlesResponse>> getCorporationsCorporationIdTitlesWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        okhttp3.Call localVarCall = getCorporationsCorporationIdTitlesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationTitlesResponse>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get corporation titles (asynchronously) Returns a corporation&#39;s
     * titles --- This route is cached for up to 3600 seconds --- Requires one
     * of the following EVE corporation role(s): Director SSO Scope:
     * esi-corporations.read_titles.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsCorporationIdTitlesAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CorporationTitlesResponse>> _callback)
            throws ApiException {

        okhttp3.Call localVarCall = getCorporationsCorporationIdTitlesValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CorporationTitlesResponse>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCorporationsNpccorps
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public okhttp3.Call getCorporationsNpccorpsCall(String datasource, String ifNoneMatch, final ApiCallback _callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/npccorps/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", localVarApiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCorporationsNpccorpsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsNpccorpsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;

    }

    /**
     * Get npc corporations Get a list of npc corporations --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getCorporationsNpccorps(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = getCorporationsNpccorpsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    /**
     * Get npc corporations Get a list of npc corporations --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getCorporationsNpccorpsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        okhttp3.Call localVarCall = getCorporationsNpccorpsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get npc corporations (asynchronously) Get a list of npc corporations ---
     * This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param _callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public okhttp3.Call getCorporationsNpccorpsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCorporationsNpccorpsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
