/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.Aggressor;
import net.troja.eve.esi.model.Defender;
import net.troja.eve.esi.model.WarAlly;

@ApiModel(description="200 ok object")
public class WarResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DECLARED = "declared";
    @SerializedName(value="declared")
    private OffsetDateTime declared;
    public static final String SERIALIZED_NAME_AGGRESSOR = "aggressor";
    @SerializedName(value="aggressor")
    private Aggressor aggressor = null;
    public static final String SERIALIZED_NAME_OPEN_FOR_ALLIES = "open_for_allies";
    @SerializedName(value="open_for_allies")
    private Boolean openForAllies;
    public static final String SERIALIZED_NAME_RETRACTED = "retracted";
    @SerializedName(value="retracted")
    private OffsetDateTime retracted;
    public static final String SERIALIZED_NAME_MUTUAL = "mutual";
    @SerializedName(value="mutual")
    private Boolean mutual;
    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(value="finished")
    private OffsetDateTime finished;
    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(value="started")
    private OffsetDateTime started;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_ALLIES = "allies";
    @SerializedName(value="allies")
    private List<WarAlly> allies = null;
    public static final String SERIALIZED_NAME_DEFENDER = "defender";
    @SerializedName(value="defender")
    private Defender defender = null;

    public WarResponse declared(OffsetDateTime offsetDateTime) {
        this.declared = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Time that the war was declared")
    public OffsetDateTime getDeclared() {
        return this.declared;
    }

    public void setDeclared(OffsetDateTime offsetDateTime) {
        this.declared = offsetDateTime;
    }

    public WarResponse aggressor(Aggressor aggressor) {
        this.aggressor = aggressor;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Aggressor getAggressor() {
        return this.aggressor;
    }

    public void setAggressor(Aggressor aggressor) {
        this.aggressor = aggressor;
    }

    public WarResponse openForAllies(Boolean bl) {
        this.openForAllies = bl;
        return this;
    }

    @ApiModelProperty(required=true, value="Is the war currently open for allies or not")
    public Boolean getOpenForAllies() {
        return this.openForAllies;
    }

    public void setOpenForAllies(Boolean bl) {
        this.openForAllies = bl;
    }

    public WarResponse retracted(OffsetDateTime offsetDateTime) {
        this.retracted = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Time the war was retracted but both sides could still shoot each other")
    public OffsetDateTime getRetracted() {
        return this.retracted;
    }

    public void setRetracted(OffsetDateTime offsetDateTime) {
        this.retracted = offsetDateTime;
    }

    public WarResponse mutual(Boolean bl) {
        this.mutual = bl;
        return this;
    }

    @ApiModelProperty(required=true, value="Was the war declared mutual by both parties")
    public Boolean getMutual() {
        return this.mutual;
    }

    public void setMutual(Boolean bl) {
        this.mutual = bl;
    }

    public WarResponse finished(OffsetDateTime offsetDateTime) {
        this.finished = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Time the war ended and shooting was no longer allowed")
    public OffsetDateTime getFinished() {
        return this.finished;
    }

    public void setFinished(OffsetDateTime offsetDateTime) {
        this.finished = offsetDateTime;
    }

    public WarResponse started(OffsetDateTime offsetDateTime) {
        this.started = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="Time when the war started and both sides could shoot each other")
    public OffsetDateTime getStarted() {
        return this.started;
    }

    public void setStarted(OffsetDateTime offsetDateTime) {
        this.started = offsetDateTime;
    }

    public WarResponse id(Integer n) {
        this.id = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the specified war")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public WarResponse allies(List<WarAlly> list) {
        this.allies = list;
        return this;
    }

    public WarResponse addAlliesItem(WarAlly warAlly) {
        if (this.allies == null) {
            this.allies = new ArrayList<WarAlly>();
        }
        this.allies.add(warAlly);
        return this;
    }

    @ApiModelProperty(value="allied corporations or alliances, each object contains either corporation_id or alliance_id")
    public List<WarAlly> getAllies() {
        return this.allies;
    }

    public void setAllies(List<WarAlly> list) {
        this.allies = list;
    }

    public WarResponse defender(Defender defender) {
        this.defender = defender;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Defender getDefender() {
        return this.defender;
    }

    public void setDefender(Defender defender) {
        this.defender = defender;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WarResponse warResponse = (WarResponse)object;
        return Objects.equals(this.declared, warResponse.declared) && Objects.equals(this.aggressor, warResponse.aggressor) && Objects.equals(this.openForAllies, warResponse.openForAllies) && Objects.equals(this.retracted, warResponse.retracted) && Objects.equals(this.mutual, warResponse.mutual) && Objects.equals(this.finished, warResponse.finished) && Objects.equals(this.started, warResponse.started) && Objects.equals(this.id, warResponse.id) && Objects.equals(this.allies, warResponse.allies) && Objects.equals(this.defender, warResponse.defender);
    }

    public int hashCode() {
        return Objects.hash(this.declared, this.aggressor, this.openForAllies, this.retracted, this.mutual, this.finished, this.started, this.id, this.allies, this.defender);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class WarResponse {\n");
        stringBuilder.append("    declared: ").append(this.toIndentedString(this.declared)).append("\n");
        stringBuilder.append("    aggressor: ").append(this.toIndentedString(this.aggressor)).append("\n");
        stringBuilder.append("    openForAllies: ").append(this.toIndentedString(this.openForAllies)).append("\n");
        stringBuilder.append("    retracted: ").append(this.toIndentedString(this.retracted)).append("\n");
        stringBuilder.append("    mutual: ").append(this.toIndentedString(this.mutual)).append("\n");
        stringBuilder.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        stringBuilder.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    allies: ").append(this.toIndentedString(this.allies)).append("\n");
        stringBuilder.append("    defender: ").append(this.toIndentedString(this.defender)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

