/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.Recipient;

@ApiModel(description="200 ok object")
public class MailResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_READ = "read";
    @SerializedName(value="read")
    private Boolean read;
    public static final String SERIALIZED_NAME_RECIPIENTS = "recipients";
    @SerializedName(value="recipients")
    private List<Recipient> recipients = null;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private Integer from;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Integer> labels = null;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;

    public MailResponse read(Boolean bl) {
        this.read = bl;
        return this;
    }

    @ApiModelProperty(value="Whether the mail is flagged as read")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean bl) {
        this.read = bl;
    }

    public MailResponse recipients(List<Recipient> list) {
        this.recipients = list;
        return this;
    }

    public MailResponse addRecipientsItem(Recipient recipient) {
        if (this.recipients == null) {
            this.recipients = new ArrayList<Recipient>();
        }
        this.recipients.add(recipient);
        return this;
    }

    @ApiModelProperty(value="Recipients of the mail")
    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<Recipient> list) {
        this.recipients = list;
    }

    public MailResponse subject(String string) {
        this.subject = string;
        return this;
    }

    @ApiModelProperty(value="Mail subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public MailResponse from(Integer n) {
        this.from = n;
        return this;
    }

    @ApiModelProperty(value="From whom the mail was sent")
    public Integer getFrom() {
        return this.from;
    }

    public void setFrom(Integer n) {
        this.from = n;
    }

    public MailResponse body(String string) {
        this.body = string;
        return this;
    }

    @ApiModelProperty(value="Mail's body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public MailResponse labels(List<Integer> list) {
        this.labels = list;
        return this;
    }

    public MailResponse addLabelsItem(Integer n) {
        if (this.labels == null) {
            this.labels = new ArrayList<Integer>();
        }
        this.labels.add(n);
        return this;
    }

    @ApiModelProperty(value="Labels attached to the mail")
    public List<Integer> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Integer> list) {
        this.labels = list;
    }

    public MailResponse timestamp(OffsetDateTime offsetDateTime) {
        this.timestamp = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="When the mail was sent")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime offsetDateTime) {
        this.timestamp = offsetDateTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MailResponse mailResponse = (MailResponse)object;
        return Objects.equals(this.read, mailResponse.read) && Objects.equals(this.recipients, mailResponse.recipients) && Objects.equals(this.subject, mailResponse.subject) && Objects.equals(this.from, mailResponse.from) && Objects.equals(this.body, mailResponse.body) && Objects.equals(this.labels, mailResponse.labels) && Objects.equals(this.timestamp, mailResponse.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.read, this.recipients, this.subject, this.from, this.body, this.labels, this.timestamp);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class MailResponse {\n");
        stringBuilder.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        stringBuilder.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        stringBuilder.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        stringBuilder.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        stringBuilder.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        stringBuilder.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

