/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.troja.eve.esi.model.EsiVerifyResponse;

public class CharacterInfo {
    private final EsiVerifyResponse response;
    private OffsetDateTime expiresDate;
    private Set<String> scopesSet = null;

    public CharacterInfo(EsiVerifyResponse esiVerifyResponse) {
        this.response = esiVerifyResponse;
    }

    public Set<String> getScopes() {
        if (this.scopesSet == null) {
            this.scopesSet = this.response.getScopes() != null ? new HashSet<String>(Arrays.asList(this.response.getScopes().split(" "))) : new HashSet<String>();
        }
        return this.scopesSet;
    }

    public String toString() {
        return this.response.toString();
    }

    public int hashCode() {
        return this.response.hashCode();
    }

    public boolean equals(Object object) {
        return this.response.equals(object);
    }

    public void setCharacterOwnerHash(String string) {
        this.response.setCharacterOwnerHash(string);
    }

    public String getCharacterOwnerHash() {
        return this.response.getCharacterOwnerHash();
    }

    public EsiVerifyResponse characterOwnerHash(String string) {
        return this.response.characterOwnerHash(string);
    }

    public void setExpiresOn(String string) {
        this.response.setExpiresOn(string);
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresDate == null) {
            this.expiresDate = OffsetDateTime.of(LocalDateTime.parse(this.response.getExpiresOn()), ZoneOffset.UTC);
        }
        return this.expiresDate;
    }

    public EsiVerifyResponse expiresOn(String string) {
        return this.response.expiresOn(string);
    }

    public void setCharacterName(String string) {
        this.response.setCharacterName(string);
    }

    public String getCharacterName() {
        return this.response.getCharacterName();
    }

    public EsiVerifyResponse characterName(String string) {
        return this.response.characterName(string);
    }

    public void setCharacterID(Integer n) {
        this.response.setCharacterID(n);
    }

    public Integer getCharacterID() {
        return this.response.getCharacterID();
    }

    public EsiVerifyResponse characterID(Integer n) {
        return this.response.characterID(n);
    }

    public void setScopes(String string) {
        this.response.setScopes(string);
    }

    public EsiVerifyResponse scopes(String string) {
        return this.response.scopes(string);
    }

    public void setIntellectualProperty(String string) {
        this.response.setIntellectualProperty(string);
    }

    public String getIntellectualProperty() {
        return this.response.getIntellectualProperty();
    }

    public EsiVerifyResponse intellectualProperty(String string) {
        return this.response.intellectualProperty(string);
    }

    public void setTokenType(String string) {
        this.response.setTokenType(string);
    }

    public String getTokenType() {
        return this.response.getTokenType();
    }

    public EsiVerifyResponse tokenType(String string) {
        return this.response.tokenType(string);
    }
}

