/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class AllianceResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TICKER = "ticker";
    @SerializedName(value="ticker")
    private String ticker;
    public static final String SERIALIZED_NAME_CREATOR_CORPORATION_ID = "creator_corporation_id";
    @SerializedName(value="creator_corporation_id")
    private Integer creatorCorporationId;
    public static final String SERIALIZED_NAME_CREATOR_ID = "creator_id";
    @SerializedName(value="creator_id")
    private Integer creatorId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_DATE_FOUNDED = "date_founded";
    @SerializedName(value="date_founded")
    private OffsetDateTime dateFounded;
    public static final String SERIALIZED_NAME_EXECUTOR_CORPORATION_ID = "executor_corporation_id";
    @SerializedName(value="executor_corporation_id")
    private Integer executorCorporationId;

    public AllianceResponse ticker(String string) {
        this.ticker = string;
        return this;
    }

    @ApiModelProperty(required=true, value="the short name of the alliance")
    public String getTicker() {
        return this.ticker;
    }

    public void setTicker(String string) {
        this.ticker = string;
    }

    public AllianceResponse creatorCorporationId(Integer n) {
        this.creatorCorporationId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the corporation that created the alliance")
    public Integer getCreatorCorporationId() {
        return this.creatorCorporationId;
    }

    public void setCreatorCorporationId(Integer n) {
        this.creatorCorporationId = n;
    }

    public AllianceResponse creatorId(Integer n) {
        this.creatorId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the character that created the alliance")
    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer n) {
        this.creatorId = n;
    }

    public AllianceResponse name(String string) {
        this.name = string;
        return this;
    }

    @ApiModelProperty(required=true, value="the full name of the alliance")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public AllianceResponse factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(value="Faction ID this alliance is fighting for, if this alliance is enlisted in factional warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public AllianceResponse dateFounded(OffsetDateTime offsetDateTime) {
        this.dateFounded = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="date_founded string")
    public OffsetDateTime getDateFounded() {
        return this.dateFounded;
    }

    public void setDateFounded(OffsetDateTime offsetDateTime) {
        this.dateFounded = offsetDateTime;
    }

    public AllianceResponse executorCorporationId(Integer n) {
        this.executorCorporationId = n;
        return this;
    }

    @ApiModelProperty(value="the executor corporation ID, if this alliance is not closed")
    public Integer getExecutorCorporationId() {
        return this.executorCorporationId;
    }

    public void setExecutorCorporationId(Integer n) {
        this.executorCorporationId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AllianceResponse allianceResponse = (AllianceResponse)object;
        return Objects.equals(this.ticker, allianceResponse.ticker) && Objects.equals(this.creatorCorporationId, allianceResponse.creatorCorporationId) && Objects.equals(this.creatorId, allianceResponse.creatorId) && Objects.equals(this.name, allianceResponse.name) && Objects.equals(this.factionId, allianceResponse.factionId) && Objects.equals(this.dateFounded, allianceResponse.dateFounded) && Objects.equals(this.executorCorporationId, allianceResponse.executorCorporationId);
    }

    public int hashCode() {
        return Objects.hash(this.ticker, this.creatorCorporationId, this.creatorId, this.name, this.factionId, this.dateFounded, this.executorCorporationId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class AllianceResponse {\n");
        stringBuilder.append("    ticker: ").append(this.toIndentedString(this.ticker)).append("\n");
        stringBuilder.append("    creatorCorporationId: ").append(this.toIndentedString(this.creatorCorporationId)).append("\n");
        stringBuilder.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("    dateFounded: ").append(this.toIndentedString(this.dateFounded)).append("\n");
        stringBuilder.append("    executorCorporationId: ").append(this.toIndentedString(this.executorCorporationId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

