/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The aggressor corporation or alliance that declared this war, only contains either corporation_id or alliance_id")
public class Aggressor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(value="alliance_id")
    private Integer allianceId;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_ISK_DESTROYED = "isk_destroyed";
    @SerializedName(value="isk_destroyed")
    private Float iskDestroyed;
    public static final String SERIALIZED_NAME_SHIPS_KILLED = "ships_killed";
    @SerializedName(value="ships_killed")
    private Integer shipsKilled;

    public Aggressor allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(value="Alliance ID if and only if the aggressor is an alliance")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public Aggressor corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(value="Corporation ID if and only if the aggressor is a corporation")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public Aggressor iskDestroyed(Float f) {
        this.iskDestroyed = f;
        return this;
    }

    @ApiModelProperty(required=true, value="ISK value of ships the aggressor has destroyed")
    public Float getIskDestroyed() {
        return this.iskDestroyed;
    }

    public void setIskDestroyed(Float f) {
        this.iskDestroyed = f;
    }

    public Aggressor shipsKilled(Integer n) {
        this.shipsKilled = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of ships the aggressor has killed")
    public Integer getShipsKilled() {
        return this.shipsKilled;
    }

    public void setShipsKilled(Integer n) {
        this.shipsKilled = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Aggressor aggressor = (Aggressor)object;
        return Objects.equals(this.allianceId, aggressor.allianceId) && Objects.equals(this.corporationId, aggressor.corporationId) && Objects.equals(this.iskDestroyed, aggressor.iskDestroyed) && Objects.equals(this.shipsKilled, aggressor.shipsKilled);
    }

    public int hashCode() {
        return Objects.hash(this.allianceId, this.corporationId, this.iskDestroyed, this.shipsKilled);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Aggressor {\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    iskDestroyed: ").append(this.toIndentedString(this.iskDestroyed)).append("\n");
        stringBuilder.append("    shipsKilled: ").append(this.toIndentedString(this.shipsKilled)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

