/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.auth.Authentication;
import net.troja.eve.esi.auth.JWT;

public class OAuth
implements Authentication {
    private static final String URI_OAUTH = "https://login.eveonline.com/v2/oauth";
    private static final String URI_AUTHENTICATION = "https://login.eveonline.com/v2/oauth/authorize";
    private static final String URI_ACCESS_TOKEN = "https://login.eveonline.com/v2/oauth/token";
    private static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
    private static final SecureRandom RND = new SecureRandom();
    private static final int LEN = 128;
    private String codeVerifier;
    private AccountData account;
    private static final Map<String, AccountData> ACCOUNTS = new ConcurrentHashMap<String, AccountData>();

    @Override
    public void applyToParams(List<Pair> list, Map<String, String> map) {
        AccountData accountData = this.getAccountData();
        if (accountData != null) {
            map.put("Authorization", "Bearer " + accountData.getAccessToken());
        }
    }

    public void setAccessToken(String string) {
        if (this.account == null) {
            this.account = new AccountData(null, null);
        }
        this.account.setAccessToken(string);
    }

    public String getRefreshToken() {
        if (this.account != null) {
            return this.account.getRefreshToken();
        }
        return null;
    }

    public String getClientId() {
        if (this.account != null) {
            return this.account.getClientId();
        }
        return null;
    }

    public void setAuth(String string, String string2) {
        AccountData accountData = new AccountData(string, string2);
        AccountData accountData2 = ACCOUNTS.putIfAbsent(accountData.getKey(), accountData);
        if (accountData2 != null) {
            accountData = accountData2;
        }
        if (this.account != null) {
            accountData.setAccessToken(this.account.getAccessToken());
        }
        this.account = accountData;
    }

    public void setClientId(String string) {
        this.setAuth(string, null);
    }

    public String getAccessToken() {
        AccountData accountData = this.getAccountData();
        if (accountData != null) {
            return accountData.getAccessToken();
        }
        return null;
    }

    public JWT getJWT() {
        AccountData accountData = this.getAccountData();
        if (accountData == null) {
            return null;
        }
        try {
            String string = accountData.getAccessToken();
            if (string == null) {
                return null;
            }
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 3) {
                return null;
            }
            Gson gson = new GsonBuilder().registerTypeAdapter(JWT.Payload.class, (Object)new JWT.PayloadDeserializer()).create();
            JWT.Header header = (JWT.Header)gson.fromJson(new String(Base64.getUrlDecoder().decode(stringArray[0])), JWT.Header.class);
            JWT.Payload payload = (JWT.Payload)gson.fromJson(new String(Base64.getUrlDecoder().decode(stringArray[1])), JWT.Payload.class);
            String string2 = stringArray[2];
            return new JWT(header, payload, string2);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return null;
        }
    }

    private AccountData getAccountData() {
        if (this.account == null) {
            return null;
        }
        this.account.update();
        return this.account;
    }

    public String getAuthorizationUri(String string, Set<String> set, String string2) {
        if (this.account == null) {
            throw new IllegalArgumentException("Auth is not set");
        }
        if (this.account.getClientId() == null) {
            throw new IllegalArgumentException("client_id is not set");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URI_AUTHENTICATION);
        stringBuilder.append("?");
        stringBuilder.append("response_type=");
        stringBuilder.append(OAuth.encode("code"));
        stringBuilder.append("&redirect_uri=");
        stringBuilder.append(OAuth.encode(string));
        stringBuilder.append("&client_id=");
        stringBuilder.append(OAuth.encode(this.account.getClientId()));
        stringBuilder.append("&scope=");
        stringBuilder.append(OAuth.encode(this.getScopesString(set)));
        stringBuilder.append("&state=");
        stringBuilder.append(OAuth.encode(string2));
        stringBuilder.append("&code_challenge");
        stringBuilder.append(this.getCodeChallenge());
        stringBuilder.append("&code_challenge_method=");
        stringBuilder.append(OAuth.encode("S256"));
        return stringBuilder.toString();
    }

    public void finishFlow(String string, String string2) throws ApiException {
        if (this.account == null) {
            throw new IllegalArgumentException("Auth is not set");
        }
        if (this.codeVerifier == null) {
            throw new IllegalArgumentException("code_verifier is not set");
        }
        if (this.account.getClientId() == null) {
            throw new IllegalArgumentException("client_id is not set");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("grant_type=");
        stringBuilder.append(OAuth.encode("authorization_code"));
        stringBuilder.append("&client_id=");
        stringBuilder.append(OAuth.encode(this.account.getClientId()));
        stringBuilder.append("&code=");
        stringBuilder.append(OAuth.encode(string));
        stringBuilder.append("&code_verifier=");
        stringBuilder.append(OAuth.encode(this.codeVerifier));
        OAuth.update(this.account, stringBuilder.toString());
    }

    private static void refreshToken(AccountData accountData) throws ApiException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("grant_type=");
        stringBuilder.append(OAuth.encode("refresh_token"));
        stringBuilder.append("&client_id=");
        stringBuilder.append(OAuth.encode(accountData.getClientId()));
        stringBuilder.append("&refresh_token=");
        stringBuilder.append(OAuth.encode(accountData.getRefreshToken()));
        OAuth.update(accountData, stringBuilder.toString());
    }

    private static void update(AccountData accountData, String string) throws ApiException {
        try {
            URL uRL = new URL(URI_ACCESS_TOKEN);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpsURLConnection.setRequestProperty("Host", "login.eveonline.com");
            httpsURLConnection.setConnectTimeout(10000);
            httpsURLConnection.setReadTimeout(10000);
            httpsURLConnection.setDoOutput(true);
            Object object = new DataOutputStream(httpsURLConnection.getOutputStream());
            Object object2 = null;
            try {
                ((DataOutputStream)object).writeBytes(string);
                ((DataOutputStream)object).flush();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((FilterOutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FilterOutputStream)object).close();
                    }
                }
            }
            object2 = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            Object object3 = null;
            try {
                String string2;
                object = new StringBuilder();
                while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                    ((StringBuilder)object).append(string2);
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
            object2 = new GsonBuilder().create();
            object3 = (Result)object2.fromJson(((StringBuilder)object).toString(), Result.class);
            long l = System.currentTimeMillis() + ((Result)object3).getExpiresIn() * 1000L - 5000L;
            ACCOUNTS.remove(accountData.getKey());
            accountData.setAccessToken(((Result)object3).getAccessToken());
            accountData.setValidUntil(l);
            accountData.setRefreshToken(((Result)object3).getRefreshToken());
            ACCOUNTS.put(accountData.getKey(), accountData);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new ApiException(jsonSyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ApiException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
    }

    private String getScopesString(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        if (set != null) {
            for (String string : set) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    private String getCodeChallenge() {
        try {
            StringBuilder stringBuilder = new StringBuilder(128);
            for (int i = 0; i < 128; ++i) {
                stringBuilder.append(AB.charAt(RND.nextInt(AB.length())));
            }
            this.codeVerifier = stringBuilder.toString();
            byte[] byArray = this.codeVerifier.getBytes(StandardCharsets.US_ASCII);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            return Base64.getUrlEncoder().encodeToString(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static class Result {
        @SerializedName(value="access_token")
        private String accessToken;
        @SerializedName(value="expires_in")
        private Long expiresIn;
        @SerializedName(value="token_type")
        private String tokenType;
        @SerializedName(value="refresh_token")
        private String refreshToken;

        private Result() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String string) {
            this.accessToken = string;
        }

        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Long l) {
            this.expiresIn = l;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String string) {
            this.tokenType = string;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String string) {
            this.refreshToken = string;
        }
    }

    private static class AccountData {
        private final String clientId;
        private String refreshToken;
        private String accessToken;
        private long validUntil = 0L;

        public AccountData(String string, String string2) {
            this.clientId = string;
            this.refreshToken = string2;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public long getValidUntil() {
            return this.validUntil;
        }

        public void setRefreshToken(String string) {
            this.refreshToken = string;
        }

        public void setAccessToken(String string) {
            this.accessToken = string;
        }

        public void setValidUntil(long l) {
            this.validUntil = l;
        }

        private synchronized void update() {
            if (this.refreshToken != null && (this.accessToken == null || this.getValidUntil() < System.currentTimeMillis())) {
                try {
                    OAuth.refreshToken(this);
                }
                catch (ApiException apiException) {
                    // empty catch block
                }
            }
        }

        public String getKey() {
            return this.clientId + this.refreshToken;
        }
    }
}

