/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterWalletJournalResponse;
import net.troja.eve.esi.model.CharacterWalletTransactionsResponse;
import net.troja.eve.esi.model.CorporationWalletJournalResponse;
import net.troja.eve.esi.model.CorporationWalletTransactionsResponse;
import net.troja.eve.esi.model.CorporationWalletsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WalletApi {
    private ApiClient apiClient;

    public WalletApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WalletApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterIdWallet
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdWalletCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/wallet/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdWalletValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdWallet(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletCall(characterId, datasource, ifNoneMatch, token,
                callback);
        return call;

    }

    /**
     * Get a character&#39;s wallet balance Returns a character&#39;s wallet
     * balance --- This route is cached for up to 120 seconds SSO Scope:
     * esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return Double
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public Double getCharactersCharacterIdWallet(Integer characterId, String datasource, String ifNoneMatch,
            String token) throws ApiException {
        ApiResponse<Double> resp = getCharactersCharacterIdWalletWithHttpInfo(characterId, datasource, ifNoneMatch,
                token);
        return resp.getData();
    }

    /**
     * Get a character&#39;s wallet balance Returns a character&#39;s wallet
     * balance --- This route is cached for up to 120 seconds SSO Scope:
     * esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Double&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Double> getCharactersCharacterIdWalletWithHttpInfo(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<Double>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a character&#39;s wallet balance (asynchronously) Returns a
     * character&#39;s wallet balance --- This route is cached for up to 120
     * seconds SSO Scope: esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdWalletAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<Double> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<Double>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdWalletJournal
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdWalletJournalCall(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v6/characters/{character_id}/wallet/journal/".replaceAll(
                "\\{" + "character_id" + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdWalletJournalValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdWalletJournal(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletJournalCall(characterId, datasource, ifNoneMatch,
                page, token, callback);
        return call;

    }

    /**
     * Get character wallet journal Retrieve the given character&#39;s wallet
     * journal going 30 days back --- This route is cached for up to 3600
     * seconds SSO Scope: esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterWalletJournalResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterWalletJournalResponse> getCharactersCharacterIdWalletJournal(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterWalletJournalResponse>> resp = getCharactersCharacterIdWalletJournalWithHttpInfo(
                characterId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get character wallet journal Retrieve the given character&#39;s wallet
     * journal going 30 days back --- This route is cached for up to 3600
     * seconds SSO Scope: esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterWalletJournalResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterWalletJournalResponse>> getCharactersCharacterIdWalletJournalWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletJournalValidateBeforeCall(characterId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterWalletJournalResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character wallet journal (asynchronously) Retrieve the given
     * character&#39;s wallet journal going 30 days back --- This route is
     * cached for up to 3600 seconds SSO Scope:
     * esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdWalletJournalAsync(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CharacterWalletJournalResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletJournalValidateBeforeCall(characterId,
                datasource, ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterWalletJournalResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdWalletTransactions
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show transactions happened before the one referenced by
     *            this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdWalletTransactionsCall(Integer characterId,
            String datasource, Long fromId, String ifNoneMatch, String token, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/wallet/transactions/".replaceAll("\\{" + "character_id"
                + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (fromId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("from_id", fromId));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdWalletTransactionsValidateBeforeCall(Integer characterId,
            String datasource, Long fromId, String ifNoneMatch, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdWalletTransactions(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletTransactionsCall(characterId, datasource, fromId,
                ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get wallet transactions Get wallet transactions of a character --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show transactions happened before the one referenced by
     *            this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterWalletTransactionsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterWalletTransactionsResponse> getCharactersCharacterIdWalletTransactions(Integer characterId,
            String datasource, Long fromId, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterWalletTransactionsResponse>> resp = getCharactersCharacterIdWalletTransactionsWithHttpInfo(
                characterId, datasource, fromId, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get wallet transactions Get wallet transactions of a character --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show transactions happened before the one referenced by
     *            this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return 
     *         ApiResponse&lt;List&lt;CharacterWalletTransactionsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterWalletTransactionsResponse>> getCharactersCharacterIdWalletTransactionsWithHttpInfo(
            Integer characterId, String datasource, Long fromId, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletTransactionsValidateBeforeCall(characterId,
                datasource, fromId, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterWalletTransactionsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get wallet transactions (asynchronously) Get wallet transactions of a
     * character --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-wallet.read_character_wallet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show transactions happened before the one referenced by
     *            this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdWalletTransactionsAsync(Integer characterId,
            String datasource, Long fromId, String ifNoneMatch, String token,
            final ApiCallback<List<CharacterWalletTransactionsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdWalletTransactionsValidateBeforeCall(characterId,
                datasource, fromId, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterWalletTransactionsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdWallets
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdWalletsCall(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/wallets/".replaceAll("\\{" + "corporation_id" + "\\}",
                apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdWalletsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdWallets(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsCall(corporationId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Returns a corporation&#39;s wallet balance Get a corporation&#39;s
     * wallets --- This route is cached for up to 300 seconds --- Requires one
     * of the following EVE corporation role(s): Accountant, Junior_Accountant
     * SSO Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationWalletsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationWalletsResponse> getCorporationsCorporationIdWallets(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationWalletsResponse>> resp = getCorporationsCorporationIdWalletsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Returns a corporation&#39;s wallet balance Get a corporation&#39;s
     * wallets --- This route is cached for up to 300 seconds --- Requires one
     * of the following EVE corporation role(s): Accountant, Junior_Accountant
     * SSO Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationWalletsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationWalletsResponse>> getCorporationsCorporationIdWalletsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationWalletsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Returns a corporation&#39;s wallet balance (asynchronously) Get a
     * corporation&#39;s wallets --- This route is cached for up to 300 seconds
     * --- Requires one of the following EVE corporation role(s): Accountant,
     * Junior_Accountant SSO Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdWalletsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CorporationWalletsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationWalletsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdWalletsDivisionJournal
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdWalletsDivisionJournalCall(Integer corporationId,
            Integer division, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v4/corporations/{corporation_id}/wallets/{division}/journal/".replaceAll(
                "\\{" + "corporation_id" + "\\}", apiClient.escapeString(corporationId.toString())).replaceAll(
                "\\{" + "division" + "\\}", apiClient.escapeString(division.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdWalletsDivisionJournalValidateBeforeCall(
            Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdWalletsDivisionJournal(Async)");
        }

        // verify the required parameter 'division' is set
        if (division == null) {
            throw new ApiException(
                    "Missing the required parameter 'division' when calling getCorporationsCorporationIdWalletsDivisionJournal(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsDivisionJournalCall(corporationId, division,
                datasource, ifNoneMatch, page, token, callback);
        return call;

    }

    /**
     * Get corporation wallet journal Retrieve the given corporation&#39;s
     * wallet journal for the given division going 30 days back --- This route
     * is cached for up to 3600 seconds --- Requires one of the following EVE
     * corporation role(s): Accountant, Junior_Accountant SSO Scope:
     * esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationWalletJournalResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationWalletJournalResponse> getCorporationsCorporationIdWalletsDivisionJournal(
            Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        ApiResponse<List<CorporationWalletJournalResponse>> resp = getCorporationsCorporationIdWalletsDivisionJournalWithHttpInfo(
                corporationId, division, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get corporation wallet journal Retrieve the given corporation&#39;s
     * wallet journal for the given division going 30 days back --- This route
     * is cached for up to 3600 seconds --- Requires one of the following EVE
     * corporation role(s): Accountant, Junior_Accountant SSO Scope:
     * esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationWalletJournalResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationWalletJournalResponse>> getCorporationsCorporationIdWalletsDivisionJournalWithHttpInfo(
            Integer corporationId, Integer division, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsDivisionJournalValidateBeforeCall(
                corporationId, division, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationWalletJournalResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation wallet journal (asynchronously) Retrieve the given
     * corporation&#39;s wallet journal for the given division going 30 days
     * back --- This route is cached for up to 3600 seconds --- Requires one of
     * the following EVE corporation role(s): Accountant, Junior_Accountant SSO
     * Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdWalletsDivisionJournalAsync(Integer corporationId,
            Integer division, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationWalletJournalResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsDivisionJournalValidateBeforeCall(
                corporationId, division, datasource, ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationWalletJournalResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdWalletsDivisionTransactions
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show journal entries happened before the transaction
     *            referenced by this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdWalletsDivisionTransactionsCall(Integer corporationId,
            Integer division, String datasource, Long fromId, String ifNoneMatch, String token,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/wallets/{division}/transactions/".replaceAll(
                "\\{" + "corporation_id" + "\\}", apiClient.escapeString(corporationId.toString())).replaceAll(
                "\\{" + "division" + "\\}", apiClient.escapeString(division.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (fromId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("from_id", fromId));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdWalletsDivisionTransactionsValidateBeforeCall(
            Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdWalletsDivisionTransactions(Async)");
        }

        // verify the required parameter 'division' is set
        if (division == null) {
            throw new ApiException(
                    "Missing the required parameter 'division' when calling getCorporationsCorporationIdWalletsDivisionTransactions(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsDivisionTransactionsCall(corporationId,
                division, datasource, fromId, ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get corporation wallet transactions Get wallet transactions of a
     * corporation --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Accountant,
     * Junior_Accountant SSO Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show journal entries happened before the transaction
     *            referenced by this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationWalletTransactionsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationWalletTransactionsResponse> getCorporationsCorporationIdWalletsDivisionTransactions(
            Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token)
            throws ApiException {
        ApiResponse<List<CorporationWalletTransactionsResponse>> resp = getCorporationsCorporationIdWalletsDivisionTransactionsWithHttpInfo(
                corporationId, division, datasource, fromId, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get corporation wallet transactions Get wallet transactions of a
     * corporation --- This route is cached for up to 3600 seconds --- Requires
     * one of the following EVE corporation role(s): Accountant,
     * Junior_Accountant SSO Scope: esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show journal entries happened before the transaction
     *            referenced by this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return 
     *         ApiResponse&lt;List&lt;CorporationWalletTransactionsResponse&gt;&gt
     *         ;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationWalletTransactionsResponse>> getCorporationsCorporationIdWalletsDivisionTransactionsWithHttpInfo(
            Integer corporationId, Integer division, String datasource, Long fromId, String ifNoneMatch, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsDivisionTransactionsValidateBeforeCall(
                corporationId, division, datasource, fromId, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationWalletTransactionsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation wallet transactions (asynchronously) Get wallet
     * transactions of a corporation --- This route is cached for up to 3600
     * seconds --- Requires one of the following EVE corporation role(s):
     * Accountant, Junior_Accountant SSO Scope:
     * esi-wallet.read_corporation_wallets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param division
     *            Wallet key of the division to fetch journals from (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param fromId
     *            Only show journal entries happened before the transaction
     *            referenced by this id (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdWalletsDivisionTransactionsAsync(Integer corporationId,
            Integer division, String datasource, Long fromId, String ifNoneMatch, String token,
            final ApiCallback<List<CorporationWalletTransactionsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdWalletsDivisionTransactionsValidateBeforeCall(
                corporationId, division, datasource, fromId, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationWalletTransactionsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
