/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterSearchResponse;
import net.troja.eve.esi.model.SearchResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchApi {
    private ApiClient apiClient;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterIdSearch
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param characterId
     *            An EVE character ID (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdSearchCall(List<String> categories, Integer characterId,
            String search, String acceptLanguage, String datasource, String ifNoneMatch, String language,
            Boolean strict, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/characters/{character_id}/search/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (categories != null) {
            localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "categories", categories));
        }

        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        if (search != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        }

        if (strict != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("strict", strict));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdSearchValidateBeforeCall(List<String> categories,
            Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch,
            String language, Boolean strict, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'categories' is set
        if (categories == null) {
            throw new ApiException(
                    "Missing the required parameter 'categories' when calling getCharactersCharacterIdSearch(Async)");
        }

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdSearch(Async)");
        }

        // verify the required parameter 'search' is set
        if (search == null) {
            throw new ApiException(
                    "Missing the required parameter 'search' when calling getCharactersCharacterIdSearch(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdSearchCall(categories, characterId, search,
                acceptLanguage, datasource, ifNoneMatch, language, strict, token, callback);
        return call;

    }

    /**
     * Search on a string Search for entities that match a given sub-string. ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-search.search_structures.v1
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param characterId
     *            An EVE character ID (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return CharacterSearchResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CharacterSearchResponse getCharactersCharacterIdSearch(List<String> categories, Integer characterId,
            String search, String acceptLanguage, String datasource, String ifNoneMatch, String language,
            Boolean strict, String token) throws ApiException {
        ApiResponse<CharacterSearchResponse> resp = getCharactersCharacterIdSearchWithHttpInfo(categories, characterId,
                search, acceptLanguage, datasource, ifNoneMatch, language, strict, token);
        return resp.getData();
    }

    /**
     * Search on a string Search for entities that match a given sub-string. ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-search.search_structures.v1
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param characterId
     *            An EVE character ID (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;CharacterSearchResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CharacterSearchResponse> getCharactersCharacterIdSearchWithHttpInfo(List<String> categories,
            Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch,
            String language, Boolean strict, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdSearchValidateBeforeCall(categories, characterId,
                search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, null);
        Type localVarReturnType = new TypeToken<CharacterSearchResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search on a string (asynchronously) Search for entities that match a
     * given sub-string. --- This route is cached for up to 3600 seconds SSO
     * Scope: esi-search.search_structures.v1
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param characterId
     *            An EVE character ID (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdSearchAsync(List<String> categories, Integer characterId,
            String search, String acceptLanguage, String datasource, String ifNoneMatch, String language,
            Boolean strict, String token, final ApiCallback<CharacterSearchResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdSearchValidateBeforeCall(categories, characterId,
                search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, callback);
        Type localVarReturnType = new TypeToken<CharacterSearchResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getSearch
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSearchCall(List<String> categories, String search, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, Boolean strict, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/search/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (categories != null) {
            localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "categories", categories));
        }

        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        if (search != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
        }

        if (strict != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("strict", strict));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSearchValidateBeforeCall(List<String> categories, String search,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'categories' is set
        if (categories == null) {
            throw new ApiException("Missing the required parameter 'categories' when calling getSearch(Async)");
        }

        // verify the required parameter 'search' is set
        if (search == null) {
            throw new ApiException("Missing the required parameter 'search' when calling getSearch(Async)");
        }

        com.squareup.okhttp.Call call = getSearchCall(categories, search, acceptLanguage, datasource, ifNoneMatch,
                language, strict, callback);
        return call;

    }

    /**
     * Search on a string Search for entities that match a given sub-string. ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-search.search_structures.v1
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @return SearchResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public SearchResponse getSearch(List<String> categories, String search, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, Boolean strict) throws ApiException {
        ApiResponse<SearchResponse> resp = getSearchWithHttpInfo(categories, search, acceptLanguage, datasource,
                ifNoneMatch, language, strict);
        return resp.getData();
    }

    /**
     * Search on a string Search for entities that match a given sub-string. ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-search.search_structures.v1
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @return ApiResponse&lt;SearchResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<SearchResponse> getSearchWithHttpInfo(List<String> categories, String search,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict)
            throws ApiException {
        com.squareup.okhttp.Call call = getSearchValidateBeforeCall(categories, search, acceptLanguage, datasource,
                ifNoneMatch, language, strict, null);
        Type localVarReturnType = new TypeToken<SearchResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search on a string (asynchronously) Search for entities that match a
     * given sub-string. --- This route is cached for up to 3600 seconds SSO
     * Scope: esi-search.search_structures.v1
     * 
     * @param categories
     *            Type of entities to search for (required)
     * @param search
     *            The string to search on (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param strict
     *            Whether the search should be a strict match (optional, default
     *            to false)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getSearchAsync(List<String> categories, String search, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, Boolean strict,
            final ApiCallback<SearchResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getSearchValidateBeforeCall(categories, search, acceptLanguage, datasource,
                ifNoneMatch, language, strict, callback);
        Type localVarReturnType = new TypeToken<SearchResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
