/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterMailinglistsResponse;
import net.troja.eve.esi.model.Mail;
import net.troja.eve.esi.model.MailHeadersResponse;
import net.troja.eve.esi.model.MailLabelSimple;
import net.troja.eve.esi.model.MailLabelsResponse;
import net.troja.eve.esi.model.MailMetaData;
import net.troja.eve.esi.model.MailResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MailApi {
    private ApiClient apiClient;

    public MailApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MailApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteCharactersCharacterIdMailLabelsLabelId
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param labelId
     *            An EVE label id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCharactersCharacterIdMailLabelsLabelIdCall(Integer characterId,
            Integer labelId, String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/labels/{label_id}/".replaceAll(
                "\\{" + "character_id" + "\\}", apiClient.escapeString(characterId.toString())).replaceAll(
                "\\{" + "label_id" + "\\}", apiClient.escapeString(labelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCharactersCharacterIdMailLabelsLabelIdValidateBeforeCall(
            Integer characterId, Integer labelId, String datasource, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling deleteCharactersCharacterIdMailLabelsLabelId(Async)");
        }

        // verify the required parameter 'labelId' is set
        if (labelId == null) {
            throw new ApiException(
                    "Missing the required parameter 'labelId' when calling deleteCharactersCharacterIdMailLabelsLabelId(Async)");
        }

        com.squareup.okhttp.Call call = deleteCharactersCharacterIdMailLabelsLabelIdCall(characterId, labelId,
                datasource, token, callback);
        return call;

    }

    /**
     * Delete a mail label Delete a mail label --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param labelId
     *            An EVE label id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void deleteCharactersCharacterIdMailLabelsLabelId(Integer characterId, Integer labelId, String datasource,
            String token) throws ApiException {
        deleteCharactersCharacterIdMailLabelsLabelIdWithHttpInfo(characterId, labelId, datasource, token);
    }

    /**
     * Delete a mail label Delete a mail label --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param labelId
     *            An EVE label id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> deleteCharactersCharacterIdMailLabelsLabelIdWithHttpInfo(Integer characterId,
            Integer labelId, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = deleteCharactersCharacterIdMailLabelsLabelIdValidateBeforeCall(characterId,
                labelId, datasource, token, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a mail label (asynchronously) Delete a mail label --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param labelId
     *            An EVE label id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call deleteCharactersCharacterIdMailLabelsLabelIdAsync(Integer characterId,
            Integer labelId, String datasource, String token, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = deleteCharactersCharacterIdMailLabelsLabelIdValidateBeforeCall(characterId,
                labelId, datasource, token, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for deleteCharactersCharacterIdMailMailId
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCharactersCharacterIdMailMailIdCall(Integer characterId, Integer mailId,
            String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/{mail_id}/".replaceAll(
                "\\{" + "character_id" + "\\}", apiClient.escapeString(characterId.toString())).replaceAll(
                "\\{" + "mail_id" + "\\}", apiClient.escapeString(mailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCharactersCharacterIdMailMailIdValidateBeforeCall(Integer characterId,
            Integer mailId, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling deleteCharactersCharacterIdMailMailId(Async)");
        }

        // verify the required parameter 'mailId' is set
        if (mailId == null) {
            throw new ApiException(
                    "Missing the required parameter 'mailId' when calling deleteCharactersCharacterIdMailMailId(Async)");
        }

        com.squareup.okhttp.Call call = deleteCharactersCharacterIdMailMailIdCall(characterId, mailId, datasource,
                token, callback);
        return call;

    }

    /**
     * Delete a mail Delete a mail --- SSO Scope: esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void deleteCharactersCharacterIdMailMailId(Integer characterId, Integer mailId, String datasource,
            String token) throws ApiException {
        deleteCharactersCharacterIdMailMailIdWithHttpInfo(characterId, mailId, datasource, token);
    }

    /**
     * Delete a mail Delete a mail --- SSO Scope: esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> deleteCharactersCharacterIdMailMailIdWithHttpInfo(Integer characterId, Integer mailId,
            String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = deleteCharactersCharacterIdMailMailIdValidateBeforeCall(characterId, mailId,
                datasource, token, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a mail (asynchronously) Delete a mail --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call deleteCharactersCharacterIdMailMailIdAsync(Integer characterId, Integer mailId,
            String datasource, String token, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = deleteCharactersCharacterIdMailMailIdValidateBeforeCall(characterId, mailId,
                datasource, token, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdMail
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param labels
     *            Fetch only mails that match one or more of the given labels
     *            (optional)
     * @param lastMailId
     *            List only mail with an ID lower than the given ID, if present
     *            (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailCall(Integer characterId, String datasource,
            String ifNoneMatch, List<Integer> labels, Integer lastMailId, String token, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (labels != null) {
            localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "labels", labels));
        }

        if (lastMailId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("last_mail_id", lastMailId));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdMailValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, List<Integer> labels, Integer lastMailId, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdMail(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailCall(characterId, datasource, ifNoneMatch, labels,
                lastMailId, token, callback);
        return call;

    }

    /**
     * Return mail headers Return the 50 most recent mail headers belonging to
     * the character that match the query criteria. Queries can be filtered by
     * label, and last_mail_id can be used to paginate backwards --- This route
     * is cached for up to 30 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param labels
     *            Fetch only mails that match one or more of the given labels
     *            (optional)
     * @param lastMailId
     *            List only mail with an ID lower than the given ID, if present
     *            (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;MailHeadersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<MailHeadersResponse> getCharactersCharacterIdMail(Integer characterId, String datasource,
            String ifNoneMatch, List<Integer> labels, Integer lastMailId, String token) throws ApiException {
        ApiResponse<List<MailHeadersResponse>> resp = getCharactersCharacterIdMailWithHttpInfo(characterId, datasource,
                ifNoneMatch, labels, lastMailId, token);
        return resp.getData();
    }

    /**
     * Return mail headers Return the 50 most recent mail headers belonging to
     * the character that match the query criteria. Queries can be filtered by
     * label, and last_mail_id can be used to paginate backwards --- This route
     * is cached for up to 30 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param labels
     *            Fetch only mails that match one or more of the given labels
     *            (optional)
     * @param lastMailId
     *            List only mail with an ID lower than the given ID, if present
     *            (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;MailHeadersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<MailHeadersResponse>> getCharactersCharacterIdMailWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, List<Integer> labels, Integer lastMailId, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdMailValidateBeforeCall(characterId, datasource,
                ifNoneMatch, labels, lastMailId, token, null);
        Type localVarReturnType = new TypeToken<List<MailHeadersResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return mail headers (asynchronously) Return the 50 most recent mail
     * headers belonging to the character that match the query criteria. Queries
     * can be filtered by label, and last_mail_id can be used to paginate
     * backwards --- This route is cached for up to 30 seconds SSO Scope:
     * esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param labels
     *            Fetch only mails that match one or more of the given labels
     *            (optional)
     * @param lastMailId
     *            List only mail with an ID lower than the given ID, if present
     *            (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailAsync(Integer characterId, String datasource,
            String ifNoneMatch, List<Integer> labels, Integer lastMailId, String token,
            final ApiCallback<List<MailHeadersResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailValidateBeforeCall(characterId, datasource,
                ifNoneMatch, labels, lastMailId, token, callback);
        Type localVarReturnType = new TypeToken<List<MailHeadersResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdMailLabels
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailLabelsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/characters/{character_id}/mail/labels/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdMailLabelsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdMailLabels(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailLabelsCall(characterId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get mail labels and unread counts Return a list of the users mail labels,
     * unread counts for each label and a total unread count. --- This route is
     * cached for up to 30 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return MailLabelsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public MailLabelsResponse getCharactersCharacterIdMailLabels(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<MailLabelsResponse> resp = getCharactersCharacterIdMailLabelsWithHttpInfo(characterId, datasource,
                ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get mail labels and unread counts Return a list of the users mail labels,
     * unread counts for each label and a total unread count. --- This route is
     * cached for up to 30 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;MailLabelsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<MailLabelsResponse> getCharactersCharacterIdMailLabelsWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdMailLabelsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<MailLabelsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get mail labels and unread counts (asynchronously) Return a list of the
     * users mail labels, unread counts for each label and a total unread count.
     * --- This route is cached for up to 30 seconds SSO Scope:
     * esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailLabelsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<MailLabelsResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailLabelsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<MailLabelsResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdMailLists
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailListsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/lists/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdMailListsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdMailLists(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailListsCall(characterId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Return mailing list subscriptions Return all mailing lists that the
     * character is subscribed to --- This route is cached for up to 120 seconds
     * SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterMailinglistsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterMailinglistsResponse> getCharactersCharacterIdMailLists(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterMailinglistsResponse>> resp = getCharactersCharacterIdMailListsWithHttpInfo(
                characterId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Return mailing list subscriptions Return all mailing lists that the
     * character is subscribed to --- This route is cached for up to 120 seconds
     * SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterMailinglistsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterMailinglistsResponse>> getCharactersCharacterIdMailListsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdMailListsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterMailinglistsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return mailing list subscriptions (asynchronously) Return all mailing
     * lists that the character is subscribed to --- This route is cached for up
     * to 120 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailListsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterMailinglistsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailListsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterMailinglistsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdMailMailId
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailMailIdCall(Integer characterId, Integer mailId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/{mail_id}/".replaceAll(
                "\\{" + "character_id" + "\\}", apiClient.escapeString(characterId.toString())).replaceAll(
                "\\{" + "mail_id" + "\\}", apiClient.escapeString(mailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdMailMailIdValidateBeforeCall(Integer characterId,
            Integer mailId, String datasource, String ifNoneMatch, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdMailMailId(Async)");
        }

        // verify the required parameter 'mailId' is set
        if (mailId == null) {
            throw new ApiException(
                    "Missing the required parameter 'mailId' when calling getCharactersCharacterIdMailMailId(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailMailIdCall(characterId, mailId, datasource,
                ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Return a mail Return the contents of an EVE mail --- This route is cached
     * for up to 30 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return MailResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public MailResponse getCharactersCharacterIdMailMailId(Integer characterId, Integer mailId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<MailResponse> resp = getCharactersCharacterIdMailMailIdWithHttpInfo(characterId, mailId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Return a mail Return the contents of an EVE mail --- This route is cached
     * for up to 30 seconds SSO Scope: esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;MailResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<MailResponse> getCharactersCharacterIdMailMailIdWithHttpInfo(Integer characterId,
            Integer mailId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdMailMailIdValidateBeforeCall(characterId, mailId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<MailResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Return a mail (asynchronously) Return the contents of an EVE mail ---
     * This route is cached for up to 30 seconds SSO Scope:
     * esi-mail.read_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMailMailIdAsync(Integer characterId, Integer mailId,
            String datasource, String ifNoneMatch, String token, final ApiCallback<MailResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdMailMailIdValidateBeforeCall(characterId, mailId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<MailResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersCharacterIdMail
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mail
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdMailCall(Integer characterId, String datasource,
            String token, Mail mail, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = mail;

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersCharacterIdMailValidateBeforeCall(Integer characterId,
            String datasource, String token, Mail mail, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling postCharactersCharacterIdMail(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersCharacterIdMailCall(characterId, datasource, token, mail,
                callback);
        return call;

    }

    /**
     * Send a new mail Create and send a new mail --- SSO Scope:
     * esi-mail.send_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mail
     *            (optional)
     * @return Integer
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public Integer postCharactersCharacterIdMail(Integer characterId, String datasource, String token, Mail mail)
            throws ApiException {
        ApiResponse<Integer> resp = postCharactersCharacterIdMailWithHttpInfo(characterId, datasource, token, mail);
        return resp.getData();
    }

    /**
     * Send a new mail Create and send a new mail --- SSO Scope:
     * esi-mail.send_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mail
     *            (optional)
     * @return ApiResponse&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Integer> postCharactersCharacterIdMailWithHttpInfo(Integer characterId, String datasource,
            String token, Mail mail) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersCharacterIdMailValidateBeforeCall(characterId, datasource, token,
                mail, null);
        Type localVarReturnType = new TypeToken<Integer>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Send a new mail (asynchronously) Create and send a new mail --- SSO
     * Scope: esi-mail.send_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mail
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdMailAsync(Integer characterId, String datasource,
            String token, Mail mail, final ApiCallback<Integer> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersCharacterIdMailValidateBeforeCall(characterId, datasource, token,
                mail, callback);
        Type localVarReturnType = new TypeToken<Integer>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersCharacterIdMailLabels
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailLabelSimple
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdMailLabelsCall(Integer characterId, String datasource,
            String token, MailLabelSimple mailLabelSimple, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = mailLabelSimple;

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/mail/labels/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersCharacterIdMailLabelsValidateBeforeCall(Integer characterId,
            String datasource, String token, MailLabelSimple mailLabelSimple, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling postCharactersCharacterIdMailLabels(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersCharacterIdMailLabelsCall(characterId, datasource, token,
                mailLabelSimple, callback);
        return call;

    }

    /**
     * Create a mail label Create a mail label --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailLabelSimple
     *            (optional)
     * @return Integer
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public Integer postCharactersCharacterIdMailLabels(Integer characterId, String datasource, String token,
            MailLabelSimple mailLabelSimple) throws ApiException {
        ApiResponse<Integer> resp = postCharactersCharacterIdMailLabelsWithHttpInfo(characterId, datasource, token,
                mailLabelSimple);
        return resp.getData();
    }

    /**
     * Create a mail label Create a mail label --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailLabelSimple
     *            (optional)
     * @return ApiResponse&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Integer> postCharactersCharacterIdMailLabelsWithHttpInfo(Integer characterId, String datasource,
            String token, MailLabelSimple mailLabelSimple) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersCharacterIdMailLabelsValidateBeforeCall(characterId, datasource,
                token, mailLabelSimple, null);
        Type localVarReturnType = new TypeToken<Integer>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a mail label (asynchronously) Create a mail label --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailLabelSimple
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdMailLabelsAsync(Integer characterId, String datasource,
            String token, MailLabelSimple mailLabelSimple, final ApiCallback<Integer> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersCharacterIdMailLabelsValidateBeforeCall(characterId, datasource,
                token, mailLabelSimple, callback);
        Type localVarReturnType = new TypeToken<Integer>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for putCharactersCharacterIdMailMailId
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailMetaData
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call putCharactersCharacterIdMailMailIdCall(Integer characterId, Integer mailId,
            String datasource, String token, MailMetaData mailMetaData, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = mailMetaData;

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mail/{mail_id}/".replaceAll(
                "\\{" + "character_id" + "\\}", apiClient.escapeString(characterId.toString())).replaceAll(
                "\\{" + "mail_id" + "\\}", apiClient.escapeString(mailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call putCharactersCharacterIdMailMailIdValidateBeforeCall(Integer characterId,
            Integer mailId, String datasource, String token, MailMetaData mailMetaData, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling putCharactersCharacterIdMailMailId(Async)");
        }

        // verify the required parameter 'mailId' is set
        if (mailId == null) {
            throw new ApiException(
                    "Missing the required parameter 'mailId' when calling putCharactersCharacterIdMailMailId(Async)");
        }

        com.squareup.okhttp.Call call = putCharactersCharacterIdMailMailIdCall(characterId, mailId, datasource, token,
                mailMetaData, callback);
        return call;

    }

    /**
     * Update metadata about a mail Update metadata about a mail --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailMetaData
     *            (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void putCharactersCharacterIdMailMailId(Integer characterId, Integer mailId, String datasource,
            String token, MailMetaData mailMetaData) throws ApiException {
        putCharactersCharacterIdMailMailIdWithHttpInfo(characterId, mailId, datasource, token, mailMetaData);
    }

    /**
     * Update metadata about a mail Update metadata about a mail --- SSO Scope:
     * esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailMetaData
     *            (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> putCharactersCharacterIdMailMailIdWithHttpInfo(Integer characterId, Integer mailId,
            String datasource, String token, MailMetaData mailMetaData) throws ApiException {
        com.squareup.okhttp.Call call = putCharactersCharacterIdMailMailIdValidateBeforeCall(characterId, mailId,
                datasource, token, mailMetaData, null);
        return apiClient.execute(call);
    }

    /**
     * Update metadata about a mail (asynchronously) Update metadata about a
     * mail --- SSO Scope: esi-mail.organize_mail.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param mailId
     *            An EVE mail ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param mailMetaData
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call putCharactersCharacterIdMailMailIdAsync(Integer characterId, Integer mailId,
            String datasource, String token, MailMetaData mailMetaData, final ApiCallback<Void> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = putCharactersCharacterIdMailMailIdValidateBeforeCall(characterId, mailId,
                datasource, token, mailMetaData, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
