/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.AllianceIconsResponse;
import net.troja.eve.esi.model.AllianceResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllianceApi {
    private ApiClient apiClient;

    public AllianceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AllianceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getAlliances
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAlliancesCall(String datasource, String ifNoneMatch, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/alliances/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAlliancesValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * List all alliances List all active player alliances --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getAlliances(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getAlliancesWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * List all alliances List all active player alliances --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getAlliancesWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getAlliancesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List all alliances (asynchronously) List all active player alliances ---
     * This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getAlliancesAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getAlliancesAllianceId
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdCall(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/alliances/{alliance_id}/".replaceAll("\\{" + "alliance_id" + "\\}",
                apiClient.escapeString(allianceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAlliancesAllianceIdValidateBeforeCall(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'allianceId' is set
        if (allianceId == null) {
            throw new ApiException(
                    "Missing the required parameter 'allianceId' when calling getAlliancesAllianceId(Async)");
        }

        com.squareup.okhttp.Call call = getAlliancesAllianceIdCall(allianceId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get alliance information Public information about an alliance --- This
     * route is cached for up to 3600 seconds
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return AllianceResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public AllianceResponse getAlliancesAllianceId(Integer allianceId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<AllianceResponse> resp = getAlliancesAllianceIdWithHttpInfo(allianceId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get alliance information Public information about an alliance --- This
     * route is cached for up to 3600 seconds
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;AllianceResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<AllianceResponse> getAlliancesAllianceIdWithHttpInfo(Integer allianceId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getAlliancesAllianceIdValidateBeforeCall(allianceId, datasource, ifNoneMatch,
                null);
        Type localVarReturnType = new TypeToken<AllianceResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get alliance information (asynchronously) Public information about an
     * alliance --- This route is cached for up to 3600 seconds
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdAsync(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback<AllianceResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesAllianceIdValidateBeforeCall(allianceId, datasource, ifNoneMatch,
                callback);
        Type localVarReturnType = new TypeToken<AllianceResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getAlliancesAllianceIdCorporations
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdCorporationsCall(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/alliances/{alliance_id}/corporations/".replaceAll("\\{" + "alliance_id" + "\\}",
                apiClient.escapeString(allianceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAlliancesAllianceIdCorporationsValidateBeforeCall(Integer allianceId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'allianceId' is set
        if (allianceId == null) {
            throw new ApiException(
                    "Missing the required parameter 'allianceId' when calling getAlliancesAllianceIdCorporations(Async)");
        }

        com.squareup.okhttp.Call call = getAlliancesAllianceIdCorporationsCall(allianceId, datasource, ifNoneMatch,
                callback);
        return call;

    }

    /**
     * List alliance&#39;s corporations List all current member corporations of
     * an alliance --- This route is cached for up to 3600 seconds
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getAlliancesAllianceIdCorporations(Integer allianceId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<List<Integer>> resp = getAlliancesAllianceIdCorporationsWithHttpInfo(allianceId, datasource,
                ifNoneMatch);
        return resp.getData();
    }

    /**
     * List alliance&#39;s corporations List all current member corporations of
     * an alliance --- This route is cached for up to 3600 seconds
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getAlliancesAllianceIdCorporationsWithHttpInfo(Integer allianceId,
            String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getAlliancesAllianceIdCorporationsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List alliance&#39;s corporations (asynchronously) List all current member
     * corporations of an alliance --- This route is cached for up to 3600
     * seconds
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdCorporationsAsync(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesAllianceIdCorporationsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getAlliancesAllianceIdIcons
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdIconsCall(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/alliances/{alliance_id}/icons/".replaceAll("\\{" + "alliance_id" + "\\}",
                apiClient.escapeString(allianceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAlliancesAllianceIdIconsValidateBeforeCall(Integer allianceId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'allianceId' is set
        if (allianceId == null) {
            throw new ApiException(
                    "Missing the required parameter 'allianceId' when calling getAlliancesAllianceIdIcons(Async)");
        }

        com.squareup.okhttp.Call call = getAlliancesAllianceIdIconsCall(allianceId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get alliance icon Get the icon urls for a alliance --- This route expires
     * daily at 11:05
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return AllianceIconsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public AllianceIconsResponse getAlliancesAllianceIdIcons(Integer allianceId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<AllianceIconsResponse> resp = getAlliancesAllianceIdIconsWithHttpInfo(allianceId, datasource,
                ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get alliance icon Get the icon urls for a alliance --- This route expires
     * daily at 11:05
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;AllianceIconsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<AllianceIconsResponse> getAlliancesAllianceIdIconsWithHttpInfo(Integer allianceId,
            String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getAlliancesAllianceIdIconsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<AllianceIconsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get alliance icon (asynchronously) Get the icon urls for a alliance ---
     * This route expires daily at 11:05
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdIconsAsync(Integer allianceId, String datasource,
            String ifNoneMatch, final ApiCallback<AllianceIconsResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesAllianceIdIconsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<AllianceIconsResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
