/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class SovereigntyStructuresResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_STRUCTURE_TYPE_ID = "structure_type_id";
    @SerializedName(value="structure_type_id")
    private Integer structureTypeId;
    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(value="alliance_id")
    private Integer allianceId;
    public static final String SERIALIZED_NAME_VULNERABLE_START_TIME = "vulnerable_start_time";
    @SerializedName(value="vulnerable_start_time")
    private OffsetDateTime vulnerableStartTime;
    public static final String SERIALIZED_NAME_VULNERABLE_END_TIME = "vulnerable_end_time";
    @SerializedName(value="vulnerable_end_time")
    private OffsetDateTime vulnerableEndTime;
    public static final String SERIALIZED_NAME_VULNERABILITY_OCCUPANCY_LEVEL = "vulnerability_occupancy_level";
    @SerializedName(value="vulnerability_occupancy_level")
    private Float vulnerabilityOccupancyLevel;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_STRUCTURE_ID = "structure_id";
    @SerializedName(value="structure_id")
    private Long structureId;

    public SovereigntyStructuresResponse structureTypeId(Integer n) {
        this.structureTypeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference to the type of structure this is. ")
    public Integer getStructureTypeId() {
        return this.structureTypeId;
    }

    public void setStructureTypeId(Integer n) {
        this.structureTypeId = n;
    }

    public SovereigntyStructuresResponse allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The alliance that owns the structure. ")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public SovereigntyStructuresResponse vulnerableStartTime(OffsetDateTime offsetDateTime) {
        this.vulnerableStartTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="The next time at which the structure will become vulnerable. Or the start time of the current window if current time is between this and vulnerableEndTime. ")
    public OffsetDateTime getVulnerableStartTime() {
        return this.vulnerableStartTime;
    }

    public void setVulnerableStartTime(OffsetDateTime offsetDateTime) {
        this.vulnerableStartTime = offsetDateTime;
    }

    public SovereigntyStructuresResponse vulnerableEndTime(OffsetDateTime offsetDateTime) {
        this.vulnerableEndTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(value="The time at which the next or current vulnerability window ends. At the end of a vulnerability window the next window is recalculated and locked in along with the vulnerabilityOccupancyLevel. If the structure is not in 100% entosis control of the defender, it will go in to 'overtime' and stay vulnerable for as long as that situation persists. Only once the defenders have 100% entosis control and has the vulnerableEndTime passed does the vulnerability interval expire and a new one is calculated. ")
    public OffsetDateTime getVulnerableEndTime() {
        return this.vulnerableEndTime;
    }

    public void setVulnerableEndTime(OffsetDateTime offsetDateTime) {
        this.vulnerableEndTime = offsetDateTime;
    }

    public SovereigntyStructuresResponse vulnerabilityOccupancyLevel(Float f) {
        this.vulnerabilityOccupancyLevel = f;
        return this;
    }

    @ApiModelProperty(value="The occupancy level for the next or current vulnerability window. This takes into account all development indexes and capital system bonuses. Also known as Activity Defense Multiplier from in the client. It increases the time that attackers must spend using their entosis links on the structure. ")
    public Float getVulnerabilityOccupancyLevel() {
        return this.vulnerabilityOccupancyLevel;
    }

    public void setVulnerabilityOccupancyLevel(Float f) {
        this.vulnerabilityOccupancyLevel = f;
    }

    public SovereigntyStructuresResponse solarSystemId(Integer n) {
        this.solarSystemId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Solar system in which the structure is located. ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer n) {
        this.solarSystemId = n;
    }

    public SovereigntyStructuresResponse structureId(Long l) {
        this.structureId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique item ID for this structure.")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long l) {
        this.structureId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SovereigntyStructuresResponse sovereigntyStructuresResponse = (SovereigntyStructuresResponse)object;
        return Objects.equals(this.structureTypeId, sovereigntyStructuresResponse.structureTypeId) && Objects.equals(this.allianceId, sovereigntyStructuresResponse.allianceId) && Objects.equals(this.vulnerableStartTime, sovereigntyStructuresResponse.vulnerableStartTime) && Objects.equals(this.vulnerableEndTime, sovereigntyStructuresResponse.vulnerableEndTime) && Objects.equals(this.vulnerabilityOccupancyLevel, sovereigntyStructuresResponse.vulnerabilityOccupancyLevel) && Objects.equals(this.solarSystemId, sovereigntyStructuresResponse.solarSystemId) && Objects.equals(this.structureId, sovereigntyStructuresResponse.structureId);
    }

    public int hashCode() {
        return Objects.hash(this.structureTypeId, this.allianceId, this.vulnerableStartTime, this.vulnerableEndTime, this.vulnerabilityOccupancyLevel, this.solarSystemId, this.structureId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class SovereigntyStructuresResponse {\n");
        stringBuilder.append("    structureTypeId: ").append(this.toIndentedString(this.structureTypeId)).append("\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    vulnerableStartTime: ").append(this.toIndentedString(this.vulnerableStartTime)).append("\n");
        stringBuilder.append("    vulnerableEndTime: ").append(this.toIndentedString(this.vulnerableEndTime)).append("\n");
        stringBuilder.append("    vulnerabilityOccupancyLevel: ").append(this.toIndentedString(this.vulnerabilityOccupancyLevel)).append("\n");
        stringBuilder.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        stringBuilder.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

