/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="route object")
public class PlanetRoute
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Float quantity;
    public static final String SERIALIZED_NAME_ROUTE_ID = "route_id";
    @SerializedName(value="route_id")
    private Long routeId;
    public static final String SERIALIZED_NAME_CONTENT_TYPE_ID = "content_type_id";
    @SerializedName(value="content_type_id")
    private Integer contentTypeId;
    public static final String SERIALIZED_NAME_DESTINATION_PIN_ID = "destination_pin_id";
    @SerializedName(value="destination_pin_id")
    private Long destinationPinId;
    public static final String SERIALIZED_NAME_SOURCE_PIN_ID = "source_pin_id";
    @SerializedName(value="source_pin_id")
    private Long sourcePinId;
    public static final String SERIALIZED_NAME_WAYPOINTS = "waypoints";
    @SerializedName(value="waypoints")
    private List<Long> waypoints = null;

    public PlanetRoute quantity(Float f) {
        this.quantity = f;
        return this;
    }

    @ApiModelProperty(required=true, value="quantity number")
    public Float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Float f) {
        this.quantity = f;
    }

    public PlanetRoute routeId(Long l) {
        this.routeId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="route_id integer")
    public Long getRouteId() {
        return this.routeId;
    }

    public void setRouteId(Long l) {
        this.routeId = l;
    }

    public PlanetRoute contentTypeId(Integer n) {
        this.contentTypeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="content_type_id integer")
    public Integer getContentTypeId() {
        return this.contentTypeId;
    }

    public void setContentTypeId(Integer n) {
        this.contentTypeId = n;
    }

    public PlanetRoute destinationPinId(Long l) {
        this.destinationPinId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="destination_pin_id integer")
    public Long getDestinationPinId() {
        return this.destinationPinId;
    }

    public void setDestinationPinId(Long l) {
        this.destinationPinId = l;
    }

    public PlanetRoute sourcePinId(Long l) {
        this.sourcePinId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="source_pin_id integer")
    public Long getSourcePinId() {
        return this.sourcePinId;
    }

    public void setSourcePinId(Long l) {
        this.sourcePinId = l;
    }

    public PlanetRoute waypoints(List<Long> list) {
        this.waypoints = list;
        return this;
    }

    public PlanetRoute addWaypointsItem(Long l) {
        if (this.waypoints == null) {
            this.waypoints = new ArrayList<Long>();
        }
        this.waypoints.add(l);
        return this;
    }

    @ApiModelProperty(value="list of pin ID waypoints")
    public List<Long> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<Long> list) {
        this.waypoints = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlanetRoute planetRoute = (PlanetRoute)object;
        return Objects.equals(this.quantity, planetRoute.quantity) && Objects.equals(this.routeId, planetRoute.routeId) && Objects.equals(this.contentTypeId, planetRoute.contentTypeId) && Objects.equals(this.destinationPinId, planetRoute.destinationPinId) && Objects.equals(this.sourcePinId, planetRoute.sourcePinId) && Objects.equals(this.waypoints, planetRoute.waypoints);
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.routeId, this.contentTypeId, this.destinationPinId, this.sourcePinId, this.waypoints);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class PlanetRoute {\n");
        stringBuilder.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        stringBuilder.append("    routeId: ").append(this.toIndentedString(this.routeId)).append("\n");
        stringBuilder.append("    contentTypeId: ").append(this.toIndentedString(this.contentTypeId)).append("\n");
        stringBuilder.append("    destinationPinId: ").append(this.toIndentedString(this.destinationPinId)).append("\n");
        stringBuilder.append("    sourcePinId: ").append(this.toIndentedString(this.sourcePinId)).append("\n");
        stringBuilder.append("    waypoints: ").append(this.toIndentedString(this.waypoints)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

