/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.KillmailItem;
import net.troja.eve.esi.model.Position;

@ApiModel(description="victim object")
public class KillmailVictim
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_SHIP_TYPE_ID = "ship_type_id";
    @SerializedName(value="ship_type_id")
    private Integer shipTypeId;
    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(value="alliance_id")
    private Integer allianceId;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_CHARACTER_ID = "character_id";
    @SerializedName(value="character_id")
    private Integer characterId;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private Position position = null;
    public static final String SERIALIZED_NAME_DAMAGE_TAKEN = "damage_taken";
    @SerializedName(value="damage_taken")
    private Integer damageTaken;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<KillmailItem> items = null;

    public KillmailVictim shipTypeId(Integer n) {
        this.shipTypeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The ship that the victim was piloting and was destroyed ")
    public Integer getShipTypeId() {
        return this.shipTypeId;
    }

    public void setShipTypeId(Integer n) {
        this.shipTypeId = n;
    }

    public KillmailVictim allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(value="alliance_id integer")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public KillmailVictim corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(value="corporation_id integer")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public KillmailVictim factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(value="faction_id integer")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public KillmailVictim characterId(Integer n) {
        this.characterId = n;
        return this;
    }

    @ApiModelProperty(value="character_id integer")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer n) {
        this.characterId = n;
    }

    public KillmailVictim position(Position position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(value="")
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public KillmailVictim damageTaken(Integer n) {
        this.damageTaken = n;
        return this;
    }

    @ApiModelProperty(required=true, value="How much total damage was taken by the victim ")
    public Integer getDamageTaken() {
        return this.damageTaken;
    }

    public void setDamageTaken(Integer n) {
        this.damageTaken = n;
    }

    public KillmailVictim items(List<KillmailItem> list) {
        this.items = list;
        return this;
    }

    public KillmailVictim addItemsItem(KillmailItem killmailItem) {
        if (this.items == null) {
            this.items = new ArrayList<KillmailItem>();
        }
        this.items.add(killmailItem);
        return this;
    }

    @ApiModelProperty(value="items array")
    public List<KillmailItem> getItems() {
        return this.items;
    }

    public void setItems(List<KillmailItem> list) {
        this.items = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KillmailVictim killmailVictim = (KillmailVictim)object;
        return Objects.equals(this.shipTypeId, killmailVictim.shipTypeId) && Objects.equals(this.allianceId, killmailVictim.allianceId) && Objects.equals(this.corporationId, killmailVictim.corporationId) && Objects.equals(this.factionId, killmailVictim.factionId) && Objects.equals(this.characterId, killmailVictim.characterId) && Objects.equals(this.position, killmailVictim.position) && Objects.equals(this.damageTaken, killmailVictim.damageTaken) && Objects.equals(this.items, killmailVictim.items);
    }

    public int hashCode() {
        return Objects.hash(this.shipTypeId, this.allianceId, this.corporationId, this.factionId, this.characterId, this.position, this.damageTaken, this.items);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class KillmailVictim {\n");
        stringBuilder.append("    shipTypeId: ").append(this.toIndentedString(this.shipTypeId)).append("\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        stringBuilder.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        stringBuilder.append("    damageTaken: ").append(this.toIndentedString(this.damageTaken)).append("\n");
        stringBuilder.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

