/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import com.squareup.okhttp.OkHttpClient;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.auth.OAuth;

public class ApiClientBuilder {
    private String clientID;
    private String refreshToken;
    private String accessToken;
    private String userAgent;
    private OkHttpClient okHttpClient;

    public ApiClient build() {
        ApiClient apiClient = new ApiClient();
        String string = System.getProperty("http.agent");
        if (this.userAgent != null && !this.userAgent.isEmpty()) {
            apiClient.setUserAgent(this.userAgent);
        } else if (string != null && !string.isEmpty()) {
            apiClient.setUserAgent(string);
        } else {
            apiClient.setUserAgent("eve-esi/slack:@goldengnu");
        }
        OAuth oAuth = (OAuth)apiClient.getAuthentication("evesso");
        if (this.clientID != null) {
            if (this.refreshToken != null) {
                oAuth.setAuth(this.clientID, this.refreshToken);
            } else {
                oAuth.setClientId(this.clientID);
            }
        }
        if (this.accessToken != null) {
            oAuth.setAccessToken(this.accessToken);
        }
        if (this.okHttpClient != null) {
            apiClient.setHttpClient(this.okHttpClient);
        }
        return apiClient;
    }

    public ApiClientBuilder clientID(String string) {
        this.clientID = string;
        return this;
    }

    public ApiClientBuilder refreshToken(String string) {
        this.refreshToken = string;
        return this;
    }

    public ApiClientBuilder accessToken(String string) {
        this.accessToken = string;
        return this;
    }

    public ApiClientBuilder userAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public ApiClientBuilder okHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        return this;
    }
}

