/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class SovereigntyStructuresResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_STRUCTURE_TYPE_ID = "structure_type_id";
    @SerializedName(SERIALIZED_NAME_STRUCTURE_TYPE_ID)
    private Integer structureTypeId;

    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(SERIALIZED_NAME_ALLIANCE_ID)
    private Integer allianceId;

    public static final String SERIALIZED_NAME_VULNERABLE_START_TIME = "vulnerable_start_time";
    @SerializedName(SERIALIZED_NAME_VULNERABLE_START_TIME)
    private OffsetDateTime vulnerableStartTime;

    public static final String SERIALIZED_NAME_VULNERABLE_END_TIME = "vulnerable_end_time";
    @SerializedName(SERIALIZED_NAME_VULNERABLE_END_TIME)
    private OffsetDateTime vulnerableEndTime;

    public static final String SERIALIZED_NAME_VULNERABILITY_OCCUPANCY_LEVEL = "vulnerability_occupancy_level";
    @SerializedName(SERIALIZED_NAME_VULNERABILITY_OCCUPANCY_LEVEL)
    private Float vulnerabilityOccupancyLevel;

    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(SERIALIZED_NAME_SOLAR_SYSTEM_ID)
    private Integer solarSystemId;

    public static final String SERIALIZED_NAME_STRUCTURE_ID = "structure_id";
    @SerializedName(SERIALIZED_NAME_STRUCTURE_ID)
    private Long structureId;

    public SovereigntyStructuresResponse structureTypeId(Integer structureTypeId) {
        this.structureTypeId = structureTypeId;
        return this;
    }

    /**
     * A reference to the type of structure this is.
     * 
     * @return structureTypeId
     **/
    @ApiModelProperty(required = true, value = "A reference to the type of structure this is. ")
    public Integer getStructureTypeId() {
        return structureTypeId;
    }

    public void setStructureTypeId(Integer structureTypeId) {
        this.structureTypeId = structureTypeId;
    }

    public SovereigntyStructuresResponse allianceId(Integer allianceId) {
        this.allianceId = allianceId;
        return this;
    }

    /**
     * The alliance that owns the structure.
     * 
     * @return allianceId
     **/
    @ApiModelProperty(required = true, value = "The alliance that owns the structure. ")
    public Integer getAllianceId() {
        return allianceId;
    }

    public void setAllianceId(Integer allianceId) {
        this.allianceId = allianceId;
    }

    public SovereigntyStructuresResponse vulnerableStartTime(OffsetDateTime vulnerableStartTime) {
        this.vulnerableStartTime = vulnerableStartTime;
        return this;
    }

    /**
     * The next time at which the structure will become vulnerable. Or the start
     * time of the current window if current time is between this and
     * vulnerableEndTime.
     * 
     * @return vulnerableStartTime
     **/
    @ApiModelProperty(value = "The next time at which the structure will become vulnerable. Or the start time of the current window if current time is between this and vulnerableEndTime. ")
    public OffsetDateTime getVulnerableStartTime() {
        return vulnerableStartTime;
    }

    public void setVulnerableStartTime(OffsetDateTime vulnerableStartTime) {
        this.vulnerableStartTime = vulnerableStartTime;
    }

    public SovereigntyStructuresResponse vulnerableEndTime(OffsetDateTime vulnerableEndTime) {
        this.vulnerableEndTime = vulnerableEndTime;
        return this;
    }

    /**
     * The time at which the next or current vulnerability window ends. At the
     * end of a vulnerability window the next window is recalculated and locked
     * in along with the vulnerabilityOccupancyLevel. If the structure is not in
     * 100% entosis control of the defender, it will go in to &#39;overtime&#39;
     * and stay vulnerable for as long as that situation persists. Only once the
     * defenders have 100% entosis control and has the vulnerableEndTime passed
     * does the vulnerability interval expire and a new one is calculated.
     * 
     * @return vulnerableEndTime
     **/
    @ApiModelProperty(value = "The time at which the next or current vulnerability window ends. At the end of a vulnerability window the next window is recalculated and locked in along with the vulnerabilityOccupancyLevel. If the structure is not in 100% entosis control of the defender, it will go in to 'overtime' and stay vulnerable for as long as that situation persists. Only once the defenders have 100% entosis control and has the vulnerableEndTime passed does the vulnerability interval expire and a new one is calculated. ")
    public OffsetDateTime getVulnerableEndTime() {
        return vulnerableEndTime;
    }

    public void setVulnerableEndTime(OffsetDateTime vulnerableEndTime) {
        this.vulnerableEndTime = vulnerableEndTime;
    }

    public SovereigntyStructuresResponse vulnerabilityOccupancyLevel(Float vulnerabilityOccupancyLevel) {
        this.vulnerabilityOccupancyLevel = vulnerabilityOccupancyLevel;
        return this;
    }

    /**
     * The occupancy level for the next or current vulnerability window. This
     * takes into account all development indexes and capital system bonuses.
     * Also known as Activity Defense Multiplier from in the client. It
     * increases the time that attackers must spend using their entosis links on
     * the structure.
     * 
     * @return vulnerabilityOccupancyLevel
     **/
    @ApiModelProperty(value = "The occupancy level for the next or current vulnerability window. This takes into account all development indexes and capital system bonuses. Also known as Activity Defense Multiplier from in the client. It increases the time that attackers must spend using their entosis links on the structure. ")
    public Float getVulnerabilityOccupancyLevel() {
        return vulnerabilityOccupancyLevel;
    }

    public void setVulnerabilityOccupancyLevel(Float vulnerabilityOccupancyLevel) {
        this.vulnerabilityOccupancyLevel = vulnerabilityOccupancyLevel;
    }

    public SovereigntyStructuresResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    /**
     * Solar system in which the structure is located.
     * 
     * @return solarSystemId
     **/
    @ApiModelProperty(required = true, value = "Solar system in which the structure is located. ")
    public Integer getSolarSystemId() {
        return solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public SovereigntyStructuresResponse structureId(Long structureId) {
        this.structureId = structureId;
        return this;
    }

    /**
     * Unique item ID for this structure.
     * 
     * @return structureId
     **/
    @ApiModelProperty(required = true, value = "Unique item ID for this structure.")
    public Long getStructureId() {
        return structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SovereigntyStructuresResponse sovereigntyStructuresResponse = (SovereigntyStructuresResponse) o;
        return Objects.equals(this.structureTypeId, sovereigntyStructuresResponse.structureTypeId)
                && Objects.equals(this.allianceId, sovereigntyStructuresResponse.allianceId)
                && Objects.equals(this.vulnerableStartTime, sovereigntyStructuresResponse.vulnerableStartTime)
                && Objects.equals(this.vulnerableEndTime, sovereigntyStructuresResponse.vulnerableEndTime)
                && Objects.equals(this.vulnerabilityOccupancyLevel,
                        sovereigntyStructuresResponse.vulnerabilityOccupancyLevel)
                && Objects.equals(this.solarSystemId, sovereigntyStructuresResponse.solarSystemId)
                && Objects.equals(this.structureId, sovereigntyStructuresResponse.structureId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(structureTypeId, allianceId, vulnerableStartTime, vulnerableEndTime,
                vulnerabilityOccupancyLevel, solarSystemId, structureId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SovereigntyStructuresResponse {\n");

        sb.append("    structureTypeId: ").append(toIndentedString(structureTypeId)).append("\n");
        sb.append("    allianceId: ").append(toIndentedString(allianceId)).append("\n");
        sb.append("    vulnerableStartTime: ").append(toIndentedString(vulnerableStartTime)).append("\n");
        sb.append("    vulnerableEndTime: ").append(toIndentedString(vulnerableEndTime)).append("\n");
        sb.append("    vulnerabilityOccupancyLevel: ").append(toIndentedString(vulnerabilityOccupancyLevel))
                .append("\n");
        sb.append("    solarSystemId: ").append(toIndentedString(solarSystemId)).append("\n");
        sb.append("    structureId: ").append(toIndentedString(structureId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
