/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterIndustryJobsResponse;
import net.troja.eve.esi.model.CharacterMiningResponse;
import net.troja.eve.esi.model.CorporationIndustryJobsResponse;
import net.troja.eve.esi.model.CorporationMiningExtractionsResponse;
import net.troja.eve.esi.model.CorporationMiningObserverResponse;
import net.troja.eve.esi.model.CorporationMiningObserversResponse;
import net.troja.eve.esi.model.IndustryFacilitiesResponse;
import net.troja.eve.esi.model.IndustrySystemsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndustryApi {
    private ApiClient apiClient;

    public IndustryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IndustryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterIdIndustryJobs
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed character industry jobs. Only
     *            includes jobs from the past 90 days (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdIndustryJobsCall(Integer characterId, String datasource,
            String ifNoneMatch, Boolean includeCompleted, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/industry/jobs/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (includeCompleted != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("include_completed", includeCompleted));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdIndustryJobsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Boolean includeCompleted, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdIndustryJobs(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdIndustryJobsCall(characterId, datasource, ifNoneMatch,
                includeCompleted, token, callback);
        return call;

    }

    /**
     * List character industry jobs List industry jobs placed by a character ---
     * This route is cached for up to 300 seconds SSO Scope:
     * esi-industry.read_character_jobs.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed character industry jobs. Only
     *            includes jobs from the past 90 days (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterIndustryJobsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterIndustryJobsResponse> getCharactersCharacterIdIndustryJobs(Integer characterId,
            String datasource, String ifNoneMatch, Boolean includeCompleted, String token) throws ApiException {
        ApiResponse<List<CharacterIndustryJobsResponse>> resp = getCharactersCharacterIdIndustryJobsWithHttpInfo(
                characterId, datasource, ifNoneMatch, includeCompleted, token);
        return resp.getData();
    }

    /**
     * List character industry jobs List industry jobs placed by a character ---
     * This route is cached for up to 300 seconds SSO Scope:
     * esi-industry.read_character_jobs.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed character industry jobs. Only
     *            includes jobs from the past 90 days (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterIndustryJobsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterIndustryJobsResponse>> getCharactersCharacterIdIndustryJobsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, Boolean includeCompleted, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdIndustryJobsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, includeCompleted, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterIndustryJobsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List character industry jobs (asynchronously) List industry jobs placed
     * by a character --- This route is cached for up to 300 seconds SSO Scope:
     * esi-industry.read_character_jobs.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed character industry jobs. Only
     *            includes jobs from the past 90 days (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdIndustryJobsAsync(Integer characterId, String datasource,
            String ifNoneMatch, Boolean includeCompleted, String token,
            final ApiCallback<List<CharacterIndustryJobsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdIndustryJobsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, includeCompleted, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterIndustryJobsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdMining
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMiningCall(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/mining/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdMiningValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdMining(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdMiningCall(characterId, datasource, ifNoneMatch, page,
                token, callback);
        return call;

    }

    /**
     * Character mining ledger Paginated record of all mining done by a
     * character for the past 30 days --- This route is cached for up to 600
     * seconds SSO Scope: esi-industry.read_character_mining.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterMiningResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterMiningResponse> getCharactersCharacterIdMining(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterMiningResponse>> resp = getCharactersCharacterIdMiningWithHttpInfo(characterId,
                datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Character mining ledger Paginated record of all mining done by a
     * character for the past 30 days --- This route is cached for up to 600
     * seconds SSO Scope: esi-industry.read_character_mining.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterMiningResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterMiningResponse>> getCharactersCharacterIdMiningWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdMiningValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterMiningResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Character mining ledger (asynchronously) Paginated record of all mining
     * done by a character for the past 30 days --- This route is cached for up
     * to 600 seconds SSO Scope: esi-industry.read_character_mining.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMiningAsync(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<CharacterMiningResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdMiningValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterMiningResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationCorporationIdMiningExtractions
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationCorporationIdMiningExtractionsCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporation/{corporation_id}/mining/extractions/".replaceAll("\\{"
                + "corporation_id" + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationCorporationIdMiningExtractionsValidateBeforeCall(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationCorporationIdMiningExtractions(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningExtractionsCall(corporationId, datasource,
                ifNoneMatch, page, token, callback);
        return call;

    }

    /**
     * Moon extraction timers Extraction timers for all moon chunks being
     * extracted by refineries belonging to a corporation. --- This route is
     * cached for up to 1800 seconds --- Requires one of the following EVE
     * corporation role(s): Station_Manager SSO Scope:
     * esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMiningExtractionsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMiningExtractionsResponse> getCorporationCorporationIdMiningExtractions(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        ApiResponse<List<CorporationMiningExtractionsResponse>> resp = getCorporationCorporationIdMiningExtractionsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Moon extraction timers Extraction timers for all moon chunks being
     * extracted by refineries belonging to a corporation. --- This route is
     * cached for up to 1800 seconds --- Requires one of the following EVE
     * corporation role(s): Station_Manager SSO Scope:
     * esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return 
     *         ApiResponse&lt;List&lt;CorporationMiningExtractionsResponse&gt;&gt
     *         ;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMiningExtractionsResponse>> getCorporationCorporationIdMiningExtractionsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningExtractionsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMiningExtractionsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Moon extraction timers (asynchronously) Extraction timers for all moon
     * chunks being extracted by refineries belonging to a corporation. --- This
     * route is cached for up to 1800 seconds --- Requires one of the following
     * EVE corporation role(s): Station_Manager SSO Scope:
     * esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationCorporationIdMiningExtractionsAsync(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationMiningExtractionsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningExtractionsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationMiningExtractionsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationCorporationIdMiningObservers
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationCorporationIdMiningObserversCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporation/{corporation_id}/mining/observers/".replaceAll("\\{" + "corporation_id"
                + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationCorporationIdMiningObserversValidateBeforeCall(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationCorporationIdMiningObservers(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningObserversCall(corporationId, datasource,
                ifNoneMatch, page, token, callback);
        return call;

    }

    /**
     * Corporation mining observers Paginated list of all entities capable of
     * observing and recording mining for a corporation --- This route is cached
     * for up to 3600 seconds --- Requires one of the following EVE corporation
     * role(s): Accountant SSO Scope: esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMiningObserversResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMiningObserversResponse> getCorporationCorporationIdMiningObservers(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationMiningObserversResponse>> resp = getCorporationCorporationIdMiningObserversWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Corporation mining observers Paginated list of all entities capable of
     * observing and recording mining for a corporation --- This route is cached
     * for up to 3600 seconds --- Requires one of the following EVE corporation
     * role(s): Accountant SSO Scope: esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationMiningObserversResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMiningObserversResponse>> getCorporationCorporationIdMiningObserversWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningObserversValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMiningObserversResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Corporation mining observers (asynchronously) Paginated list of all
     * entities capable of observing and recording mining for a corporation ---
     * This route is cached for up to 3600 seconds --- Requires one of the
     * following EVE corporation role(s): Accountant SSO Scope:
     * esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationCorporationIdMiningObserversAsync(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationMiningObserversResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningObserversValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationMiningObserversResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationCorporationIdMiningObserversObserverId
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param observerId
     *            A mining observer id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationCorporationIdMiningObserversObserverIdCall(Integer corporationId,
            Long observerId, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporation/{corporation_id}/mining/observers/{observer_id}/".replaceAll(
                "\\{" + "corporation_id" + "\\}", apiClient.escapeString(corporationId.toString())).replaceAll(
                "\\{" + "observer_id" + "\\}", apiClient.escapeString(observerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationCorporationIdMiningObserversObserverIdValidateBeforeCall(
            Integer corporationId, Long observerId, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationCorporationIdMiningObserversObserverId(Async)");
        }

        // verify the required parameter 'observerId' is set
        if (observerId == null) {
            throw new ApiException(
                    "Missing the required parameter 'observerId' when calling getCorporationCorporationIdMiningObserversObserverId(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningObserversObserverIdCall(corporationId,
                observerId, datasource, ifNoneMatch, page, token, callback);
        return call;

    }

    /**
     * Observed corporation mining Paginated record of all mining seen by an
     * observer --- This route is cached for up to 3600 seconds --- Requires one
     * of the following EVE corporation role(s): Accountant SSO Scope:
     * esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param observerId
     *            A mining observer id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationMiningObserverResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationMiningObserverResponse> getCorporationCorporationIdMiningObserversObserverId(
            Integer corporationId, Long observerId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        ApiResponse<List<CorporationMiningObserverResponse>> resp = getCorporationCorporationIdMiningObserversObserverIdWithHttpInfo(
                corporationId, observerId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Observed corporation mining Paginated record of all mining seen by an
     * observer --- This route is cached for up to 3600 seconds --- Requires one
     * of the following EVE corporation role(s): Accountant SSO Scope:
     * esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param observerId
     *            A mining observer id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationMiningObserverResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationMiningObserverResponse>> getCorporationCorporationIdMiningObserversObserverIdWithHttpInfo(
            Integer corporationId, Long observerId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningObserversObserverIdValidateBeforeCall(
                corporationId, observerId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationMiningObserverResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Observed corporation mining (asynchronously) Paginated record of all
     * mining seen by an observer --- This route is cached for up to 3600
     * seconds --- Requires one of the following EVE corporation role(s):
     * Accountant SSO Scope: esi-industry.read_corporation_mining.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param observerId
     *            A mining observer id (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationCorporationIdMiningObserversObserverIdAsync(Integer corporationId,
            Long observerId, String datasource, String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationMiningObserverResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationCorporationIdMiningObserversObserverIdValidateBeforeCall(
                corporationId, observerId, datasource, ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationMiningObserverResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdIndustryJobs
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed corporation industry jobs. Only
     *            includes jobs from the past 90 days (optional, default to
     *            false)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdIndustryJobsCall(Integer corporationId,
            String datasource, String ifNoneMatch, Boolean includeCompleted, Integer page, String token,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/industry/jobs/".replaceAll("\\{" + "corporation_id"
                + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (includeCompleted != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("include_completed", includeCompleted));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdIndustryJobsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Boolean includeCompleted, Integer page, String token,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdIndustryJobs(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdIndustryJobsCall(corporationId, datasource,
                ifNoneMatch, includeCompleted, page, token, callback);
        return call;

    }

    /**
     * List corporation industry jobs List industry jobs run by a corporation
     * --- This route is cached for up to 300 seconds --- Requires one of the
     * following EVE corporation role(s): Factory_Manager SSO Scope:
     * esi-industry.read_corporation_jobs.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed corporation industry jobs. Only
     *            includes jobs from the past 90 days (optional, default to
     *            false)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationIndustryJobsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationIndustryJobsResponse> getCorporationsCorporationIdIndustryJobs(Integer corporationId,
            String datasource, String ifNoneMatch, Boolean includeCompleted, Integer page, String token)
            throws ApiException {
        ApiResponse<List<CorporationIndustryJobsResponse>> resp = getCorporationsCorporationIdIndustryJobsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, includeCompleted, page, token);
        return resp.getData();
    }

    /**
     * List corporation industry jobs List industry jobs run by a corporation
     * --- This route is cached for up to 300 seconds --- Requires one of the
     * following EVE corporation role(s): Factory_Manager SSO Scope:
     * esi-industry.read_corporation_jobs.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed corporation industry jobs. Only
     *            includes jobs from the past 90 days (optional, default to
     *            false)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationIndustryJobsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationIndustryJobsResponse>> getCorporationsCorporationIdIndustryJobsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Boolean includeCompleted, Integer page,
            String token) throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdIndustryJobsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, includeCompleted, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationIndustryJobsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List corporation industry jobs (asynchronously) List industry jobs run by
     * a corporation --- This route is cached for up to 300 seconds --- Requires
     * one of the following EVE corporation role(s): Factory_Manager SSO Scope:
     * esi-industry.read_corporation_jobs.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param includeCompleted
     *            Whether to retrieve completed corporation industry jobs. Only
     *            includes jobs from the past 90 days (optional, default to
     *            false)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdIndustryJobsAsync(Integer corporationId,
            String datasource, String ifNoneMatch, Boolean includeCompleted, Integer page, String token,
            final ApiCallback<List<CorporationIndustryJobsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdIndustryJobsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, includeCompleted, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationIndustryJobsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getIndustryFacilities
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getIndustryFacilitiesCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/industry/facilities/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getIndustryFacilitiesValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getIndustryFacilitiesCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * List industry facilities Return a list of industry facilities --- This
     * route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;IndustryFacilitiesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<IndustryFacilitiesResponse> getIndustryFacilities(String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<List<IndustryFacilitiesResponse>> resp = getIndustryFacilitiesWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * List industry facilities Return a list of industry facilities --- This
     * route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;IndustryFacilitiesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<IndustryFacilitiesResponse>> getIndustryFacilitiesWithHttpInfo(String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getIndustryFacilitiesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<IndustryFacilitiesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List industry facilities (asynchronously) Return a list of industry
     * facilities --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getIndustryFacilitiesAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<IndustryFacilitiesResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getIndustryFacilitiesValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<IndustryFacilitiesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getIndustrySystems
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getIndustrySystemsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/industry/systems/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getIndustrySystemsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getIndustrySystemsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * List solar system cost indices Return cost indices for solar systems ---
     * This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;IndustrySystemsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<IndustrySystemsResponse> getIndustrySystems(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<IndustrySystemsResponse>> resp = getIndustrySystemsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * List solar system cost indices Return cost indices for solar systems ---
     * This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;IndustrySystemsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<IndustrySystemsResponse>> getIndustrySystemsWithHttpInfo(String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getIndustrySystemsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<IndustrySystemsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List solar system cost indices (asynchronously) Return cost indices for
     * solar systems --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getIndustrySystemsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<IndustrySystemsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getIndustrySystemsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<IndustrySystemsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
