/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.DogmaAttributeResponse;
import net.troja.eve.esi.model.DogmaDynamicItemsResponse;
import net.troja.eve.esi.model.DogmaEffectResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DogmaApi {
    private ApiClient apiClient;

    public DogmaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DogmaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getDogmaAttributes
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDogmaAttributesCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/dogma/attributes/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDogmaAttributesValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getDogmaAttributesCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get attributes Get a list of dogma attribute ids --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getDogmaAttributes(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getDogmaAttributesWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get attributes Get a list of dogma attribute ids --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getDogmaAttributesWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getDogmaAttributesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get attributes (asynchronously) Get a list of dogma attribute ids ---
     * This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getDogmaAttributesAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getDogmaAttributesValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getDogmaAttributesAttributeId
     * 
     * @param attributeId
     *            A dogma attribute ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDogmaAttributesAttributeIdCall(Integer attributeId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/dogma/attributes/{attribute_id}/".replaceAll("\\{" + "attribute_id" + "\\}",
                apiClient.escapeString(attributeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDogmaAttributesAttributeIdValidateBeforeCall(Integer attributeId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'attributeId' is set
        if (attributeId == null) {
            throw new ApiException(
                    "Missing the required parameter 'attributeId' when calling getDogmaAttributesAttributeId(Async)");
        }

        com.squareup.okhttp.Call call = getDogmaAttributesAttributeIdCall(attributeId, datasource, ifNoneMatch,
                callback);
        return call;

    }

    /**
     * Get attribute information Get information on a dogma attribute --- This
     * route expires daily at 11:05
     * 
     * @param attributeId
     *            A dogma attribute ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return DogmaAttributeResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public DogmaAttributeResponse getDogmaAttributesAttributeId(Integer attributeId, String datasource,
            String ifNoneMatch) throws ApiException {
        ApiResponse<DogmaAttributeResponse> resp = getDogmaAttributesAttributeIdWithHttpInfo(attributeId, datasource,
                ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get attribute information Get information on a dogma attribute --- This
     * route expires daily at 11:05
     * 
     * @param attributeId
     *            A dogma attribute ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;DogmaAttributeResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<DogmaAttributeResponse> getDogmaAttributesAttributeIdWithHttpInfo(Integer attributeId,
            String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getDogmaAttributesAttributeIdValidateBeforeCall(attributeId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DogmaAttributeResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get attribute information (asynchronously) Get information on a dogma
     * attribute --- This route expires daily at 11:05
     * 
     * @param attributeId
     *            A dogma attribute ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getDogmaAttributesAttributeIdAsync(Integer attributeId, String datasource,
            String ifNoneMatch, final ApiCallback<DogmaAttributeResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getDogmaAttributesAttributeIdValidateBeforeCall(attributeId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<DogmaAttributeResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getDogmaDynamicItemsTypeIdItemId
     * 
     * @param itemId
     *            item_id integer (required)
     * @param typeId
     *            type_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDogmaDynamicItemsTypeIdItemIdCall(Long itemId, Integer typeId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/dogma/dynamic/items/{type_id}/{item_id}/".replaceAll("\\{" + "item_id" + "\\}",
                apiClient.escapeString(itemId.toString())).replaceAll("\\{" + "type_id" + "\\}",
                apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDogmaDynamicItemsTypeIdItemIdValidateBeforeCall(Long itemId, Integer typeId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'itemId' is set
        if (itemId == null) {
            throw new ApiException(
                    "Missing the required parameter 'itemId' when calling getDogmaDynamicItemsTypeIdItemId(Async)");
        }

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException(
                    "Missing the required parameter 'typeId' when calling getDogmaDynamicItemsTypeIdItemId(Async)");
        }

        com.squareup.okhttp.Call call = getDogmaDynamicItemsTypeIdItemIdCall(itemId, typeId, datasource, ifNoneMatch,
                callback);
        return call;

    }

    /**
     * Get dynamic item information Returns info about a dynamic item resulting
     * from mutation with a mutaplasmid. --- This route expires daily at 11:05
     * 
     * @param itemId
     *            item_id integer (required)
     * @param typeId
     *            type_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return DogmaDynamicItemsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public DogmaDynamicItemsResponse getDogmaDynamicItemsTypeIdItemId(Long itemId, Integer typeId, String datasource,
            String ifNoneMatch) throws ApiException {
        ApiResponse<DogmaDynamicItemsResponse> resp = getDogmaDynamicItemsTypeIdItemIdWithHttpInfo(itemId, typeId,
                datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get dynamic item information Returns info about a dynamic item resulting
     * from mutation with a mutaplasmid. --- This route expires daily at 11:05
     * 
     * @param itemId
     *            item_id integer (required)
     * @param typeId
     *            type_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;DogmaDynamicItemsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<DogmaDynamicItemsResponse> getDogmaDynamicItemsTypeIdItemIdWithHttpInfo(Long itemId,
            Integer typeId, String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getDogmaDynamicItemsTypeIdItemIdValidateBeforeCall(itemId, typeId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DogmaDynamicItemsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get dynamic item information (asynchronously) Returns info about a
     * dynamic item resulting from mutation with a mutaplasmid. --- This route
     * expires daily at 11:05
     * 
     * @param itemId
     *            item_id integer (required)
     * @param typeId
     *            type_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getDogmaDynamicItemsTypeIdItemIdAsync(Long itemId, Integer typeId,
            String datasource, String ifNoneMatch, final ApiCallback<DogmaDynamicItemsResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getDogmaDynamicItemsTypeIdItemIdValidateBeforeCall(itemId, typeId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<DogmaDynamicItemsResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getDogmaEffects
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDogmaEffectsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/dogma/effects/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDogmaEffectsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getDogmaEffectsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get effects Get a list of dogma effect ids --- This route expires daily
     * at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getDogmaEffects(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getDogmaEffectsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get effects Get a list of dogma effect ids --- This route expires daily
     * at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getDogmaEffectsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getDogmaEffectsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get effects (asynchronously) Get a list of dogma effect ids --- This
     * route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getDogmaEffectsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getDogmaEffectsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getDogmaEffectsEffectId
     * 
     * @param effectId
     *            A dogma effect ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDogmaEffectsEffectIdCall(Integer effectId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/dogma/effects/{effect_id}/".replaceAll("\\{" + "effect_id" + "\\}",
                apiClient.escapeString(effectId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDogmaEffectsEffectIdValidateBeforeCall(Integer effectId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'effectId' is set
        if (effectId == null) {
            throw new ApiException(
                    "Missing the required parameter 'effectId' when calling getDogmaEffectsEffectId(Async)");
        }

        com.squareup.okhttp.Call call = getDogmaEffectsEffectIdCall(effectId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get effect information Get information on a dogma effect --- This route
     * expires daily at 11:05
     * 
     * @param effectId
     *            A dogma effect ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return DogmaEffectResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public DogmaEffectResponse getDogmaEffectsEffectId(Integer effectId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<DogmaEffectResponse> resp = getDogmaEffectsEffectIdWithHttpInfo(effectId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get effect information Get information on a dogma effect --- This route
     * expires daily at 11:05
     * 
     * @param effectId
     *            A dogma effect ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;DogmaEffectResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<DogmaEffectResponse> getDogmaEffectsEffectIdWithHttpInfo(Integer effectId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getDogmaEffectsEffectIdValidateBeforeCall(effectId, datasource, ifNoneMatch,
                null);
        Type localVarReturnType = new TypeToken<DogmaEffectResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get effect information (asynchronously) Get information on a dogma effect
     * --- This route expires daily at 11:05
     * 
     * @param effectId
     *            A dogma effect ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getDogmaEffectsEffectIdAsync(Integer effectId, String datasource,
            String ifNoneMatch, final ApiCallback<DogmaEffectResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getDogmaEffectsEffectIdValidateBeforeCall(effectId, datasource, ifNoneMatch,
                callback);
        Type localVarReturnType = new TypeToken<DogmaEffectResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
