/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.AllianceContactsLabelsResponse;
import net.troja.eve.esi.model.AllianceContactsResponse;
import net.troja.eve.esi.model.ContactLabelsResponse;
import net.troja.eve.esi.model.ContactsResponse;
import net.troja.eve.esi.model.CorporationContactsLabelsResponse;
import net.troja.eve.esi.model.CorporationContactsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactsApi {
    private ApiClient apiClient;

    public ContactsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContactsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteCharactersCharacterIdContacts
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param contactIds
     *            A list of contacts to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteCharactersCharacterIdContactsCall(Integer characterId,
            List<Integer> contactIds, String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/contacts/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contactIds != null) {
            localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "contact_ids", contactIds));
        }

        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteCharactersCharacterIdContactsValidateBeforeCall(Integer characterId,
            List<Integer> contactIds, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling deleteCharactersCharacterIdContacts(Async)");
        }

        // verify the required parameter 'contactIds' is set
        if (contactIds == null) {
            throw new ApiException(
                    "Missing the required parameter 'contactIds' when calling deleteCharactersCharacterIdContacts(Async)");
        }

        com.squareup.okhttp.Call call = deleteCharactersCharacterIdContactsCall(characterId, contactIds, datasource,
                token, callback);
        return call;

    }

    /**
     * Delete contacts Bulk delete contacts --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param contactIds
     *            A list of contacts to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void deleteCharactersCharacterIdContacts(Integer characterId, List<Integer> contactIds, String datasource,
            String token) throws ApiException {
        deleteCharactersCharacterIdContactsWithHttpInfo(characterId, contactIds, datasource, token);
    }

    /**
     * Delete contacts Bulk delete contacts --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param contactIds
     *            A list of contacts to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> deleteCharactersCharacterIdContactsWithHttpInfo(Integer characterId,
            List<Integer> contactIds, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = deleteCharactersCharacterIdContactsValidateBeforeCall(characterId, contactIds,
                datasource, token, null);
        return apiClient.execute(call);
    }

    /**
     * Delete contacts (asynchronously) Bulk delete contacts --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param contactIds
     *            A list of contacts to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call deleteCharactersCharacterIdContactsAsync(Integer characterId,
            List<Integer> contactIds, String datasource, String token, final ApiCallback<Void> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = deleteCharactersCharacterIdContactsValidateBeforeCall(characterId, contactIds,
                datasource, token, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for getAlliancesAllianceIdContacts
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdContactsCall(Integer allianceId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/alliances/{alliance_id}/contacts/".replaceAll("\\{" + "alliance_id" + "\\}",
                apiClient.escapeString(allianceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAlliancesAllianceIdContactsValidateBeforeCall(Integer allianceId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'allianceId' is set
        if (allianceId == null) {
            throw new ApiException(
                    "Missing the required parameter 'allianceId' when calling getAlliancesAllianceIdContacts(Async)");
        }

        com.squareup.okhttp.Call call = getAlliancesAllianceIdContactsCall(allianceId, datasource, ifNoneMatch, page,
                token, callback);
        return call;

    }

    /**
     * Get alliance contacts Return contacts of an alliance --- This route is
     * cached for up to 300 seconds SSO Scope: esi-alliances.read_contacts.v1
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;AllianceContactsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<AllianceContactsResponse> getAlliancesAllianceIdContacts(Integer allianceId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<AllianceContactsResponse>> resp = getAlliancesAllianceIdContactsWithHttpInfo(allianceId,
                datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get alliance contacts Return contacts of an alliance --- This route is
     * cached for up to 300 seconds SSO Scope: esi-alliances.read_contacts.v1
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;AllianceContactsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<AllianceContactsResponse>> getAlliancesAllianceIdContactsWithHttpInfo(Integer allianceId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        com.squareup.okhttp.Call call = getAlliancesAllianceIdContactsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<AllianceContactsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get alliance contacts (asynchronously) Return contacts of an alliance ---
     * This route is cached for up to 300 seconds SSO Scope:
     * esi-alliances.read_contacts.v1
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdContactsAsync(Integer allianceId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<AllianceContactsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesAllianceIdContactsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<AllianceContactsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getAlliancesAllianceIdContactsLabels
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdContactsLabelsCall(Integer allianceId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/alliances/{alliance_id}/contacts/labels/".replaceAll("\\{" + "alliance_id" + "\\}",
                apiClient.escapeString(allianceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAlliancesAllianceIdContactsLabelsValidateBeforeCall(Integer allianceId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'allianceId' is set
        if (allianceId == null) {
            throw new ApiException(
                    "Missing the required parameter 'allianceId' when calling getAlliancesAllianceIdContactsLabels(Async)");
        }

        com.squareup.okhttp.Call call = getAlliancesAllianceIdContactsLabelsCall(allianceId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get alliance contact labels Return custom labels for an alliance&#39;s
     * contacts --- This route is cached for up to 300 seconds SSO Scope:
     * esi-alliances.read_contacts.v1
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;AllianceContactsLabelsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<AllianceContactsLabelsResponse> getAlliancesAllianceIdContactsLabels(Integer allianceId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<AllianceContactsLabelsResponse>> resp = getAlliancesAllianceIdContactsLabelsWithHttpInfo(
                allianceId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get alliance contact labels Return custom labels for an alliance&#39;s
     * contacts --- This route is cached for up to 300 seconds SSO Scope:
     * esi-alliances.read_contacts.v1
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;AllianceContactsLabelsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<AllianceContactsLabelsResponse>> getAlliancesAllianceIdContactsLabelsWithHttpInfo(
            Integer allianceId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getAlliancesAllianceIdContactsLabelsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<AllianceContactsLabelsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get alliance contact labels (asynchronously) Return custom labels for an
     * alliance&#39;s contacts --- This route is cached for up to 300 seconds
     * SSO Scope: esi-alliances.read_contacts.v1
     * 
     * @param allianceId
     *            An EVE alliance ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getAlliancesAllianceIdContactsLabelsAsync(Integer allianceId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<AllianceContactsLabelsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getAlliancesAllianceIdContactsLabelsValidateBeforeCall(allianceId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<AllianceContactsLabelsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdContacts
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdContactsCall(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/contacts/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdContactsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdContacts(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdContactsCall(characterId, datasource, ifNoneMatch,
                page, token, callback);
        return call;

    }

    /**
     * Get contacts Return contacts of a character --- This route is cached for
     * up to 300 seconds SSO Scope: esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;ContactsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<ContactsResponse> getCharactersCharacterIdContacts(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<ContactsResponse>> resp = getCharactersCharacterIdContactsWithHttpInfo(characterId,
                datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get contacts Return contacts of a character --- This route is cached for
     * up to 300 seconds SSO Scope: esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;ContactsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<ContactsResponse>> getCharactersCharacterIdContactsWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdContactsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<ContactsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get contacts (asynchronously) Return contacts of a character --- This
     * route is cached for up to 300 seconds SSO Scope:
     * esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdContactsAsync(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<ContactsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdContactsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<ContactsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdContactsLabels
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdContactsLabelsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/contacts/labels/".replaceAll("\\{" + "character_id"
                + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdContactsLabelsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdContactsLabels(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdContactsLabelsCall(characterId, datasource,
                ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get contact labels Return custom labels for a character&#39;s contacts
     * --- This route is cached for up to 300 seconds SSO Scope:
     * esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;ContactLabelsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<ContactLabelsResponse> getCharactersCharacterIdContactsLabels(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<ContactLabelsResponse>> resp = getCharactersCharacterIdContactsLabelsWithHttpInfo(characterId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get contact labels Return custom labels for a character&#39;s contacts
     * --- This route is cached for up to 300 seconds SSO Scope:
     * esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;ContactLabelsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<ContactLabelsResponse>> getCharactersCharacterIdContactsLabelsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdContactsLabelsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<ContactLabelsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get contact labels (asynchronously) Return custom labels for a
     * character&#39;s contacts --- This route is cached for up to 300 seconds
     * SSO Scope: esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdContactsLabelsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<ContactLabelsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdContactsLabelsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<ContactLabelsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdContacts
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdContactsCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/corporations/{corporation_id}/contacts/".replaceAll(
                "\\{" + "corporation_id" + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdContactsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdContacts(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdContactsCall(corporationId, datasource,
                ifNoneMatch, page, token, callback);
        return call;

    }

    /**
     * Get corporation contacts Return contacts of a corporation --- This route
     * is cached for up to 300 seconds SSO Scope:
     * esi-corporations.read_contacts.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationContactsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationContactsResponse> getCorporationsCorporationIdContacts(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationContactsResponse>> resp = getCorporationsCorporationIdContactsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get corporation contacts Return contacts of a corporation --- This route
     * is cached for up to 300 seconds SSO Scope:
     * esi-corporations.read_contacts.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationContactsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationContactsResponse>> getCorporationsCorporationIdContactsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdContactsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationContactsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation contacts (asynchronously) Return contacts of a
     * corporation --- This route is cached for up to 300 seconds SSO Scope:
     * esi-corporations.read_contacts.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdContactsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CorporationContactsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdContactsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationContactsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdContactsLabels
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdContactsLabelsCall(Integer corporationId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/contacts/labels/".replaceAll("\\{" + "corporation_id"
                + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdContactsLabelsValidateBeforeCall(
            Integer corporationId, String datasource, String ifNoneMatch, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdContactsLabels(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdContactsLabelsCall(corporationId, datasource,
                ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get corporation contact labels Return custom labels for a
     * corporation&#39;s contacts --- This route is cached for up to 300 seconds
     * SSO Scope: esi-corporations.read_contacts.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationContactsLabelsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationContactsLabelsResponse> getCorporationsCorporationIdContactsLabels(Integer corporationId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CorporationContactsLabelsResponse>> resp = getCorporationsCorporationIdContactsLabelsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get corporation contact labels Return custom labels for a
     * corporation&#39;s contacts --- This route is cached for up to 300 seconds
     * SSO Scope: esi-corporations.read_contacts.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationContactsLabelsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationContactsLabelsResponse>> getCorporationsCorporationIdContactsLabelsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdContactsLabelsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationContactsLabelsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation contact labels (asynchronously) Return custom labels for
     * a corporation&#39;s contacts --- This route is cached for up to 300
     * seconds SSO Scope: esi-corporations.read_contacts.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdContactsLabelsAsync(Integer corporationId,
            String datasource, String ifNoneMatch, String token,
            final ApiCallback<List<CorporationContactsLabelsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdContactsLabelsValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationContactsLabelsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersCharacterIdContacts
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the new contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdContactsCall(Integer characterId, Float standing,
            List<Integer> requestBody, String datasource, List<Long> labelIds, String token, Boolean watched,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/contacts/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (labelIds != null) {
            localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "label_ids", labelIds));
        }

        if (standing != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("standing", standing));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        if (watched != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("watched", watched));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersCharacterIdContactsValidateBeforeCall(Integer characterId,
            Float standing, List<Integer> requestBody, String datasource, List<Long> labelIds, String token,
            Boolean watched, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling postCharactersCharacterIdContacts(Async)");
        }

        // verify the required parameter 'standing' is set
        if (standing == null) {
            throw new ApiException(
                    "Missing the required parameter 'standing' when calling postCharactersCharacterIdContacts(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCharactersCharacterIdContacts(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersCharacterIdContactsCall(characterId, standing, requestBody,
                datasource, labelIds, token, watched, callback);
        return call;

    }

    /**
     * Add contacts Bulk add contacts with same settings --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the new contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> postCharactersCharacterIdContacts(Integer characterId, Float standing,
            List<Integer> requestBody, String datasource, List<Long> labelIds, String token, Boolean watched)
            throws ApiException {
        ApiResponse<List<Integer>> resp = postCharactersCharacterIdContactsWithHttpInfo(characterId, standing,
                requestBody, datasource, labelIds, token, watched);
        return resp.getData();
    }

    /**
     * Add contacts Bulk add contacts with same settings --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the new contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> postCharactersCharacterIdContactsWithHttpInfo(Integer characterId,
            Float standing, List<Integer> requestBody, String datasource, List<Long> labelIds, String token,
            Boolean watched) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersCharacterIdContactsValidateBeforeCall(characterId, standing,
                requestBody, datasource, labelIds, token, watched, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add contacts (asynchronously) Bulk add contacts with same settings ---
     * SSO Scope: esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the new contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdContactsAsync(Integer characterId, Float standing,
            List<Integer> requestBody, String datasource, List<Long> labelIds, String token, Boolean watched,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersCharacterIdContactsValidateBeforeCall(characterId, standing,
                requestBody, datasource, labelIds, token, watched, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for putCharactersCharacterIdContacts
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call putCharactersCharacterIdContactsCall(Integer characterId, Float standing,
            List<Integer> requestBody, String datasource, List<Long> labelIds, String token, Boolean watched,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/contacts/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (labelIds != null) {
            localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "label_ids", labelIds));
        }

        if (standing != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("standing", standing));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        if (watched != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("watched", watched));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call putCharactersCharacterIdContactsValidateBeforeCall(Integer characterId,
            Float standing, List<Integer> requestBody, String datasource, List<Long> labelIds, String token,
            Boolean watched, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling putCharactersCharacterIdContacts(Async)");
        }

        // verify the required parameter 'standing' is set
        if (standing == null) {
            throw new ApiException(
                    "Missing the required parameter 'standing' when calling putCharactersCharacterIdContacts(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling putCharactersCharacterIdContacts(Async)");
        }

        com.squareup.okhttp.Call call = putCharactersCharacterIdContactsCall(characterId, standing, requestBody,
                datasource, labelIds, token, watched, callback);
        return call;

    }

    /**
     * Edit contacts Bulk edit contacts with same settings --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void putCharactersCharacterIdContacts(Integer characterId, Float standing, List<Integer> requestBody,
            String datasource, List<Long> labelIds, String token, Boolean watched) throws ApiException {
        putCharactersCharacterIdContactsWithHttpInfo(characterId, standing, requestBody, datasource, labelIds, token,
                watched);
    }

    /**
     * Edit contacts Bulk edit contacts with same settings --- SSO Scope:
     * esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> putCharactersCharacterIdContactsWithHttpInfo(Integer characterId, Float standing,
            List<Integer> requestBody, String datasource, List<Long> labelIds, String token, Boolean watched)
            throws ApiException {
        com.squareup.okhttp.Call call = putCharactersCharacterIdContactsValidateBeforeCall(characterId, standing,
                requestBody, datasource, labelIds, token, watched, null);
        return apiClient.execute(call);
    }

    /**
     * Edit contacts (asynchronously) Bulk edit contacts with same settings ---
     * SSO Scope: esi-characters.write_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param standing
     *            Standing for the contact (required)
     * @param requestBody
     *            A list of contacts (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param labelIds
     *            Add custom labels to the contact (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param watched
     *            Whether the contact should be watched, note this is only
     *            effective on characters (optional, default to false)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call putCharactersCharacterIdContactsAsync(Integer characterId, Float standing,
            List<Integer> requestBody, String datasource, List<Long> labelIds, String token, Boolean watched,
            final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = putCharactersCharacterIdContactsValidateBeforeCall(characterId, standing,
                requestBody, datasource, labelIds, token, watched, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
