/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class StatusResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_PLAYERS = "players";
    @SerializedName(value="players")
    private Integer players;
    public static final String SERIALIZED_NAME_SERVER_VERSION = "server_version";
    @SerializedName(value="server_version")
    private String serverVersion;
    public static final String SERIALIZED_NAME_VIP = "vip";
    @SerializedName(value="vip")
    private Boolean vip;

    public StatusResponse startTime(OffsetDateTime offsetDateTime) {
        this.startTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Server start timestamp")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime offsetDateTime) {
        this.startTime = offsetDateTime;
    }

    public StatusResponse players(Integer n) {
        this.players = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Current online player count")
    public Integer getPlayers() {
        return this.players;
    }

    public void setPlayers(Integer n) {
        this.players = n;
    }

    public StatusResponse serverVersion(String string) {
        this.serverVersion = string;
        return this;
    }

    @ApiModelProperty(required=true, value="Running version as string")
    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String string) {
        this.serverVersion = string;
    }

    public StatusResponse vip(Boolean bl) {
        this.vip = bl;
        return this;
    }

    @ApiModelProperty(value="If the server is in VIP mode")
    public Boolean getVip() {
        return this.vip;
    }

    public void setVip(Boolean bl) {
        this.vip = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StatusResponse statusResponse = (StatusResponse)object;
        return Objects.equals(this.startTime, statusResponse.startTime) && Objects.equals(this.players, statusResponse.players) && Objects.equals(this.serverVersion, statusResponse.serverVersion) && Objects.equals(this.vip, statusResponse.vip);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.players, this.serverVersion, this.vip);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class StatusResponse {\n");
        stringBuilder.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        stringBuilder.append("    players: ").append(this.toIndentedString(this.players)).append("\n");
        stringBuilder.append("    serverVersion: ").append(this.toIndentedString(this.serverVersion)).append("\n");
        stringBuilder.append("    vip: ").append(this.toIndentedString(this.vip)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

