/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.KillmailAttacker;
import net.troja.eve.esi.model.KillmailVictim;

@ApiModel(description="200 ok object")
public class KillmailResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_KILLMAIL_TIME = "killmail_time";
    @SerializedName(value="killmail_time")
    private OffsetDateTime killmailTime;
    public static final String SERIALIZED_NAME_MOON_ID = "moon_id";
    @SerializedName(value="moon_id")
    private Integer moonId;
    public static final String SERIALIZED_NAME_ATTACKERS = "attackers";
    @SerializedName(value="attackers")
    private List<KillmailAttacker> attackers = new ArrayList<KillmailAttacker>();
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_VICTIM = "victim";
    @SerializedName(value="victim")
    private KillmailVictim victim = null;
    public static final String SERIALIZED_NAME_KILLMAIL_ID = "killmail_id";
    @SerializedName(value="killmail_id")
    private Integer killmailId;
    public static final String SERIALIZED_NAME_WAR_ID = "war_id";
    @SerializedName(value="war_id")
    private Integer warId;

    public KillmailResponse killmailTime(OffsetDateTime offsetDateTime) {
        this.killmailTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Time that the victim was killed and the killmail generated ")
    public OffsetDateTime getKillmailTime() {
        return this.killmailTime;
    }

    public void setKillmailTime(OffsetDateTime offsetDateTime) {
        this.killmailTime = offsetDateTime;
    }

    public KillmailResponse moonId(Integer n) {
        this.moonId = n;
        return this;
    }

    @ApiModelProperty(value="Moon if the kill took place at one")
    public Integer getMoonId() {
        return this.moonId;
    }

    public void setMoonId(Integer n) {
        this.moonId = n;
    }

    public KillmailResponse attackers(List<KillmailAttacker> list) {
        this.attackers = list;
        return this;
    }

    public KillmailResponse addAttackersItem(KillmailAttacker killmailAttacker) {
        this.attackers.add(killmailAttacker);
        return this;
    }

    @ApiModelProperty(required=true, value="attackers array")
    public List<KillmailAttacker> getAttackers() {
        return this.attackers;
    }

    public void setAttackers(List<KillmailAttacker> list) {
        this.attackers = list;
    }

    public KillmailResponse solarSystemId(Integer n) {
        this.solarSystemId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Solar system that the kill took place in ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer n) {
        this.solarSystemId = n;
    }

    public KillmailResponse victim(KillmailVictim killmailVictim) {
        this.victim = killmailVictim;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public KillmailVictim getVictim() {
        return this.victim;
    }

    public void setVictim(KillmailVictim killmailVictim) {
        this.victim = killmailVictim;
    }

    public KillmailResponse killmailId(Integer n) {
        this.killmailId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the killmail")
    public Integer getKillmailId() {
        return this.killmailId;
    }

    public void setKillmailId(Integer n) {
        this.killmailId = n;
    }

    public KillmailResponse warId(Integer n) {
        this.warId = n;
        return this;
    }

    @ApiModelProperty(value="War if the killmail is generated in relation to an official war ")
    public Integer getWarId() {
        return this.warId;
    }

    public void setWarId(Integer n) {
        this.warId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KillmailResponse killmailResponse = (KillmailResponse)object;
        return Objects.equals(this.killmailTime, killmailResponse.killmailTime) && Objects.equals(this.moonId, killmailResponse.moonId) && Objects.equals(this.attackers, killmailResponse.attackers) && Objects.equals(this.solarSystemId, killmailResponse.solarSystemId) && Objects.equals(this.victim, killmailResponse.victim) && Objects.equals(this.killmailId, killmailResponse.killmailId) && Objects.equals(this.warId, killmailResponse.warId);
    }

    public int hashCode() {
        return Objects.hash(this.killmailTime, this.moonId, this.attackers, this.solarSystemId, this.victim, this.killmailId, this.warId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class KillmailResponse {\n");
        stringBuilder.append("    killmailTime: ").append(this.toIndentedString(this.killmailTime)).append("\n");
        stringBuilder.append("    moonId: ").append(this.toIndentedString(this.moonId)).append("\n");
        stringBuilder.append("    attackers: ").append(this.toIndentedString(this.attackers)).append("\n");
        stringBuilder.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        stringBuilder.append("    victim: ").append(this.toIndentedString(this.victim)).append("\n");
        stringBuilder.append("    killmailId: ").append(this.toIndentedString(this.killmailId)).append("\n");
        stringBuilder.append("    warId: ").append(this.toIndentedString(this.warId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

