/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="invitation object")
public class FleetInvitation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CHARACTER_ID = "character_id";
    @SerializedName(value="character_id")
    private Integer characterId;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private RoleEnum role;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    private Long squadId;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    private Long wingId;

    public FleetInvitation characterId(Integer n) {
        this.characterId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The character you want to invite")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer n) {
        this.characterId = n;
    }

    public FleetInvitation role(RoleEnum roleEnum) {
        this.role = roleEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="If a character is invited with the `fleet_commander` role, neither `wing_id` or `squad_id` should be specified. If a character is invited with the `wing_commander` role, only `wing_id` should be specified. If a character is invited with the `squad_commander` role, both `wing_id` and `squad_id` should be specified. If a character is invited with the `squad_member` role, `wing_id` and `squad_id` should either both be specified or not specified at all. If they aren\u2019t specified, the invited character will join any squad with available positions.")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum roleEnum) {
        this.role = roleEnum;
    }

    public FleetInvitation squadId(Long l) {
        this.squadId = l;
        return this;
    }

    @ApiModelProperty(value="squad_id integer")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long l) {
        this.squadId = l;
    }

    public FleetInvitation wingId(Long l) {
        this.wingId = l;
        return this;
    }

    @ApiModelProperty(value="wing_id integer")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long l) {
        this.wingId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FleetInvitation fleetInvitation = (FleetInvitation)object;
        return Objects.equals(this.characterId, fleetInvitation.characterId) && Objects.equals((Object)this.role, (Object)fleetInvitation.role) && Objects.equals(this.squadId, fleetInvitation.squadId) && Objects.equals(this.wingId, fleetInvitation.wingId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.characterId, this.role, this.squadId, this.wingId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FleetInvitation {\n");
        stringBuilder.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        stringBuilder.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        stringBuilder.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        stringBuilder.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        WING_COMMANDER("wing_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member");

        private String value;

        private RoleEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String string) {
            for (RoleEnum roleEnum : RoleEnum.values()) {
                if (!String.valueOf(roleEnum.value).equals(string)) continue;
                return roleEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum roleEnum) throws IOException {
                jsonWriter.value(roleEnum.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return RoleEnum.fromValue(String.valueOf(string));
            }
        }
    }
}

