/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="wallet transaction")
public class CorporationWalletTransactionsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private OffsetDateTime date;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private Long transactionId;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Integer quantity;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_UNIT_PRICE = "unit_price";
    @SerializedName(value="unit_price")
    private Double unitPrice;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private Integer clientId;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    private Long locationId;
    public static final String SERIALIZED_NAME_IS_BUY = "is_buy";
    @SerializedName(value="is_buy")
    private Boolean isBuy;
    public static final String SERIALIZED_NAME_JOURNAL_REF_ID = "journal_ref_id";
    @SerializedName(value="journal_ref_id")
    private Long journalRefId;

    public CorporationWalletTransactionsResponse date(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time of transaction")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
    }

    public CorporationWalletTransactionsResponse transactionId(Long l) {
        this.transactionId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique transaction ID")
    public Long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Long l) {
        this.transactionId = l;
    }

    public CorporationWalletTransactionsResponse quantity(Integer n) {
        this.quantity = n;
        return this;
    }

    @ApiModelProperty(required=true, value="quantity integer")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer n) {
        this.quantity = n;
    }

    public CorporationWalletTransactionsResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="type_id integer")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CorporationWalletTransactionsResponse unitPrice(Double d) {
        this.unitPrice = d;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount paid per unit")
    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(Double d) {
        this.unitPrice = d;
    }

    public CorporationWalletTransactionsResponse clientId(Integer n) {
        this.clientId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="client_id integer")
    public Integer getClientId() {
        return this.clientId;
    }

    public void setClientId(Integer n) {
        this.clientId = n;
    }

    public CorporationWalletTransactionsResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="location_id integer")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public CorporationWalletTransactionsResponse isBuy(Boolean bl) {
        this.isBuy = bl;
        return this;
    }

    @ApiModelProperty(required=true, value="is_buy boolean")
    public Boolean getIsBuy() {
        return this.isBuy;
    }

    public void setIsBuy(Boolean bl) {
        this.isBuy = bl;
    }

    public CorporationWalletTransactionsResponse journalRefId(Long l) {
        this.journalRefId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="-1 if there is no corresponding wallet journal entry")
    public Long getJournalRefId() {
        return this.journalRefId;
    }

    public void setJournalRefId(Long l) {
        this.journalRefId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationWalletTransactionsResponse corporationWalletTransactionsResponse = (CorporationWalletTransactionsResponse)object;
        return Objects.equals(this.date, corporationWalletTransactionsResponse.date) && Objects.equals(this.transactionId, corporationWalletTransactionsResponse.transactionId) && Objects.equals(this.quantity, corporationWalletTransactionsResponse.quantity) && Objects.equals(this.typeId, corporationWalletTransactionsResponse.typeId) && Objects.equals(this.unitPrice, corporationWalletTransactionsResponse.unitPrice) && Objects.equals(this.clientId, corporationWalletTransactionsResponse.clientId) && Objects.equals(this.locationId, corporationWalletTransactionsResponse.locationId) && Objects.equals(this.isBuy, corporationWalletTransactionsResponse.isBuy) && Objects.equals(this.journalRefId, corporationWalletTransactionsResponse.journalRefId);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.transactionId, this.quantity, this.typeId, this.unitPrice, this.clientId, this.locationId, this.isBuy, this.journalRefId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationWalletTransactionsResponse {\n");
        stringBuilder.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        stringBuilder.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        stringBuilder.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        stringBuilder.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("    isBuy: ").append(this.toIndentedString(this.isBuy)).append("\n");
        stringBuilder.append("    journalRefId: ").append(this.toIndentedString(this.journalRefId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

