/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterOrdersResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_REGION_ID = "region_id";
    @SerializedName(value="region_id")
    private Integer regionId;
    public static final String SERIALIZED_NAME_RANGE = "range";
    @SerializedName(value="range")
    private RangeEnum range;
    public static final String SERIALIZED_NAME_VOLUME_TOTAL = "volume_total";
    @SerializedName(value="volume_total")
    private Integer volumeTotal;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    private Long locationId;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private Integer duration;
    public static final String SERIALIZED_NAME_MIN_VOLUME = "min_volume";
    @SerializedName(value="min_volume")
    private Integer minVolume;
    public static final String SERIALIZED_NAME_IS_BUY_ORDER = "is_buy_order";
    @SerializedName(value="is_buy_order")
    private Boolean isBuyOrder;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Double price;
    public static final String SERIALIZED_NAME_ESCROW = "escrow";
    @SerializedName(value="escrow")
    private Double escrow;
    public static final String SERIALIZED_NAME_IS_CORPORATION = "is_corporation";
    @SerializedName(value="is_corporation")
    private Boolean isCorporation;
    public static final String SERIALIZED_NAME_ISSUED = "issued";
    @SerializedName(value="issued")
    private OffsetDateTime issued;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    private Long orderId;
    public static final String SERIALIZED_NAME_VOLUME_REMAIN = "volume_remain";
    @SerializedName(value="volume_remain")
    private Integer volumeRemain;

    public CharacterOrdersResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="The type ID of the item transacted in this order")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CharacterOrdersResponse regionId(Integer n) {
        this.regionId = n;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the region where order was placed")
    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer n) {
        this.regionId = n;
    }

    public CharacterOrdersResponse range(RangeEnum rangeEnum) {
        this.range = rangeEnum;
        return this;
    }

    @ApiModelProperty(required=true, value="Valid order range, numbers are ranges in jumps")
    public RangeEnum getRange() {
        return this.range;
    }

    public void setRange(RangeEnum rangeEnum) {
        this.range = rangeEnum;
    }

    public CharacterOrdersResponse volumeTotal(Integer n) {
        this.volumeTotal = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items required or offered at time order was placed")
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Integer n) {
        this.volumeTotal = n;
    }

    public CharacterOrdersResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the location where order was placed")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public CharacterOrdersResponse duration(Integer n) {
        this.duration = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of days for which order is valid (starting from the issued date). An order expires at time issued + duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer n) {
        this.duration = n;
    }

    public CharacterOrdersResponse minVolume(Integer n) {
        this.minVolume = n;
        return this;
    }

    @ApiModelProperty(value="For buy orders, the minimum quantity that will be accepted in a matching sell order")
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(Integer n) {
        this.minVolume = n;
    }

    public CharacterOrdersResponse isBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
        return this;
    }

    @ApiModelProperty(value="True if the order is a bid (buy) order")
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
    }

    public CharacterOrdersResponse price(Double d) {
        this.price = d;
        return this;
    }

    @ApiModelProperty(required=true, value="Cost per unit for this order")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double d) {
        this.price = d;
    }

    public CharacterOrdersResponse escrow(Double d) {
        this.escrow = d;
        return this;
    }

    @ApiModelProperty(value="For buy orders, the amount of ISK in escrow")
    public Double getEscrow() {
        return this.escrow;
    }

    public void setEscrow(Double d) {
        this.escrow = d;
    }

    public CharacterOrdersResponse isCorporation(Boolean bl) {
        this.isCorporation = bl;
        return this;
    }

    @ApiModelProperty(required=true, value="Signifies whether the buy/sell order was placed on behalf of a corporation.")
    public Boolean getIsCorporation() {
        return this.isCorporation;
    }

    public void setIsCorporation(Boolean bl) {
        this.isCorporation = bl;
    }

    public CharacterOrdersResponse issued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time when this order was issued")
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
    }

    public CharacterOrdersResponse orderId(Long l) {
        this.orderId = l;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique order ID")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long l) {
        this.orderId = l;
    }

    public CharacterOrdersResponse volumeRemain(Integer n) {
        this.volumeRemain = n;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity of items still required or offered")
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(Integer n) {
        this.volumeRemain = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterOrdersResponse characterOrdersResponse = (CharacterOrdersResponse)object;
        return Objects.equals(this.typeId, characterOrdersResponse.typeId) && Objects.equals(this.regionId, characterOrdersResponse.regionId) && Objects.equals((Object)this.range, (Object)characterOrdersResponse.range) && Objects.equals(this.volumeTotal, characterOrdersResponse.volumeTotal) && Objects.equals(this.locationId, characterOrdersResponse.locationId) && Objects.equals(this.duration, characterOrdersResponse.duration) && Objects.equals(this.minVolume, characterOrdersResponse.minVolume) && Objects.equals(this.isBuyOrder, characterOrdersResponse.isBuyOrder) && Objects.equals(this.price, characterOrdersResponse.price) && Objects.equals(this.escrow, characterOrdersResponse.escrow) && Objects.equals(this.isCorporation, characterOrdersResponse.isCorporation) && Objects.equals(this.issued, characterOrdersResponse.issued) && Objects.equals(this.orderId, characterOrdersResponse.orderId) && Objects.equals(this.volumeRemain, characterOrdersResponse.volumeRemain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeId, this.regionId, this.range, this.volumeTotal, this.locationId, this.duration, this.minVolume, this.isBuyOrder, this.price, this.escrow, this.isCorporation, this.issued, this.orderId, this.volumeRemain});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterOrdersResponse {\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    regionId: ").append(this.toIndentedString(this.regionId)).append("\n");
        stringBuilder.append("    range: ").append(this.toIndentedString((Object)this.range)).append("\n");
        stringBuilder.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        stringBuilder.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        stringBuilder.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        stringBuilder.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        stringBuilder.append("    escrow: ").append(this.toIndentedString(this.escrow)).append("\n");
        stringBuilder.append("    isCorporation: ").append(this.toIndentedString(this.isCorporation)).append("\n");
        stringBuilder.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        stringBuilder.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        stringBuilder.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeEnum {
        _1("1"),
        _10("10"),
        _2("2"),
        _20("20"),
        _3("3"),
        _30("30"),
        _4("4"),
        _40("40"),
        _5("5"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        STATION("station");

        private String value;

        private RangeEnum(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeEnum fromValue(String string) {
            for (RangeEnum rangeEnum : RangeEnum.values()) {
                if (!String.valueOf(rangeEnum.value).equals(string)) continue;
                return rangeEnum;
            }
            throw new IllegalArgumentException("Unexpected value '" + string + "'");
        }

        public static class Adapter
        extends TypeAdapter<RangeEnum> {
            public void write(JsonWriter jsonWriter, RangeEnum rangeEnum) throws IOException {
                jsonWriter.value(rangeEnum.getValue());
            }

            public RangeEnum read(JsonReader jsonReader) throws IOException {
                String string = jsonReader.nextString();
                return RangeEnum.fromValue(String.valueOf(string));
            }
        }
    }
}

