/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Map;
import net.troja.eve.esi.auth.OAuth;
import net.troja.eve.esi.auth.OAuthFlow;
import net.troja.eve.esi.auth.OAuthOkHttpClient;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class RetryingOAuth
extends OAuth
implements Interceptor {
    private OAuthClient oAuthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;

    public RetryingOAuth(OkHttpClient okHttpClient, OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.oAuthClient = new OAuthClient((HttpClient)new OAuthOkHttpClient(okHttpClient));
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public RetryingOAuth(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this(new OkHttpClient(), tokenRequestBuilder);
    }

    public RetryingOAuth(String string, String string2, OAuthFlow oAuthFlow, String string3, Map<String, String> map) {
        this(OAuthClientRequest.tokenLocation((String)string).setClientId(string2).setClientSecret(string3));
        this.setFlow(oAuthFlow);
        if (map != null) {
            for (String string4 : map.keySet()) {
                this.tokenRequestBuilder.setParameter(string4, map.get(string4));
            }
        }
    }

    public void setFlow(OAuthFlow oAuthFlow) {
        switch (oAuthFlow) {
            case accessCode: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                break;
            }
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.IMPLICIT);
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.retryingIntercept(chain, true);
    }

    private Response retryingIntercept(Interceptor.Chain chain, boolean bl) throws IOException {
        Request request = chain.request();
        if (request.header("Authorization") != null) {
            return chain.proceed(request);
        }
        if (this.getAccessToken() == null) {
            this.updateAccessToken(null);
        }
        if (this.getAccessToken() != null) {
            OAuthClientRequest oAuthClientRequest;
            Request.Builder builder = request.newBuilder();
            String string = this.getAccessToken();
            try {
                oAuthClientRequest = new OAuthBearerClientRequest(request.urlString()).setAccessToken(string).buildHeaderMessage();
            }
            catch (OAuthSystemException oAuthSystemException) {
                throw new IOException(oAuthSystemException);
            }
            Map map = oAuthClientRequest.getHeaders();
            for (String string2 : map.keySet()) {
                builder.addHeader(string2, (String)map.get(string2));
            }
            builder.url(oAuthClientRequest.getLocationUri());
            Response response = chain.proceed(builder.build());
            if (response != null && (response.code() == 401 || response.code() == 403) && bl) {
                try {
                    if (this.updateAccessToken(string)) {
                        response.body().close();
                        return this.retryingIntercept(chain, false);
                    }
                }
                catch (Exception exception) {
                    response.body().close();
                    throw exception;
                }
            }
            return response;
        }
        return chain.proceed(chain.request());
    }

    public synchronized boolean updateAccessToken(String string) throws IOException {
        if (this.getAccessToken() == null || this.getAccessToken().equals(string)) {
            try {
                OAuthJSONAccessTokenResponse oAuthJSONAccessTokenResponse = this.oAuthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
                if (oAuthJSONAccessTokenResponse != null && oAuthJSONAccessTokenResponse.getAccessToken() != null) {
                    this.setAccessToken(oAuthJSONAccessTokenResponse.getAccessToken());
                    return !this.getAccessToken().equals(string);
                }
            }
            catch (OAuthProblemException | OAuthSystemException throwable) {
                throw new IOException(throwable);
            }
        }
        return false;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }
}

