/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.BloodlinesResponse;
import net.troja.eve.esi.model.CategoryResponse;
import net.troja.eve.esi.model.ConstellationResponse;
import net.troja.eve.esi.model.FactionsResponse;
import net.troja.eve.esi.model.GraphicResponse;
import net.troja.eve.esi.model.GroupResponse;
import net.troja.eve.esi.model.MoonResponse;
import net.troja.eve.esi.model.PlanetResponse;
import net.troja.eve.esi.model.RacesResponse;
import net.troja.eve.esi.model.RegionResponse;
import net.troja.eve.esi.model.StarResponse;
import net.troja.eve.esi.model.StargateResponse;
import net.troja.eve.esi.model.StationResponse;
import net.troja.eve.esi.model.StructureResponse;
import net.troja.eve.esi.model.SystemJumpsResponse;
import net.troja.eve.esi.model.SystemKillsResponse;
import net.troja.eve.esi.model.SystemResponse;
import net.troja.eve.esi.model.TypeResponse;
import net.troja.eve.esi.model.UniverseAncestriesResponse;
import net.troja.eve.esi.model.UniverseAsteroidBeltsResponse;
import net.troja.eve.esi.model.UniverseIdsResponse;
import net.troja.eve.esi.model.UniverseNamesResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UniverseApi {
    private ApiClient apiClient;

    public UniverseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UniverseApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getUniverseAncestries
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseAncestriesCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/ancestries/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseAncestriesValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseAncestriesCall(acceptLanguage, datasource, ifNoneMatch, language,
                callback);
        return call;

    }

    /**
     * Get ancestries Get all character ancestries --- This route expires daily
     * at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;UniverseAncestriesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<UniverseAncestriesResponse> getUniverseAncestries(String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<List<UniverseAncestriesResponse>> resp = getUniverseAncestriesWithHttpInfo(acceptLanguage,
                datasource, ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get ancestries Get all character ancestries --- This route expires daily
     * at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;UniverseAncestriesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<UniverseAncestriesResponse>> getUniverseAncestriesWithHttpInfo(String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseAncestriesValidateBeforeCall(acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<List<UniverseAncestriesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get ancestries (asynchronously) Get all character ancestries --- This
     * route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseAncestriesAsync(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<List<UniverseAncestriesResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseAncestriesValidateBeforeCall(acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<List<UniverseAncestriesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseAsteroidBeltsAsteroidBeltId
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseAsteroidBeltsAsteroidBeltIdCall(Integer asteroidBeltId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/asteroid_belts/{asteroid_belt_id}/".replaceAll("\\{" + "asteroid_belt_id"
                + "\\}", apiClient.escapeString(asteroidBeltId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(Integer asteroidBeltId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'asteroidBeltId' is set
        if (asteroidBeltId == null) {
            throw new ApiException(
                    "Missing the required parameter 'asteroidBeltId' when calling getUniverseAsteroidBeltsAsteroidBeltId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseAsteroidBeltsAsteroidBeltIdCall(asteroidBeltId, datasource,
                ifNoneMatch, callback);
        return call;

    }

    /**
     * Get asteroid belt information Get information on an asteroid belt ---
     * This route expires daily at 11:05
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return UniverseAsteroidBeltsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public UniverseAsteroidBeltsResponse getUniverseAsteroidBeltsAsteroidBeltId(Integer asteroidBeltId,
            String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<UniverseAsteroidBeltsResponse> resp = getUniverseAsteroidBeltsAsteroidBeltIdWithHttpInfo(
                asteroidBeltId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get asteroid belt information Get information on an asteroid belt ---
     * This route expires daily at 11:05
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;UniverseAsteroidBeltsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<UniverseAsteroidBeltsResponse> getUniverseAsteroidBeltsAsteroidBeltIdWithHttpInfo(
            Integer asteroidBeltId, String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(asteroidBeltId,
                datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<UniverseAsteroidBeltsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get asteroid belt information (asynchronously) Get information on an
     * asteroid belt --- This route expires daily at 11:05
     * 
     * @param asteroidBeltId
     *            asteroid_belt_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseAsteroidBeltsAsteroidBeltIdAsync(Integer asteroidBeltId,
            String datasource, String ifNoneMatch, final ApiCallback<UniverseAsteroidBeltsResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseAsteroidBeltsAsteroidBeltIdValidateBeforeCall(asteroidBeltId,
                datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<UniverseAsteroidBeltsResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseBloodlines
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseBloodlinesCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/bloodlines/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseBloodlinesValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseBloodlinesCall(acceptLanguage, datasource, ifNoneMatch, language,
                callback);
        return call;

    }

    /**
     * Get bloodlines Get a list of bloodlines --- This route expires daily at
     * 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;BloodlinesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<BloodlinesResponse> getUniverseBloodlines(String acceptLanguage, String datasource, String ifNoneMatch,
            String language) throws ApiException {
        ApiResponse<List<BloodlinesResponse>> resp = getUniverseBloodlinesWithHttpInfo(acceptLanguage, datasource,
                ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get bloodlines Get a list of bloodlines --- This route expires daily at
     * 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;BloodlinesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<BloodlinesResponse>> getUniverseBloodlinesWithHttpInfo(String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseBloodlinesValidateBeforeCall(acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<List<BloodlinesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get bloodlines (asynchronously) Get a list of bloodlines --- This route
     * expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseBloodlinesAsync(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<List<BloodlinesResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseBloodlinesValidateBeforeCall(acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<List<BloodlinesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseCategories
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseCategoriesCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/categories/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseCategoriesValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseCategoriesCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get item categories Get a list of item categories --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseCategories(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseCategoriesWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get item categories Get a list of item categories --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseCategoriesWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseCategoriesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get item categories (asynchronously) Get a list of item categories ---
     * This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseCategoriesAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseCategoriesValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseCategoriesCategoryId
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseCategoriesCategoryIdCall(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/categories/{category_id}/".replaceAll("\\{" + "category_id" + "\\}",
                apiClient.escapeString(categoryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseCategoriesCategoryIdValidateBeforeCall(Integer categoryId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'categoryId' is set
        if (categoryId == null) {
            throw new ApiException(
                    "Missing the required parameter 'categoryId' when calling getUniverseCategoriesCategoryId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseCategoriesCategoryIdCall(categoryId, acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        return call;

    }

    /**
     * Get item category information Get information of an item category ---
     * This route expires daily at 11:05
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return CategoryResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CategoryResponse getUniverseCategoriesCategoryId(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<CategoryResponse> resp = getUniverseCategoriesCategoryIdWithHttpInfo(categoryId, acceptLanguage,
                datasource, ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get item category information Get information of an item category ---
     * This route expires daily at 11:05
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;CategoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CategoryResponse> getUniverseCategoriesCategoryIdWithHttpInfo(Integer categoryId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseCategoriesCategoryIdValidateBeforeCall(categoryId, acceptLanguage,
                datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<CategoryResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get item category information (asynchronously) Get information of an item
     * category --- This route expires daily at 11:05
     * 
     * @param categoryId
     *            An Eve item category ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseCategoriesCategoryIdAsync(Integer categoryId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<CategoryResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseCategoriesCategoryIdValidateBeforeCall(categoryId, acceptLanguage,
                datasource, ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<CategoryResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseConstellations
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseConstellationsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/constellations/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseConstellationsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseConstellationsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get constellations Get a list of constellations --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseConstellations(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseConstellationsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get constellations Get a list of constellations --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseConstellationsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseConstellationsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get constellations (asynchronously) Get a list of constellations --- This
     * route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseConstellationsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseConstellationsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseConstellationsConstellationId
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseConstellationsConstellationIdCall(Integer constellationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/constellations/{constellation_id}/".replaceAll("\\{" + "constellation_id"
                + "\\}", apiClient.escapeString(constellationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseConstellationsConstellationIdValidateBeforeCall(
            Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'constellationId' is set
        if (constellationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'constellationId' when calling getUniverseConstellationsConstellationId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseConstellationsConstellationIdCall(constellationId, acceptLanguage,
                datasource, ifNoneMatch, language, callback);
        return call;

    }

    /**
     * Get constellation information Get information on a constellation --- This
     * route expires daily at 11:05
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ConstellationResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ConstellationResponse getUniverseConstellationsConstellationId(Integer constellationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language) throws ApiException {
        ApiResponse<ConstellationResponse> resp = getUniverseConstellationsConstellationIdWithHttpInfo(constellationId,
                acceptLanguage, datasource, ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get constellation information Get information on a constellation --- This
     * route expires daily at 11:05
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;ConstellationResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<ConstellationResponse> getUniverseConstellationsConstellationIdWithHttpInfo(
            Integer constellationId, String acceptLanguage, String datasource, String ifNoneMatch, String language)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseConstellationsConstellationIdValidateBeforeCall(constellationId,
                acceptLanguage, datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<ConstellationResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get constellation information (asynchronously) Get information on a
     * constellation --- This route expires daily at 11:05
     * 
     * @param constellationId
     *            constellation_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseConstellationsConstellationIdAsync(Integer constellationId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language,
            final ApiCallback<ConstellationResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseConstellationsConstellationIdValidateBeforeCall(constellationId,
                acceptLanguage, datasource, ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<ConstellationResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseFactions
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseFactionsCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/universe/factions/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseFactionsValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseFactionsCall(acceptLanguage, datasource, ifNoneMatch, language,
                callback);
        return call;

    }

    /**
     * Get factions Get a list of factions --- This route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;FactionsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<FactionsResponse> getUniverseFactions(String acceptLanguage, String datasource, String ifNoneMatch,
            String language) throws ApiException {
        ApiResponse<List<FactionsResponse>> resp = getUniverseFactionsWithHttpInfo(acceptLanguage, datasource,
                ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get factions Get a list of factions --- This route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;FactionsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<FactionsResponse>> getUniverseFactionsWithHttpInfo(String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseFactionsValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, null);
        Type localVarReturnType = new TypeToken<List<FactionsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get factions (asynchronously) Get a list of factions --- This route
     * expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseFactionsAsync(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback<List<FactionsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseFactionsValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, callback);
        Type localVarReturnType = new TypeToken<List<FactionsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseGraphics
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseGraphicsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/graphics/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseGraphicsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseGraphicsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get graphics Get a list of graphics --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseGraphics(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseGraphicsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get graphics Get a list of graphics --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseGraphicsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseGraphicsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get graphics (asynchronously) Get a list of graphics --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseGraphicsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseGraphicsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseGraphicsGraphicId
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseGraphicsGraphicIdCall(Integer graphicId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/graphics/{graphic_id}/".replaceAll("\\{" + "graphic_id" + "\\}",
                apiClient.escapeString(graphicId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseGraphicsGraphicIdValidateBeforeCall(Integer graphicId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'graphicId' is set
        if (graphicId == null) {
            throw new ApiException(
                    "Missing the required parameter 'graphicId' when calling getUniverseGraphicsGraphicId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseGraphicsGraphicIdCall(graphicId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get graphic information Get information on a graphic --- This route
     * expires daily at 11:05
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return GraphicResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public GraphicResponse getUniverseGraphicsGraphicId(Integer graphicId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<GraphicResponse> resp = getUniverseGraphicsGraphicIdWithHttpInfo(graphicId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get graphic information Get information on a graphic --- This route
     * expires daily at 11:05
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;GraphicResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<GraphicResponse> getUniverseGraphicsGraphicIdWithHttpInfo(Integer graphicId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseGraphicsGraphicIdValidateBeforeCall(graphicId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<GraphicResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get graphic information (asynchronously) Get information on a graphic ---
     * This route expires daily at 11:05
     * 
     * @param graphicId
     *            graphic_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseGraphicsGraphicIdAsync(Integer graphicId, String datasource,
            String ifNoneMatch, final ApiCallback<GraphicResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseGraphicsGraphicIdValidateBeforeCall(graphicId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<GraphicResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseGroups
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseGroupsCall(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/groups/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseGroupsValidateBeforeCall(String datasource, String ifNoneMatch,
            Integer page, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseGroupsCall(datasource, ifNoneMatch, page, callback);
        return call;

    }

    /**
     * Get item groups Get a list of item groups --- This route expires daily at
     * 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseGroups(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseGroupsWithHttpInfo(datasource, ifNoneMatch, page);
        return resp.getData();
    }

    /**
     * Get item groups Get a list of item groups --- This route expires daily at
     * 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseGroupsWithHttpInfo(String datasource, String ifNoneMatch, Integer page)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseGroupsValidateBeforeCall(datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get item groups (asynchronously) Get a list of item groups --- This route
     * expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseGroupsAsync(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseGroupsValidateBeforeCall(datasource, ifNoneMatch, page, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseGroupsGroupId
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseGroupsGroupIdCall(Integer groupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/groups/{group_id}/".replaceAll("\\{" + "group_id" + "\\}",
                apiClient.escapeString(groupId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseGroupsGroupIdValidateBeforeCall(Integer groupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'groupId' is set
        if (groupId == null) {
            throw new ApiException(
                    "Missing the required parameter 'groupId' when calling getUniverseGroupsGroupId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseGroupsGroupIdCall(groupId, acceptLanguage, datasource, ifNoneMatch,
                language, callback);
        return call;

    }

    /**
     * Get item group information Get information on an item group --- This
     * route expires daily at 11:05
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return GroupResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public GroupResponse getUniverseGroupsGroupId(Integer groupId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<GroupResponse> resp = getUniverseGroupsGroupIdWithHttpInfo(groupId, acceptLanguage, datasource,
                ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get item group information Get information on an item group --- This
     * route expires daily at 11:05
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;GroupResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<GroupResponse> getUniverseGroupsGroupIdWithHttpInfo(Integer groupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseGroupsGroupIdValidateBeforeCall(groupId, acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<GroupResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get item group information (asynchronously) Get information on an item
     * group --- This route expires daily at 11:05
     * 
     * @param groupId
     *            An Eve item group ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseGroupsGroupIdAsync(Integer groupId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<GroupResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseGroupsGroupIdValidateBeforeCall(groupId, acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<GroupResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseMoonsMoonId
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseMoonsMoonIdCall(Integer moonId, String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/moons/{moon_id}/".replaceAll("\\{" + "moon_id" + "\\}",
                apiClient.escapeString(moonId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseMoonsMoonIdValidateBeforeCall(Integer moonId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'moonId' is set
        if (moonId == null) {
            throw new ApiException("Missing the required parameter 'moonId' when calling getUniverseMoonsMoonId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseMoonsMoonIdCall(moonId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get moon information Get information on a moon --- This route expires
     * daily at 11:05
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return MoonResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public MoonResponse getUniverseMoonsMoonId(Integer moonId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<MoonResponse> resp = getUniverseMoonsMoonIdWithHttpInfo(moonId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get moon information Get information on a moon --- This route expires
     * daily at 11:05
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;MoonResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<MoonResponse> getUniverseMoonsMoonIdWithHttpInfo(Integer moonId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseMoonsMoonIdValidateBeforeCall(moonId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<MoonResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get moon information (asynchronously) Get information on a moon --- This
     * route expires daily at 11:05
     * 
     * @param moonId
     *            moon_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseMoonsMoonIdAsync(Integer moonId, String datasource, String ifNoneMatch,
            final ApiCallback<MoonResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseMoonsMoonIdValidateBeforeCall(moonId, datasource, ifNoneMatch,
                callback);
        Type localVarReturnType = new TypeToken<MoonResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniversePlanetsPlanetId
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniversePlanetsPlanetIdCall(Integer planetId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/planets/{planet_id}/".replaceAll("\\{" + "planet_id" + "\\}",
                apiClient.escapeString(planetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniversePlanetsPlanetIdValidateBeforeCall(Integer planetId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'planetId' is set
        if (planetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'planetId' when calling getUniversePlanetsPlanetId(Async)");
        }

        com.squareup.okhttp.Call call = getUniversePlanetsPlanetIdCall(planetId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get planet information Get information on a planet --- This route expires
     * daily at 11:05
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return PlanetResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public PlanetResponse getUniversePlanetsPlanetId(Integer planetId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<PlanetResponse> resp = getUniversePlanetsPlanetIdWithHttpInfo(planetId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get planet information Get information on a planet --- This route expires
     * daily at 11:05
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;PlanetResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<PlanetResponse> getUniversePlanetsPlanetIdWithHttpInfo(Integer planetId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniversePlanetsPlanetIdValidateBeforeCall(planetId, datasource, ifNoneMatch,
                null);
        Type localVarReturnType = new TypeToken<PlanetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get planet information (asynchronously) Get information on a planet ---
     * This route expires daily at 11:05
     * 
     * @param planetId
     *            planet_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniversePlanetsPlanetIdAsync(Integer planetId, String datasource,
            String ifNoneMatch, final ApiCallback<PlanetResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniversePlanetsPlanetIdValidateBeforeCall(planetId, datasource, ifNoneMatch,
                callback);
        Type localVarReturnType = new TypeToken<PlanetResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseRaces
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseRacesCall(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/races/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseRacesValidateBeforeCall(String acceptLanguage, String datasource,
            String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseRacesCall(acceptLanguage, datasource, ifNoneMatch, language,
                callback);
        return call;

    }

    /**
     * Get character races Get a list of character races --- This route expires
     * daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return List&lt;RacesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<RacesResponse> getUniverseRaces(String acceptLanguage, String datasource, String ifNoneMatch,
            String language) throws ApiException {
        ApiResponse<List<RacesResponse>> resp = getUniverseRacesWithHttpInfo(acceptLanguage, datasource, ifNoneMatch,
                language);
        return resp.getData();
    }

    /**
     * Get character races Get a list of character races --- This route expires
     * daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;List&lt;RacesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<RacesResponse>> getUniverseRacesWithHttpInfo(String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseRacesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, null);
        Type localVarReturnType = new TypeToken<List<RacesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character races (asynchronously) Get a list of character races ---
     * This route expires daily at 11:05
     * 
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseRacesAsync(String acceptLanguage, String datasource, String ifNoneMatch,
            String language, final ApiCallback<List<RacesResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseRacesValidateBeforeCall(acceptLanguage, datasource, ifNoneMatch,
                language, callback);
        Type localVarReturnType = new TypeToken<List<RacesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseRegions
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseRegionsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/regions/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseRegionsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseRegionsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get regions Get a list of regions --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseRegions(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseRegionsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get regions Get a list of regions --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseRegionsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseRegionsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get regions (asynchronously) Get a list of regions --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseRegionsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseRegionsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseRegionsRegionId
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseRegionsRegionIdCall(Integer regionId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/regions/{region_id}/".replaceAll("\\{" + "region_id" + "\\}",
                apiClient.escapeString(regionId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseRegionsRegionIdValidateBeforeCall(Integer regionId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'regionId' is set
        if (regionId == null) {
            throw new ApiException(
                    "Missing the required parameter 'regionId' when calling getUniverseRegionsRegionId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseRegionsRegionIdCall(regionId, acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        return call;

    }

    /**
     * Get region information Get information on a region --- This route expires
     * daily at 11:05
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return RegionResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public RegionResponse getUniverseRegionsRegionId(Integer regionId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<RegionResponse> resp = getUniverseRegionsRegionIdWithHttpInfo(regionId, acceptLanguage, datasource,
                ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get region information Get information on a region --- This route expires
     * daily at 11:05
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;RegionResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<RegionResponse> getUniverseRegionsRegionIdWithHttpInfo(Integer regionId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseRegionsRegionIdValidateBeforeCall(regionId, acceptLanguage,
                datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<RegionResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get region information (asynchronously) Get information on a region ---
     * This route expires daily at 11:05
     * 
     * @param regionId
     *            region_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseRegionsRegionIdAsync(Integer regionId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<RegionResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseRegionsRegionIdValidateBeforeCall(regionId, acceptLanguage,
                datasource, ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<RegionResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseStargatesStargateId
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseStargatesStargateIdCall(Integer stargateId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/stargates/{stargate_id}/".replaceAll("\\{" + "stargate_id" + "\\}",
                apiClient.escapeString(stargateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseStargatesStargateIdValidateBeforeCall(Integer stargateId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'stargateId' is set
        if (stargateId == null) {
            throw new ApiException(
                    "Missing the required parameter 'stargateId' when calling getUniverseStargatesStargateId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseStargatesStargateIdCall(stargateId, datasource, ifNoneMatch,
                callback);
        return call;

    }

    /**
     * Get stargate information Get information on a stargate --- This route
     * expires daily at 11:05
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return StargateResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public StargateResponse getUniverseStargatesStargateId(Integer stargateId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<StargateResponse> resp = getUniverseStargatesStargateIdWithHttpInfo(stargateId, datasource,
                ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get stargate information Get information on a stargate --- This route
     * expires daily at 11:05
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;StargateResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<StargateResponse> getUniverseStargatesStargateIdWithHttpInfo(Integer stargateId,
            String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseStargatesStargateIdValidateBeforeCall(stargateId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StargateResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get stargate information (asynchronously) Get information on a stargate
     * --- This route expires daily at 11:05
     * 
     * @param stargateId
     *            stargate_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseStargatesStargateIdAsync(Integer stargateId, String datasource,
            String ifNoneMatch, final ApiCallback<StargateResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseStargatesStargateIdValidateBeforeCall(stargateId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<StargateResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseStarsStarId
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseStarsStarIdCall(Integer starId, String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/stars/{star_id}/".replaceAll("\\{" + "star_id" + "\\}",
                apiClient.escapeString(starId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseStarsStarIdValidateBeforeCall(Integer starId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'starId' is set
        if (starId == null) {
            throw new ApiException("Missing the required parameter 'starId' when calling getUniverseStarsStarId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseStarsStarIdCall(starId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get star information Get information on a star --- This route expires
     * daily at 11:05
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return StarResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public StarResponse getUniverseStarsStarId(Integer starId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<StarResponse> resp = getUniverseStarsStarIdWithHttpInfo(starId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get star information Get information on a star --- This route expires
     * daily at 11:05
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;StarResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<StarResponse> getUniverseStarsStarIdWithHttpInfo(Integer starId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseStarsStarIdValidateBeforeCall(starId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StarResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get star information (asynchronously) Get information on a star --- This
     * route expires daily at 11:05
     * 
     * @param starId
     *            star_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseStarsStarIdAsync(Integer starId, String datasource, String ifNoneMatch,
            final ApiCallback<StarResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseStarsStarIdValidateBeforeCall(starId, datasource, ifNoneMatch,
                callback);
        Type localVarReturnType = new TypeToken<StarResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseStationsStationId
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseStationsStationIdCall(Integer stationId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/universe/stations/{station_id}/".replaceAll("\\{" + "station_id" + "\\}",
                apiClient.escapeString(stationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseStationsStationIdValidateBeforeCall(Integer stationId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'stationId' is set
        if (stationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'stationId' when calling getUniverseStationsStationId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseStationsStationIdCall(stationId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get station information Get information on a station --- This route
     * expires daily at 11:05
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return StationResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public StationResponse getUniverseStationsStationId(Integer stationId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<StationResponse> resp = getUniverseStationsStationIdWithHttpInfo(stationId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get station information Get information on a station --- This route
     * expires daily at 11:05
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;StationResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<StationResponse> getUniverseStationsStationIdWithHttpInfo(Integer stationId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseStationsStationIdValidateBeforeCall(stationId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<StationResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get station information (asynchronously) Get information on a station ---
     * This route expires daily at 11:05
     * 
     * @param stationId
     *            station_id integer (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseStationsStationIdAsync(Integer stationId, String datasource,
            String ifNoneMatch, final ApiCallback<StationResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseStationsStationIdValidateBeforeCall(stationId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<StationResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseStructures
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseStructuresCall(String datasource, String filter, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/structures/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (filter != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseStructuresValidateBeforeCall(String datasource, String filter,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseStructuresCall(datasource, filter, ifNoneMatch, callback);
        return call;

    }

    /**
     * List all public structures List all public structures --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Long&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Long> getUniverseStructures(String datasource, String filter, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Long>> resp = getUniverseStructuresWithHttpInfo(datasource, filter, ifNoneMatch);
        return resp.getData();
    }

    /**
     * List all public structures List all public structures --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Long&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Long>> getUniverseStructuresWithHttpInfo(String datasource, String filter,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseStructuresValidateBeforeCall(datasource, filter, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Long>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List all public structures (asynchronously) List all public structures
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param filter
     *            Only list public structures that have this service online
     *            (optional)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseStructuresAsync(String datasource, String filter, String ifNoneMatch,
            final ApiCallback<List<Long>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseStructuresValidateBeforeCall(datasource, filter, ifNoneMatch,
                callback);
        Type localVarReturnType = new TypeToken<List<Long>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseStructuresStructureId
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseStructuresStructureIdCall(Long structureId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/universe/structures/{structure_id}/".replaceAll("\\{" + "structure_id" + "\\}",
                apiClient.escapeString(structureId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseStructuresStructureIdValidateBeforeCall(Long structureId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'structureId' is set
        if (structureId == null) {
            throw new ApiException(
                    "Missing the required parameter 'structureId' when calling getUniverseStructuresStructureId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseStructuresStructureIdCall(structureId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get structure information Returns information on requested structure if
     * you are on the ACL. Otherwise, returns \&quot;Forbidden\&quot; for all
     * inputs. --- This route is cached for up to 3600 seconds
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return StructureResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public StructureResponse getUniverseStructuresStructureId(Long structureId, String datasource, String ifNoneMatch,
            String token) throws ApiException {
        ApiResponse<StructureResponse> resp = getUniverseStructuresStructureIdWithHttpInfo(structureId, datasource,
                ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get structure information Returns information on requested structure if
     * you are on the ACL. Otherwise, returns \&quot;Forbidden\&quot; for all
     * inputs. --- This route is cached for up to 3600 seconds
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;StructureResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<StructureResponse> getUniverseStructuresStructureIdWithHttpInfo(Long structureId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseStructuresStructureIdValidateBeforeCall(structureId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<StructureResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get structure information (asynchronously) Returns information on
     * requested structure if you are on the ACL. Otherwise, returns
     * \&quot;Forbidden\&quot; for all inputs. --- This route is cached for up
     * to 3600 seconds
     * 
     * @param structureId
     *            An Eve structure ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseStructuresStructureIdAsync(Long structureId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<StructureResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseStructuresStructureIdValidateBeforeCall(structureId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<StructureResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseSystemJumps
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseSystemJumpsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/system_jumps/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseSystemJumpsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemJumpsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get system jumps Get the number of jumps in solar systems within the last
     * hour ending at the timestamp of the Last-Modified header, excluding
     * wormhole space. Only systems with jumps will be listed --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;SystemJumpsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<SystemJumpsResponse> getUniverseSystemJumps(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<SystemJumpsResponse>> resp = getUniverseSystemJumpsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get system jumps Get the number of jumps in solar systems within the last
     * hour ending at the timestamp of the Last-Modified header, excluding
     * wormhole space. Only systems with jumps will be listed --- This route is
     * cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;SystemJumpsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<SystemJumpsResponse>> getUniverseSystemJumpsWithHttpInfo(String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseSystemJumpsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<SystemJumpsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get system jumps (asynchronously) Get the number of jumps in solar
     * systems within the last hour ending at the timestamp of the Last-Modified
     * header, excluding wormhole space. Only systems with jumps will be listed
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseSystemJumpsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<SystemJumpsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemJumpsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<SystemJumpsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseSystemKills
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseSystemKillsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/universe/system_kills/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseSystemKillsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemKillsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get system kills Get the number of ship, pod and NPC kills per solar
     * system within the last hour ending at the timestamp of the Last-Modified
     * header, excluding wormhole space. Only systems with kills will be listed
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;SystemKillsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<SystemKillsResponse> getUniverseSystemKills(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<SystemKillsResponse>> resp = getUniverseSystemKillsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get system kills Get the number of ship, pod and NPC kills per solar
     * system within the last hour ending at the timestamp of the Last-Modified
     * header, excluding wormhole space. Only systems with kills will be listed
     * --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;SystemKillsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<SystemKillsResponse>> getUniverseSystemKillsWithHttpInfo(String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseSystemKillsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<SystemKillsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get system kills (asynchronously) Get the number of ship, pod and NPC
     * kills per solar system within the last hour ending at the timestamp of
     * the Last-Modified header, excluding wormhole space. Only systems with
     * kills will be listed --- This route is cached for up to 3600 seconds
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseSystemKillsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<SystemKillsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemKillsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<SystemKillsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseSystems
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseSystemsCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/systems/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseSystemsValidateBeforeCall(String datasource, String ifNoneMatch,
            final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemsCall(datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get solar systems Get a list of solar systems --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseSystems(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseSystemsWithHttpInfo(datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get solar systems Get a list of solar systems --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseSystemsWithHttpInfo(String datasource, String ifNoneMatch)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseSystemsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get solar systems (asynchronously) Get a list of solar systems --- This
     * route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseSystemsAsync(String datasource, String ifNoneMatch,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemsValidateBeforeCall(datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseSystemsSystemId
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseSystemsSystemIdCall(Integer systemId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v4/universe/systems/{system_id}/".replaceAll("\\{" + "system_id" + "\\}",
                apiClient.escapeString(systemId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseSystemsSystemIdValidateBeforeCall(Integer systemId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'systemId' is set
        if (systemId == null) {
            throw new ApiException(
                    "Missing the required parameter 'systemId' when calling getUniverseSystemsSystemId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseSystemsSystemIdCall(systemId, acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        return call;

    }

    /**
     * Get solar system information Get information on a solar system. --- This
     * route expires daily at 11:05
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return SystemResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public SystemResponse getUniverseSystemsSystemId(Integer systemId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<SystemResponse> resp = getUniverseSystemsSystemIdWithHttpInfo(systemId, acceptLanguage, datasource,
                ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get solar system information Get information on a solar system. --- This
     * route expires daily at 11:05
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;SystemResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<SystemResponse> getUniverseSystemsSystemIdWithHttpInfo(Integer systemId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseSystemsSystemIdValidateBeforeCall(systemId, acceptLanguage,
                datasource, ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<SystemResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get solar system information (asynchronously) Get information on a solar
     * system. --- This route expires daily at 11:05
     * 
     * @param systemId
     *            system_id integer (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseSystemsSystemIdAsync(Integer systemId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<SystemResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseSystemsSystemIdValidateBeforeCall(systemId, acceptLanguage,
                datasource, ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<SystemResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseTypes
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseTypesCall(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/universe/types/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseTypesValidateBeforeCall(String datasource, String ifNoneMatch,
            Integer page, final ApiCallback callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseTypesCall(datasource, ifNoneMatch, page, callback);
        return call;

    }

    /**
     * Get types Get a list of type ids --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return List&lt;Integer&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<Integer> getUniverseTypes(String datasource, String ifNoneMatch, Integer page) throws ApiException {
        ApiResponse<List<Integer>> resp = getUniverseTypesWithHttpInfo(datasource, ifNoneMatch, page);
        return resp.getData();
    }

    /**
     * Get types Get a list of type ids --- This route expires daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @return ApiResponse&lt;List&lt;Integer&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<Integer>> getUniverseTypesWithHttpInfo(String datasource, String ifNoneMatch, Integer page)
            throws ApiException {
        com.squareup.okhttp.Call call = getUniverseTypesValidateBeforeCall(datasource, ifNoneMatch, page, null);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get types (asynchronously) Get a list of type ids --- This route expires
     * daily at 11:05
     * 
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseTypesAsync(String datasource, String ifNoneMatch, Integer page,
            final ApiCallback<List<Integer>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getUniverseTypesValidateBeforeCall(datasource, ifNoneMatch, page, callback);
        Type localVarReturnType = new TypeToken<List<Integer>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getUniverseTypesTypeId
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUniverseTypesTypeIdCall(Integer typeId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/universe/types/{type_id}/".replaceAll("\\{" + "type_id" + "\\}",
                apiClient.escapeString(typeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUniverseTypesTypeIdValidateBeforeCall(Integer typeId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling getUniverseTypesTypeId(Async)");
        }

        com.squareup.okhttp.Call call = getUniverseTypesTypeIdCall(typeId, acceptLanguage, datasource, ifNoneMatch,
                language, callback);
        return call;

    }

    /**
     * Get type information Get information on a type --- This route expires
     * daily at 11:05
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return TypeResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public TypeResponse getUniverseTypesTypeId(Integer typeId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language) throws ApiException {
        ApiResponse<TypeResponse> resp = getUniverseTypesTypeIdWithHttpInfo(typeId, acceptLanguage, datasource,
                ifNoneMatch, language);
        return resp.getData();
    }

    /**
     * Get type information Get information on a type --- This route expires
     * daily at 11:05
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;TypeResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<TypeResponse> getUniverseTypesTypeIdWithHttpInfo(Integer typeId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language) throws ApiException {
        com.squareup.okhttp.Call call = getUniverseTypesTypeIdValidateBeforeCall(typeId, acceptLanguage, datasource,
                ifNoneMatch, language, null);
        Type localVarReturnType = new TypeToken<TypeResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get type information (asynchronously) Get information on a type --- This
     * route expires daily at 11:05
     * 
     * @param typeId
     *            An Eve item type ID (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getUniverseTypesTypeIdAsync(Integer typeId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, final ApiCallback<TypeResponse> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getUniverseTypesTypeIdValidateBeforeCall(typeId, acceptLanguage, datasource,
                ifNoneMatch, language, callback);
        Type localVarReturnType = new TypeToken<TypeResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postUniverseIds
     * 
     * @param requestBody
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postUniverseIdsCall(List<String> requestBody, String acceptLanguage,
            String datasource, String language, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v1/universe/ids/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postUniverseIdsValidateBeforeCall(List<String> requestBody, String acceptLanguage,
            String datasource, String language, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling postUniverseIds(Async)");
        }

        com.squareup.okhttp.Call call = postUniverseIdsCall(requestBody, acceptLanguage, datasource, language, callback);
        return call;

    }

    /**
     * Bulk names to IDs Resolve a set of names to IDs in the following
     * categories: agents, alliances, characters, constellations, corporations
     * factions, inventory_types, regions, stations, and systems. Only exact
     * matches will be returned. All names searched for are cached for 12 hours
     * ---
     * 
     * @param requestBody
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return UniverseIdsResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public UniverseIdsResponse postUniverseIds(List<String> requestBody, String acceptLanguage, String datasource,
            String language) throws ApiException {
        ApiResponse<UniverseIdsResponse> resp = postUniverseIdsWithHttpInfo(requestBody, acceptLanguage, datasource,
                language);
        return resp.getData();
    }

    /**
     * Bulk names to IDs Resolve a set of names to IDs in the following
     * categories: agents, alliances, characters, constellations, corporations
     * factions, inventory_types, regions, stations, and systems. Only exact
     * matches will be returned. All names searched for are cached for 12 hours
     * ---
     * 
     * @param requestBody
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @return ApiResponse&lt;UniverseIdsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<UniverseIdsResponse> postUniverseIdsWithHttpInfo(List<String> requestBody,
            String acceptLanguage, String datasource, String language) throws ApiException {
        com.squareup.okhttp.Call call = postUniverseIdsValidateBeforeCall(requestBody, acceptLanguage, datasource,
                language, null);
        Type localVarReturnType = new TypeToken<UniverseIdsResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Bulk names to IDs (asynchronously) Resolve a set of names to IDs in the
     * following categories: agents, alliances, characters, constellations,
     * corporations factions, inventory_types, regions, stations, and systems.
     * Only exact matches will be returned. All names searched for are cached
     * for 12 hours ---
     * 
     * @param requestBody
     *            The names to resolve (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postUniverseIdsAsync(List<String> requestBody, String acceptLanguage,
            String datasource, String language, final ApiCallback<UniverseIdsResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = postUniverseIdsValidateBeforeCall(requestBody, acceptLanguage, datasource,
                language, callback);
        Type localVarReturnType = new TypeToken<UniverseIdsResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postUniverseNames
     * 
     * @param requestBody
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postUniverseNamesCall(List<Integer> requestBody, String datasource,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v3/universe/names/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postUniverseNamesValidateBeforeCall(List<Integer> requestBody, String datasource,
            final ApiCallback callback) throws ApiException {

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling postUniverseNames(Async)");
        }

        com.squareup.okhttp.Call call = postUniverseNamesCall(requestBody, datasource, callback);
        return call;

    }

    /**
     * Get names and categories for a set of IDs Resolve a set of IDs to names
     * and categories. Supported ID&#39;s for resolving are: Characters,
     * Corporations, Alliances, Stations, Solar Systems, Constellations,
     * Regions, Types, Factions ---
     * 
     * @param requestBody
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @return List&lt;UniverseNamesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<UniverseNamesResponse> postUniverseNames(List<Integer> requestBody, String datasource)
            throws ApiException {
        ApiResponse<List<UniverseNamesResponse>> resp = postUniverseNamesWithHttpInfo(requestBody, datasource);
        return resp.getData();
    }

    /**
     * Get names and categories for a set of IDs Resolve a set of IDs to names
     * and categories. Supported ID&#39;s for resolving are: Characters,
     * Corporations, Alliances, Stations, Solar Systems, Constellations,
     * Regions, Types, Factions ---
     * 
     * @param requestBody
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @return ApiResponse&lt;List&lt;UniverseNamesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<UniverseNamesResponse>> postUniverseNamesWithHttpInfo(List<Integer> requestBody,
            String datasource) throws ApiException {
        com.squareup.okhttp.Call call = postUniverseNamesValidateBeforeCall(requestBody, datasource, null);
        Type localVarReturnType = new TypeToken<List<UniverseNamesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get names and categories for a set of IDs (asynchronously) Resolve a set
     * of IDs to names and categories. Supported ID&#39;s for resolving are:
     * Characters, Corporations, Alliances, Stations, Solar Systems,
     * Constellations, Regions, Types, Factions ---
     * 
     * @param requestBody
     *            The ids to resolve (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postUniverseNamesAsync(List<Integer> requestBody, String datasource,
            final ApiCallback<List<UniverseNamesResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postUniverseNamesValidateBeforeCall(requestBody, datasource, callback);
        Type localVarReturnType = new TypeToken<List<UniverseNamesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
