/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterLoyaltyPointsResponse;
import net.troja.eve.esi.model.LoyaltyStoreOffersResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoyaltyApi {
    private ApiClient apiClient;

    public LoyaltyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LoyaltyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterIdLoyaltyPoints
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdLoyaltyPointsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/loyalty/points/".replaceAll(
                "\\{" + "character_id" + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdLoyaltyPointsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdLoyaltyPoints(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdLoyaltyPointsCall(characterId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get loyalty points Return a list of loyalty points for all corporations
     * the character has worked for --- This route is cached for up to 3600
     * seconds SSO Scope: esi-characters.read_loyalty.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterLoyaltyPointsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterLoyaltyPointsResponse> getCharactersCharacterIdLoyaltyPoints(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterLoyaltyPointsResponse>> resp = getCharactersCharacterIdLoyaltyPointsWithHttpInfo(
                characterId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get loyalty points Return a list of loyalty points for all corporations
     * the character has worked for --- This route is cached for up to 3600
     * seconds SSO Scope: esi-characters.read_loyalty.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterLoyaltyPointsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterLoyaltyPointsResponse>> getCharactersCharacterIdLoyaltyPointsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdLoyaltyPointsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterLoyaltyPointsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get loyalty points (asynchronously) Return a list of loyalty points for
     * all corporations the character has worked for --- This route is cached
     * for up to 3600 seconds SSO Scope: esi-characters.read_loyalty.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdLoyaltyPointsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterLoyaltyPointsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdLoyaltyPointsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterLoyaltyPointsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getLoyaltyStoresCorporationIdOffers
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLoyaltyStoresCorporationIdOffersCall(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/loyalty/stores/{corporation_id}/offers/".replaceAll(
                "\\{" + "corporation_id" + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLoyaltyStoresCorporationIdOffersValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getLoyaltyStoresCorporationIdOffers(Async)");
        }

        com.squareup.okhttp.Call call = getLoyaltyStoresCorporationIdOffersCall(corporationId, datasource, ifNoneMatch,
                callback);
        return call;

    }

    /**
     * List loyalty store offers Return a list of offers from a specific
     * corporation&#39;s loyalty store --- This route expires daily at 11:05
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;LoyaltyStoreOffersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<LoyaltyStoreOffersResponse> getLoyaltyStoresCorporationIdOffers(Integer corporationId,
            String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<LoyaltyStoreOffersResponse>> resp = getLoyaltyStoresCorporationIdOffersWithHttpInfo(
                corporationId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * List loyalty store offers Return a list of offers from a specific
     * corporation&#39;s loyalty store --- This route expires daily at 11:05
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;List&lt;LoyaltyStoreOffersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<LoyaltyStoreOffersResponse>> getLoyaltyStoresCorporationIdOffersWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getLoyaltyStoresCorporationIdOffersValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<LoyaltyStoreOffersResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * List loyalty store offers (asynchronously) Return a list of offers from a
     * specific corporation&#39;s loyalty store --- This route expires daily at
     * 11:05
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getLoyaltyStoresCorporationIdOffersAsync(Integer corporationId, String datasource,
            String ifNoneMatch, final ApiCallback<List<LoyaltyStoreOffersResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getLoyaltyStoresCorporationIdOffersValidateBeforeCall(corporationId,
                datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<LoyaltyStoreOffersResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
