/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterFleetResponse;
import net.troja.eve.esi.model.FleetInvitation;
import net.troja.eve.esi.model.FleetMemberMovement;
import net.troja.eve.esi.model.FleetMembersResponse;
import net.troja.eve.esi.model.FleetNewSettings;
import net.troja.eve.esi.model.FleetResponse;
import net.troja.eve.esi.model.FleetSquadCreatedResponse;
import net.troja.eve.esi.model.FleetSquadNaming;
import net.troja.eve.esi.model.FleetWingCreatedResponse;
import net.troja.eve.esi.model.FleetWingNaming;
import net.troja.eve.esi.model.FleetWingsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FleetsApi {
    private ApiClient apiClient;

    public FleetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FleetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteFleetsFleetIdMembersMemberId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFleetsFleetIdMembersMemberIdCall(Long fleetId, Integer memberId,
            String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/members/{member_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "member_id" + "\\}",
                apiClient.escapeString(memberId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFleetsFleetIdMembersMemberIdValidateBeforeCall(Long fleetId,
            Integer memberId, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling deleteFleetsFleetIdMembersMemberId(Async)");
        }

        // verify the required parameter 'memberId' is set
        if (memberId == null) {
            throw new ApiException(
                    "Missing the required parameter 'memberId' when calling deleteFleetsFleetIdMembersMemberId(Async)");
        }

        com.squareup.okhttp.Call call = deleteFleetsFleetIdMembersMemberIdCall(fleetId, memberId, datasource, token,
                callback);
        return call;

    }

    /**
     * Kick fleet member Kick a fleet member --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void deleteFleetsFleetIdMembersMemberId(Long fleetId, Integer memberId, String datasource, String token)
            throws ApiException {
        deleteFleetsFleetIdMembersMemberIdWithHttpInfo(fleetId, memberId, datasource, token);
    }

    /**
     * Kick fleet member Kick a fleet member --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> deleteFleetsFleetIdMembersMemberIdWithHttpInfo(Long fleetId, Integer memberId,
            String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = deleteFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId,
                datasource, token, null);
        return apiClient.execute(call);
    }

    /**
     * Kick fleet member (asynchronously) Kick a fleet member --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call deleteFleetsFleetIdMembersMemberIdAsync(Long fleetId, Integer memberId,
            String datasource, String token, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = deleteFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId,
                datasource, token, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for deleteFleetsFleetIdSquadsSquadId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFleetsFleetIdSquadsSquadIdCall(Long fleetId, Long squadId, String datasource,
            String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/squads/{squad_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "squad_id" + "\\}",
                apiClient.escapeString(squadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFleetsFleetIdSquadsSquadIdValidateBeforeCall(Long fleetId, Long squadId,
            String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling deleteFleetsFleetIdSquadsSquadId(Async)");
        }

        // verify the required parameter 'squadId' is set
        if (squadId == null) {
            throw new ApiException(
                    "Missing the required parameter 'squadId' when calling deleteFleetsFleetIdSquadsSquadId(Async)");
        }

        com.squareup.okhttp.Call call = deleteFleetsFleetIdSquadsSquadIdCall(fleetId, squadId, datasource, token,
                callback);
        return call;

    }

    /**
     * Delete fleet squad Delete a fleet squad, only empty squads can be deleted
     * --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void deleteFleetsFleetIdSquadsSquadId(Long fleetId, Long squadId, String datasource, String token)
            throws ApiException {
        deleteFleetsFleetIdSquadsSquadIdWithHttpInfo(fleetId, squadId, datasource, token);
    }

    /**
     * Delete fleet squad Delete a fleet squad, only empty squads can be deleted
     * --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> deleteFleetsFleetIdSquadsSquadIdWithHttpInfo(Long fleetId, Long squadId,
            String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = deleteFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId,
                datasource, token, null);
        return apiClient.execute(call);
    }

    /**
     * Delete fleet squad (asynchronously) Delete a fleet squad, only empty
     * squads can be deleted --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call deleteFleetsFleetIdSquadsSquadIdAsync(Long fleetId, Long squadId,
            String datasource, String token, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = deleteFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId,
                datasource, token, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for deleteFleetsFleetIdWingsWingId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFleetsFleetIdWingsWingIdCall(Long fleetId, Long wingId, String datasource,
            String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/wings/{wing_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "wing_id" + "\\}",
                apiClient.escapeString(wingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFleetsFleetIdWingsWingIdValidateBeforeCall(Long fleetId, Long wingId,
            String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling deleteFleetsFleetIdWingsWingId(Async)");
        }

        // verify the required parameter 'wingId' is set
        if (wingId == null) {
            throw new ApiException(
                    "Missing the required parameter 'wingId' when calling deleteFleetsFleetIdWingsWingId(Async)");
        }

        com.squareup.okhttp.Call call = deleteFleetsFleetIdWingsWingIdCall(fleetId, wingId, datasource, token, callback);
        return call;

    }

    /**
     * Delete fleet wing Delete a fleet wing, only empty wings can be deleted.
     * The wing may contain squads, but the squads must be empty --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void deleteFleetsFleetIdWingsWingId(Long fleetId, Long wingId, String datasource, String token)
            throws ApiException {
        deleteFleetsFleetIdWingsWingIdWithHttpInfo(fleetId, wingId, datasource, token);
    }

    /**
     * Delete fleet wing Delete a fleet wing, only empty wings can be deleted.
     * The wing may contain squads, but the squads must be empty --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> deleteFleetsFleetIdWingsWingIdWithHttpInfo(Long fleetId, Long wingId, String datasource,
            String token) throws ApiException {
        com.squareup.okhttp.Call call = deleteFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, datasource,
                token, null);
        return apiClient.execute(call);
    }

    /**
     * Delete fleet wing (asynchronously) Delete a fleet wing, only empty wings
     * can be deleted. The wing may contain squads, but the squads must be empty
     * --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to delete (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call deleteFleetsFleetIdWingsWingIdAsync(Long fleetId, Long wingId, String datasource,
            String token, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = deleteFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, datasource,
                token, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdFleet
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdFleetCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/fleet/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdFleetValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdFleet(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdFleetCall(characterId, datasource, ifNoneMatch, token,
                callback);
        return call;

    }

    /**
     * Get character fleet info Return the fleet ID the character is in, if any.
     * --- This route is cached for up to 60 seconds SSO Scope:
     * esi-fleets.read_fleet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return CharacterFleetResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CharacterFleetResponse getCharactersCharacterIdFleet(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterFleetResponse> resp = getCharactersCharacterIdFleetWithHttpInfo(characterId, datasource,
                ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get character fleet info Return the fleet ID the character is in, if any.
     * --- This route is cached for up to 60 seconds SSO Scope:
     * esi-fleets.read_fleet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;CharacterFleetResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CharacterFleetResponse> getCharactersCharacterIdFleetWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdFleetValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterFleetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character fleet info (asynchronously) Return the fleet ID the
     * character is in, if any. --- This route is cached for up to 60 seconds
     * SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdFleetAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<CharacterFleetResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdFleetValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<CharacterFleetResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getFleetsFleetId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFleetsFleetIdCall(Long fleetId, String datasource, String ifNoneMatch,
            String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFleetsFleetIdValidateBeforeCall(Long fleetId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling getFleetsFleetId(Async)");
        }

        com.squareup.okhttp.Call call = getFleetsFleetIdCall(fleetId, datasource, ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get fleet information Return details about a fleet --- This route is
     * cached for up to 5 seconds SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return FleetResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public FleetResponse getFleetsFleetId(Long fleetId, String datasource, String ifNoneMatch, String token)
            throws ApiException {
        ApiResponse<FleetResponse> resp = getFleetsFleetIdWithHttpInfo(fleetId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get fleet information Return details about a fleet --- This route is
     * cached for up to 5 seconds SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;FleetResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<FleetResponse> getFleetsFleetIdWithHttpInfo(Long fleetId, String datasource, String ifNoneMatch,
            String token) throws ApiException {
        com.squareup.okhttp.Call call = getFleetsFleetIdValidateBeforeCall(fleetId, datasource, ifNoneMatch, token,
                null);
        Type localVarReturnType = new TypeToken<FleetResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get fleet information (asynchronously) Return details about a fleet ---
     * This route is cached for up to 5 seconds SSO Scope:
     * esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getFleetsFleetIdAsync(Long fleetId, String datasource, String ifNoneMatch,
            String token, final ApiCallback<FleetResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getFleetsFleetIdValidateBeforeCall(fleetId, datasource, ifNoneMatch, token,
                callback);
        Type localVarReturnType = new TypeToken<FleetResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getFleetsFleetIdMembers
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFleetsFleetIdMembersCall(Long fleetId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/members/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFleetsFleetIdMembersValidateBeforeCall(Long fleetId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling getFleetsFleetIdMembers(Async)");
        }

        com.squareup.okhttp.Call call = getFleetsFleetIdMembersCall(fleetId, acceptLanguage, datasource, ifNoneMatch,
                language, token, callback);
        return call;

    }

    /**
     * Get fleet members Return information about fleet members --- This route
     * is cached for up to 5 seconds SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;FleetMembersResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<FleetMembersResponse> getFleetsFleetIdMembers(Long fleetId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, String token) throws ApiException {
        ApiResponse<List<FleetMembersResponse>> resp = getFleetsFleetIdMembersWithHttpInfo(fleetId, acceptLanguage,
                datasource, ifNoneMatch, language, token);
        return resp.getData();
    }

    /**
     * Get fleet members Return information about fleet members --- This route
     * is cached for up to 5 seconds SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;FleetMembersResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<FleetMembersResponse>> getFleetsFleetIdMembersWithHttpInfo(Long fleetId,
            String acceptLanguage, String datasource, String ifNoneMatch, String language, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getFleetsFleetIdMembersValidateBeforeCall(fleetId, acceptLanguage, datasource,
                ifNoneMatch, language, token, null);
        Type localVarReturnType = new TypeToken<List<FleetMembersResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get fleet members (asynchronously) Return information about fleet members
     * --- This route is cached for up to 5 seconds SSO Scope:
     * esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getFleetsFleetIdMembersAsync(Long fleetId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, String token,
            final ApiCallback<List<FleetMembersResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getFleetsFleetIdMembersValidateBeforeCall(fleetId, acceptLanguage, datasource,
                ifNoneMatch, language, token, callback);
        Type localVarReturnType = new TypeToken<List<FleetMembersResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getFleetsFleetIdWings
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFleetsFleetIdWingsCall(Long fleetId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/wings/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (language != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("language", language));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));
        }

        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFleetsFleetIdWingsValidateBeforeCall(Long fleetId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling getFleetsFleetIdWings(Async)");
        }

        com.squareup.okhttp.Call call = getFleetsFleetIdWingsCall(fleetId, acceptLanguage, datasource, ifNoneMatch,
                language, token, callback);
        return call;

    }

    /**
     * Get fleet wings Return information about wings in a fleet --- This route
     * is cached for up to 5 seconds SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;FleetWingsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<FleetWingsResponse> getFleetsFleetIdWings(Long fleetId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, String token) throws ApiException {
        ApiResponse<List<FleetWingsResponse>> resp = getFleetsFleetIdWingsWithHttpInfo(fleetId, acceptLanguage,
                datasource, ifNoneMatch, language, token);
        return resp.getData();
    }

    /**
     * Get fleet wings Return information about wings in a fleet --- This route
     * is cached for up to 5 seconds SSO Scope: esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;FleetWingsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<FleetWingsResponse>> getFleetsFleetIdWingsWithHttpInfo(Long fleetId, String acceptLanguage,
            String datasource, String ifNoneMatch, String language, String token) throws ApiException {
        com.squareup.okhttp.Call call = getFleetsFleetIdWingsValidateBeforeCall(fleetId, acceptLanguage, datasource,
                ifNoneMatch, language, token, null);
        Type localVarReturnType = new TypeToken<List<FleetWingsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get fleet wings (asynchronously) Return information about wings in a
     * fleet --- This route is cached for up to 5 seconds SSO Scope:
     * esi-fleets.read_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param acceptLanguage
     *            Language to use in the response (optional, default to en-us)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param language
     *            Language to use in the response, takes precedence over
     *            Accept-Language (optional, default to en-us)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getFleetsFleetIdWingsAsync(Long fleetId, String acceptLanguage, String datasource,
            String ifNoneMatch, String language, String token, final ApiCallback<List<FleetWingsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getFleetsFleetIdWingsValidateBeforeCall(fleetId, acceptLanguage, datasource,
                ifNoneMatch, language, token, callback);
        Type localVarReturnType = new TypeToken<List<FleetWingsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postFleetsFleetIdMembers
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetInvitation
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postFleetsFleetIdMembersCall(Long fleetId, String datasource, String token,
            FleetInvitation fleetInvitation, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = fleetInvitation;

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/members/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postFleetsFleetIdMembersValidateBeforeCall(Long fleetId, String datasource,
            String token, FleetInvitation fleetInvitation, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling postFleetsFleetIdMembers(Async)");
        }

        com.squareup.okhttp.Call call = postFleetsFleetIdMembersCall(fleetId, datasource, token, fleetInvitation,
                callback);
        return call;

    }

    /**
     * Create fleet invitation Invite a character into the fleet. If a character
     * has a CSPA charge set it is not possible to invite them to the fleet
     * using ESI --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetInvitation
     *            (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void postFleetsFleetIdMembers(Long fleetId, String datasource, String token, FleetInvitation fleetInvitation)
            throws ApiException {
        postFleetsFleetIdMembersWithHttpInfo(fleetId, datasource, token, fleetInvitation);
    }

    /**
     * Create fleet invitation Invite a character into the fleet. If a character
     * has a CSPA charge set it is not possible to invite them to the fleet
     * using ESI --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetInvitation
     *            (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> postFleetsFleetIdMembersWithHttpInfo(Long fleetId, String datasource, String token,
            FleetInvitation fleetInvitation) throws ApiException {
        com.squareup.okhttp.Call call = postFleetsFleetIdMembersValidateBeforeCall(fleetId, datasource, token,
                fleetInvitation, null);
        return apiClient.execute(call);
    }

    /**
     * Create fleet invitation (asynchronously) Invite a character into the
     * fleet. If a character has a CSPA charge set it is not possible to invite
     * them to the fleet using ESI --- SSO Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetInvitation
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postFleetsFleetIdMembersAsync(Long fleetId, String datasource, String token,
            FleetInvitation fleetInvitation, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = postFleetsFleetIdMembersValidateBeforeCall(fleetId, datasource, token,
                fleetInvitation, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for postFleetsFleetIdWings
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postFleetsFleetIdWingsCall(Long fleetId, String datasource, String token,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/wings/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postFleetsFleetIdWingsValidateBeforeCall(Long fleetId, String datasource,
            String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling postFleetsFleetIdWings(Async)");
        }

        com.squareup.okhttp.Call call = postFleetsFleetIdWingsCall(fleetId, datasource, token, callback);
        return call;

    }

    /**
     * Create fleet wing Create a new wing in a fleet --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return FleetWingCreatedResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public FleetWingCreatedResponse postFleetsFleetIdWings(Long fleetId, String datasource, String token)
            throws ApiException {
        ApiResponse<FleetWingCreatedResponse> resp = postFleetsFleetIdWingsWithHttpInfo(fleetId, datasource, token);
        return resp.getData();
    }

    /**
     * Create fleet wing Create a new wing in a fleet --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;FleetWingCreatedResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<FleetWingCreatedResponse> postFleetsFleetIdWingsWithHttpInfo(Long fleetId, String datasource,
            String token) throws ApiException {
        com.squareup.okhttp.Call call = postFleetsFleetIdWingsValidateBeforeCall(fleetId, datasource, token, null);
        Type localVarReturnType = new TypeToken<FleetWingCreatedResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create fleet wing (asynchronously) Create a new wing in a fleet --- SSO
     * Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postFleetsFleetIdWingsAsync(Long fleetId, String datasource, String token,
            final ApiCallback<FleetWingCreatedResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = postFleetsFleetIdWingsValidateBeforeCall(fleetId, datasource, token, callback);
        Type localVarReturnType = new TypeToken<FleetWingCreatedResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postFleetsFleetIdWingsWingIdSquads
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing_id to create squad in (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postFleetsFleetIdWingsWingIdSquadsCall(Long fleetId, Long wingId,
            String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/wings/{wing_id}/squads/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "wing_id" + "\\}",
                apiClient.escapeString(wingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postFleetsFleetIdWingsWingIdSquadsValidateBeforeCall(Long fleetId, Long wingId,
            String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling postFleetsFleetIdWingsWingIdSquads(Async)");
        }

        // verify the required parameter 'wingId' is set
        if (wingId == null) {
            throw new ApiException(
                    "Missing the required parameter 'wingId' when calling postFleetsFleetIdWingsWingIdSquads(Async)");
        }

        com.squareup.okhttp.Call call = postFleetsFleetIdWingsWingIdSquadsCall(fleetId, wingId, datasource, token,
                callback);
        return call;

    }

    /**
     * Create fleet squad Create a new squad in a fleet --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing_id to create squad in (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return FleetSquadCreatedResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public FleetSquadCreatedResponse postFleetsFleetIdWingsWingIdSquads(Long fleetId, Long wingId, String datasource,
            String token) throws ApiException {
        ApiResponse<FleetSquadCreatedResponse> resp = postFleetsFleetIdWingsWingIdSquadsWithHttpInfo(fleetId, wingId,
                datasource, token);
        return resp.getData();
    }

    /**
     * Create fleet squad Create a new squad in a fleet --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing_id to create squad in (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;FleetSquadCreatedResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<FleetSquadCreatedResponse> postFleetsFleetIdWingsWingIdSquadsWithHttpInfo(Long fleetId,
            Long wingId, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = postFleetsFleetIdWingsWingIdSquadsValidateBeforeCall(fleetId, wingId,
                datasource, token, null);
        Type localVarReturnType = new TypeToken<FleetSquadCreatedResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create fleet squad (asynchronously) Create a new squad in a fleet --- SSO
     * Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing_id to create squad in (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postFleetsFleetIdWingsWingIdSquadsAsync(Long fleetId, Long wingId,
            String datasource, String token, final ApiCallback<FleetSquadCreatedResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = postFleetsFleetIdWingsWingIdSquadsValidateBeforeCall(fleetId, wingId,
                datasource, token, callback);
        Type localVarReturnType = new TypeToken<FleetSquadCreatedResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for putFleetsFleetId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetNewSettings
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdCall(Long fleetId, String datasource, String token,
            FleetNewSettings fleetNewSettings, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = fleetNewSettings;

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call putFleetsFleetIdValidateBeforeCall(Long fleetId, String datasource, String token,
            FleetNewSettings fleetNewSettings, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException("Missing the required parameter 'fleetId' when calling putFleetsFleetId(Async)");
        }

        com.squareup.okhttp.Call call = putFleetsFleetIdCall(fleetId, datasource, token, fleetNewSettings, callback);
        return call;

    }

    /**
     * Update fleet Update settings about a fleet --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetNewSettings
     *            (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void putFleetsFleetId(Long fleetId, String datasource, String token, FleetNewSettings fleetNewSettings)
            throws ApiException {
        putFleetsFleetIdWithHttpInfo(fleetId, datasource, token, fleetNewSettings);
    }

    /**
     * Update fleet Update settings about a fleet --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetNewSettings
     *            (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> putFleetsFleetIdWithHttpInfo(Long fleetId, String datasource, String token,
            FleetNewSettings fleetNewSettings) throws ApiException {
        com.squareup.okhttp.Call call = putFleetsFleetIdValidateBeforeCall(fleetId, datasource, token,
                fleetNewSettings, null);
        return apiClient.execute(call);
    }

    /**
     * Update fleet (asynchronously) Update settings about a fleet --- SSO
     * Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetNewSettings
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdAsync(Long fleetId, String datasource, String token,
            FleetNewSettings fleetNewSettings, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = putFleetsFleetIdValidateBeforeCall(fleetId, datasource, token,
                fleetNewSettings, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for putFleetsFleetIdMembersMemberId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetMemberMovement
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdMembersMemberIdCall(Long fleetId, Integer memberId,
            String datasource, String token, FleetMemberMovement fleetMemberMovement, final ApiCallback callback)
            throws ApiException {
        Object localVarPostBody = fleetMemberMovement;

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/members/{member_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "member_id" + "\\}",
                apiClient.escapeString(memberId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call putFleetsFleetIdMembersMemberIdValidateBeforeCall(Long fleetId, Integer memberId,
            String datasource, String token, FleetMemberMovement fleetMemberMovement, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling putFleetsFleetIdMembersMemberId(Async)");
        }

        // verify the required parameter 'memberId' is set
        if (memberId == null) {
            throw new ApiException(
                    "Missing the required parameter 'memberId' when calling putFleetsFleetIdMembersMemberId(Async)");
        }

        com.squareup.okhttp.Call call = putFleetsFleetIdMembersMemberIdCall(fleetId, memberId, datasource, token,
                fleetMemberMovement, callback);
        return call;

    }

    /**
     * Move fleet member Move a fleet member around --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetMemberMovement
     *            (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void putFleetsFleetIdMembersMemberId(Long fleetId, Integer memberId, String datasource, String token,
            FleetMemberMovement fleetMemberMovement) throws ApiException {
        putFleetsFleetIdMembersMemberIdWithHttpInfo(fleetId, memberId, datasource, token, fleetMemberMovement);
    }

    /**
     * Move fleet member Move a fleet member around --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetMemberMovement
     *            (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> putFleetsFleetIdMembersMemberIdWithHttpInfo(Long fleetId, Integer memberId,
            String datasource, String token, FleetMemberMovement fleetMemberMovement) throws ApiException {
        com.squareup.okhttp.Call call = putFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId,
                datasource, token, fleetMemberMovement, null);
        return apiClient.execute(call);
    }

    /**
     * Move fleet member (asynchronously) Move a fleet member around --- SSO
     * Scope: esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param memberId
     *            The character ID of a member in this fleet (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetMemberMovement
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdMembersMemberIdAsync(Long fleetId, Integer memberId,
            String datasource, String token, FleetMemberMovement fleetMemberMovement, final ApiCallback<Void> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = putFleetsFleetIdMembersMemberIdValidateBeforeCall(fleetId, memberId,
                datasource, token, fleetMemberMovement, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for putFleetsFleetIdSquadsSquadId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetSquadNaming
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdSquadsSquadIdCall(Long fleetId, Long squadId, String datasource,
            String token, FleetSquadNaming fleetSquadNaming, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = fleetSquadNaming;

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/squads/{squad_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "squad_id" + "\\}",
                apiClient.escapeString(squadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call putFleetsFleetIdSquadsSquadIdValidateBeforeCall(Long fleetId, Long squadId,
            String datasource, String token, FleetSquadNaming fleetSquadNaming, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling putFleetsFleetIdSquadsSquadId(Async)");
        }

        // verify the required parameter 'squadId' is set
        if (squadId == null) {
            throw new ApiException(
                    "Missing the required parameter 'squadId' when calling putFleetsFleetIdSquadsSquadId(Async)");
        }

        com.squareup.okhttp.Call call = putFleetsFleetIdSquadsSquadIdCall(fleetId, squadId, datasource, token,
                fleetSquadNaming, callback);
        return call;

    }

    /**
     * Rename fleet squad Rename a fleet squad --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetSquadNaming
     *            (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void putFleetsFleetIdSquadsSquadId(Long fleetId, Long squadId, String datasource, String token,
            FleetSquadNaming fleetSquadNaming) throws ApiException {
        putFleetsFleetIdSquadsSquadIdWithHttpInfo(fleetId, squadId, datasource, token, fleetSquadNaming);
    }

    /**
     * Rename fleet squad Rename a fleet squad --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetSquadNaming
     *            (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> putFleetsFleetIdSquadsSquadIdWithHttpInfo(Long fleetId, Long squadId, String datasource,
            String token, FleetSquadNaming fleetSquadNaming) throws ApiException {
        com.squareup.okhttp.Call call = putFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId, datasource,
                token, fleetSquadNaming, null);
        return apiClient.execute(call);
    }

    /**
     * Rename fleet squad (asynchronously) Rename a fleet squad --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param squadId
     *            The squad to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetSquadNaming
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdSquadsSquadIdAsync(Long fleetId, Long squadId, String datasource,
            String token, FleetSquadNaming fleetSquadNaming, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = putFleetsFleetIdSquadsSquadIdValidateBeforeCall(fleetId, squadId, datasource,
                token, fleetSquadNaming, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }

    /**
     * Build call for putFleetsFleetIdWingsWingId
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetWingNaming
     *            (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdWingsWingIdCall(Long fleetId, Long wingId, String datasource,
            String token, FleetWingNaming fleetWingNaming, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = fleetWingNaming;

        // create path and map variables
        String localVarPath = "/v1/fleets/{fleet_id}/wings/{wing_id}/".replaceAll("\\{" + "fleet_id" + "\\}",
                apiClient.escapeString(fleetId.toString())).replaceAll("\\{" + "wing_id" + "\\}",
                apiClient.escapeString(wingId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {

        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call putFleetsFleetIdWingsWingIdValidateBeforeCall(Long fleetId, Long wingId,
            String datasource, String token, FleetWingNaming fleetWingNaming, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'fleetId' is set
        if (fleetId == null) {
            throw new ApiException(
                    "Missing the required parameter 'fleetId' when calling putFleetsFleetIdWingsWingId(Async)");
        }

        // verify the required parameter 'wingId' is set
        if (wingId == null) {
            throw new ApiException(
                    "Missing the required parameter 'wingId' when calling putFleetsFleetIdWingsWingId(Async)");
        }

        com.squareup.okhttp.Call call = putFleetsFleetIdWingsWingIdCall(fleetId, wingId, datasource, token,
                fleetWingNaming, callback);
        return call;

    }

    /**
     * Rename fleet wing Rename a fleet wing --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetWingNaming
     *            (optional)
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public void putFleetsFleetIdWingsWingId(Long fleetId, Long wingId, String datasource, String token,
            FleetWingNaming fleetWingNaming) throws ApiException {
        putFleetsFleetIdWingsWingIdWithHttpInfo(fleetId, wingId, datasource, token, fleetWingNaming);
    }

    /**
     * Rename fleet wing Rename a fleet wing --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetWingNaming
     *            (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Void> putFleetsFleetIdWingsWingIdWithHttpInfo(Long fleetId, Long wingId, String datasource,
            String token, FleetWingNaming fleetWingNaming) throws ApiException {
        com.squareup.okhttp.Call call = putFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, datasource,
                token, fleetWingNaming, null);
        return apiClient.execute(call);
    }

    /**
     * Rename fleet wing (asynchronously) Rename a fleet wing --- SSO Scope:
     * esi-fleets.write_fleet.v1
     * 
     * @param fleetId
     *            ID for a fleet (required)
     * @param wingId
     *            The wing to rename (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param fleetWingNaming
     *            (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call putFleetsFleetIdWingsWingIdAsync(Long fleetId, Long wingId, String datasource,
            String token, FleetWingNaming fleetWingNaming, final ApiCallback<Void> callback) throws ApiException {

        com.squareup.okhttp.Call call = putFleetsFleetIdWingsWingIdValidateBeforeCall(fleetId, wingId, datasource,
                token, fleetWingNaming, callback);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
