/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterAffiliationResponse;
import net.troja.eve.esi.model.CharacterBlueprintsResponse;
import net.troja.eve.esi.model.CharacterCorporationHistoryResponse;
import net.troja.eve.esi.model.CharacterFatigueResponse;
import net.troja.eve.esi.model.CharacterMedalsResponse;
import net.troja.eve.esi.model.CharacterNotificationsResponse;
import net.troja.eve.esi.model.CharacterPortraitResponse;
import net.troja.eve.esi.model.CharacterResearchAgentsResponse;
import net.troja.eve.esi.model.CharacterResponse;
import net.troja.eve.esi.model.CharacterRolesResponse;
import net.troja.eve.esi.model.CharacterStandingsResponse;
import net.troja.eve.esi.model.CharacterStatsResponse;
import net.troja.eve.esi.model.CharacterTitlesResponse;
import net.troja.eve.esi.model.NewContactNotificationsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharacterApi {
    private ApiClient apiClient;

    public CharacterApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CharacterApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterId
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdCall(Integer characterId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v4/characters/{character_id}/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdValidateBeforeCall(Integer characterId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterId(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdCall(characterId, datasource, ifNoneMatch, callback);
        return call;

    }

    /**
     * Get character&#39;s public information Public information about a
     * character --- This route is cached for up to 3600 seconds
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return CharacterResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CharacterResponse getCharactersCharacterId(Integer characterId, String datasource, String ifNoneMatch)
            throws ApiException {
        ApiResponse<CharacterResponse> resp = getCharactersCharacterIdWithHttpInfo(characterId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get character&#39;s public information Public information about a
     * character --- This route is cached for up to 3600 seconds
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;CharacterResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CharacterResponse> getCharactersCharacterIdWithHttpInfo(Integer characterId, String datasource,
            String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdValidateBeforeCall(characterId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CharacterResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character&#39;s public information (asynchronously) Public
     * information about a character --- This route is cached for up to 3600
     * seconds
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdAsync(Integer characterId, String datasource,
            String ifNoneMatch, final ApiCallback<CharacterResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdValidateBeforeCall(characterId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<CharacterResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdAgentsResearch
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdAgentsResearchCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/agents_research/".replaceAll("\\{" + "character_id"
                + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdAgentsResearchValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdAgentsResearch(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdAgentsResearchCall(characterId, datasource,
                ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get agents research Return a list of agents research information for a
     * character. The formula for finding the current research points with an
     * agent is: currentPoints &#x3D; remainderPoints + pointsPerDay *
     * days(currentTime - researchStartDate) --- This route is cached for up to
     * 3600 seconds SSO Scope: esi-characters.read_agents_research.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterResearchAgentsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterResearchAgentsResponse> getCharactersCharacterIdAgentsResearch(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterResearchAgentsResponse>> resp = getCharactersCharacterIdAgentsResearchWithHttpInfo(
                characterId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get agents research Return a list of agents research information for a
     * character. The formula for finding the current research points with an
     * agent is: currentPoints &#x3D; remainderPoints + pointsPerDay *
     * days(currentTime - researchStartDate) --- This route is cached for up to
     * 3600 seconds SSO Scope: esi-characters.read_agents_research.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterResearchAgentsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterResearchAgentsResponse>> getCharactersCharacterIdAgentsResearchWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdAgentsResearchValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterResearchAgentsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get agents research (asynchronously) Return a list of agents research
     * information for a character. The formula for finding the current research
     * points with an agent is: currentPoints &#x3D; remainderPoints +
     * pointsPerDay * days(currentTime - researchStartDate) --- This route is
     * cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_agents_research.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdAgentsResearchAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterResearchAgentsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdAgentsResearchValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterResearchAgentsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdBlueprints
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdBlueprintsCall(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/blueprints/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdBlueprintsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdBlueprints(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdBlueprintsCall(characterId, datasource, ifNoneMatch,
                page, token, callback);
        return call;

    }

    /**
     * Get blueprints Return a list of blueprints the character owns --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_blueprints.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterBlueprintsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterBlueprintsResponse> getCharactersCharacterIdBlueprints(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterBlueprintsResponse>> resp = getCharactersCharacterIdBlueprintsWithHttpInfo(
                characterId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get blueprints Return a list of blueprints the character owns --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_blueprints.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterBlueprintsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterBlueprintsResponse>> getCharactersCharacterIdBlueprintsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdBlueprintsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterBlueprintsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get blueprints (asynchronously) Return a list of blueprints the character
     * owns --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_blueprints.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdBlueprintsAsync(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token,
            final ApiCallback<List<CharacterBlueprintsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdBlueprintsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterBlueprintsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdCorporationhistory
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdCorporationhistoryCall(Integer characterId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/corporationhistory/".replaceAll("\\{" + "character_id"
                + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdCorporationhistoryValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdCorporationhistory(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdCorporationhistoryCall(characterId, datasource,
                ifNoneMatch, callback);
        return call;

    }

    /**
     * Get corporation history Get a list of all the corporations a character
     * has been a member of --- This route is cached for up to 3600 seconds
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return List&lt;CharacterCorporationHistoryResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterCorporationHistoryResponse> getCharactersCharacterIdCorporationhistory(Integer characterId,
            String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<CharacterCorporationHistoryResponse>> resp = getCharactersCharacterIdCorporationhistoryWithHttpInfo(
                characterId, datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get corporation history Get a list of all the corporations a character
     * has been a member of --- This route is cached for up to 3600 seconds
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return 
     *         ApiResponse&lt;List&lt;CharacterCorporationHistoryResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterCorporationHistoryResponse>> getCharactersCharacterIdCorporationhistoryWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdCorporationhistoryValidateBeforeCall(characterId,
                datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<CharacterCorporationHistoryResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation history (asynchronously) Get a list of all the
     * corporations a character has been a member of --- This route is cached
     * for up to 3600 seconds
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdCorporationhistoryAsync(Integer characterId,
            String datasource, String ifNoneMatch, final ApiCallback<List<CharacterCorporationHistoryResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdCorporationhistoryValidateBeforeCall(characterId,
                datasource, ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<List<CharacterCorporationHistoryResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdFatigue
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdFatigueCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/fatigue/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdFatigueValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdFatigue(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdFatigueCall(characterId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get jump fatigue Return a character&#39;s jump activation and fatigue
     * information --- This route is cached for up to 300 seconds SSO Scope:
     * esi-characters.read_fatigue.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return CharacterFatigueResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CharacterFatigueResponse getCharactersCharacterIdFatigue(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterFatigueResponse> resp = getCharactersCharacterIdFatigueWithHttpInfo(characterId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get jump fatigue Return a character&#39;s jump activation and fatigue
     * information --- This route is cached for up to 300 seconds SSO Scope:
     * esi-characters.read_fatigue.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;CharacterFatigueResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CharacterFatigueResponse> getCharactersCharacterIdFatigueWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdFatigueValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterFatigueResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get jump fatigue (asynchronously) Return a character&#39;s jump
     * activation and fatigue information --- This route is cached for up to 300
     * seconds SSO Scope: esi-characters.read_fatigue.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdFatigueAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<CharacterFatigueResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdFatigueValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<CharacterFatigueResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdMedals
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMedalsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/medals/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdMedalsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdMedals(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdMedalsCall(characterId, datasource, ifNoneMatch, token,
                callback);
        return call;

    }

    /**
     * Get medals Return a list of medals the character has --- This route is
     * cached for up to 3600 seconds SSO Scope: esi-characters.read_medals.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterMedalsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterMedalsResponse> getCharactersCharacterIdMedals(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterMedalsResponse>> resp = getCharactersCharacterIdMedalsWithHttpInfo(characterId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get medals Return a list of medals the character has --- This route is
     * cached for up to 3600 seconds SSO Scope: esi-characters.read_medals.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterMedalsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterMedalsResponse>> getCharactersCharacterIdMedalsWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdMedalsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterMedalsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get medals (asynchronously) Return a list of medals the character has ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_medals.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdMedalsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterMedalsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdMedalsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterMedalsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdNotifications
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdNotificationsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v4/characters/{character_id}/notifications/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdNotificationsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdNotifications(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdNotificationsCall(characterId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get character notifications Return character notifications --- This route
     * is cached for up to 600 seconds SSO Scope:
     * esi-characters.read_notifications.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterNotificationsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterNotificationsResponse> getCharactersCharacterIdNotifications(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterNotificationsResponse>> resp = getCharactersCharacterIdNotificationsWithHttpInfo(
                characterId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get character notifications Return character notifications --- This route
     * is cached for up to 600 seconds SSO Scope:
     * esi-characters.read_notifications.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterNotificationsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterNotificationsResponse>> getCharactersCharacterIdNotificationsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdNotificationsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterNotificationsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character notifications (asynchronously) Return character
     * notifications --- This route is cached for up to 600 seconds SSO Scope:
     * esi-characters.read_notifications.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdNotificationsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterNotificationsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdNotificationsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterNotificationsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdNotificationsContacts
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdNotificationsContactsCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/notifications/contacts/".replaceAll("\\{" + "character_id"
                + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdNotificationsContactsValidateBeforeCall(
            Integer characterId, String datasource, String ifNoneMatch, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdNotificationsContacts(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdNotificationsContactsCall(characterId, datasource,
                ifNoneMatch, token, callback);
        return call;

    }

    /**
     * Get new contact notifications Return notifications about having been
     * added to someone&#39;s contact list --- This route is cached for up to
     * 600 seconds SSO Scope: esi-characters.read_notifications.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;NewContactNotificationsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<NewContactNotificationsResponse> getCharactersCharacterIdNotificationsContacts(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<NewContactNotificationsResponse>> resp = getCharactersCharacterIdNotificationsContactsWithHttpInfo(
                characterId, datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get new contact notifications Return notifications about having been
     * added to someone&#39;s contact list --- This route is cached for up to
     * 600 seconds SSO Scope: esi-characters.read_notifications.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;NewContactNotificationsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<NewContactNotificationsResponse>> getCharactersCharacterIdNotificationsContactsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdNotificationsContactsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<NewContactNotificationsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get new contact notifications (asynchronously) Return notifications about
     * having been added to someone&#39;s contact list --- This route is cached
     * for up to 600 seconds SSO Scope: esi-characters.read_notifications.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdNotificationsContactsAsync(Integer characterId,
            String datasource, String ifNoneMatch, String token,
            final ApiCallback<List<NewContactNotificationsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdNotificationsContactsValidateBeforeCall(characterId,
                datasource, ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<NewContactNotificationsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdPortrait
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdPortraitCall(Integer characterId, String datasource,
            String ifNoneMatch, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/portrait/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdPortraitValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdPortrait(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdPortraitCall(characterId, datasource, ifNoneMatch,
                callback);
        return call;

    }

    /**
     * Get character portraits Get portrait urls for a character --- This route
     * expires daily at 11:05
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return CharacterPortraitResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CharacterPortraitResponse getCharactersCharacterIdPortrait(Integer characterId, String datasource,
            String ifNoneMatch) throws ApiException {
        ApiResponse<CharacterPortraitResponse> resp = getCharactersCharacterIdPortraitWithHttpInfo(characterId,
                datasource, ifNoneMatch);
        return resp.getData();
    }

    /**
     * Get character portraits Get portrait urls for a character --- This route
     * expires daily at 11:05
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @return ApiResponse&lt;CharacterPortraitResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CharacterPortraitResponse> getCharactersCharacterIdPortraitWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdPortraitValidateBeforeCall(characterId, datasource,
                ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CharacterPortraitResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character portraits (asynchronously) Get portrait urls for a
     * character --- This route expires daily at 11:05
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdPortraitAsync(Integer characterId, String datasource,
            String ifNoneMatch, final ApiCallback<CharacterPortraitResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdPortraitValidateBeforeCall(characterId, datasource,
                ifNoneMatch, callback);
        Type localVarReturnType = new TypeToken<CharacterPortraitResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdRoles
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdRolesCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/roles/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdRolesValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdRoles(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdRolesCall(characterId, datasource, ifNoneMatch, token,
                callback);
        return call;

    }

    /**
     * Get character corporation roles Returns a character&#39;s corporation
     * roles --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_corporation_roles.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return CharacterRolesResponse
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public CharacterRolesResponse getCharactersCharacterIdRoles(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterRolesResponse> resp = getCharactersCharacterIdRolesWithHttpInfo(characterId, datasource,
                ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get character corporation roles Returns a character&#39;s corporation
     * roles --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_corporation_roles.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;CharacterRolesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<CharacterRolesResponse> getCharactersCharacterIdRolesWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdRolesValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterRolesResponse>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character corporation roles (asynchronously) Returns a
     * character&#39;s corporation roles --- This route is cached for up to 3600
     * seconds SSO Scope: esi-characters.read_corporation_roles.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdRolesAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<CharacterRolesResponse> callback) throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdRolesValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<CharacterRolesResponse>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdStandings
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdStandingsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/standings/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdStandingsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdStandings(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdStandingsCall(characterId, datasource, ifNoneMatch,
                token, callback);
        return call;

    }

    /**
     * Get standings Return character standings from agents, NPC corporations,
     * and factions --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_standings.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterStandingsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterStandingsResponse> getCharactersCharacterIdStandings(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterStandingsResponse>> resp = getCharactersCharacterIdStandingsWithHttpInfo(characterId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get standings Return character standings from agents, NPC corporations,
     * and factions --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_standings.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterStandingsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterStandingsResponse>> getCharactersCharacterIdStandingsWithHttpInfo(
            Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdStandingsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterStandingsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get standings (asynchronously) Return character standings from agents,
     * NPC corporations, and factions --- This route is cached for up to 3600
     * seconds SSO Scope: esi-characters.read_standings.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdStandingsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterStandingsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdStandingsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterStandingsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdStats
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdStatsCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/stats/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdStatsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdStats(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdStatsCall(characterId, datasource, ifNoneMatch, token,
                callback);
        return call;

    }

    /**
     * Yearly aggregate stats Returns aggregate yearly stats for a character ---
     * This route is cached for up to 86400 seconds SSO Scope:
     * esi-characterstats.read.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterStatsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterStatsResponse> getCharactersCharacterIdStats(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterStatsResponse>> resp = getCharactersCharacterIdStatsWithHttpInfo(characterId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Yearly aggregate stats Returns aggregate yearly stats for a character ---
     * This route is cached for up to 86400 seconds SSO Scope:
     * esi-characterstats.read.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterStatsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterStatsResponse>> getCharactersCharacterIdStatsWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdStatsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterStatsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Yearly aggregate stats (asynchronously) Returns aggregate yearly stats
     * for a character --- This route is cached for up to 86400 seconds SSO
     * Scope: esi-characterstats.read.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdStatsAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterStatsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdStatsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterStatsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCharactersCharacterIdTitles
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdTitlesCall(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/titles/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdTitlesValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdTitles(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdTitlesCall(characterId, datasource, ifNoneMatch, token,
                callback);
        return call;

    }

    /**
     * Get character corporation titles Returns a character&#39;s titles ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_titles.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterTitlesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterTitlesResponse> getCharactersCharacterIdTitles(Integer characterId, String datasource,
            String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterTitlesResponse>> resp = getCharactersCharacterIdTitlesWithHttpInfo(characterId,
                datasource, ifNoneMatch, token);
        return resp.getData();
    }

    /**
     * Get character corporation titles Returns a character&#39;s titles ---
     * This route is cached for up to 3600 seconds SSO Scope:
     * esi-characters.read_titles.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterTitlesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterTitlesResponse>> getCharactersCharacterIdTitlesWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdTitlesValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterTitlesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character corporation titles (asynchronously) Returns a
     * character&#39;s titles --- This route is cached for up to 3600 seconds
     * SSO Scope: esi-characters.read_titles.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdTitlesAsync(Integer characterId, String datasource,
            String ifNoneMatch, String token, final ApiCallback<List<CharacterTitlesResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdTitlesValidateBeforeCall(characterId, datasource,
                ifNoneMatch, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterTitlesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersAffiliation
     * 
     * @param requestBody
     *            The character IDs to fetch affiliations for. All characters
     *            must exist, or none will be returned (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersAffiliationCall(List<Integer> requestBody, String datasource,
            final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v1/characters/affiliation/";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersAffiliationValidateBeforeCall(List<Integer> requestBody,
            String datasource, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCharactersAffiliation(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersAffiliationCall(requestBody, datasource, callback);
        return call;

    }

    /**
     * Character affiliation Bulk lookup of character IDs to corporation,
     * alliance and faction --- This route is cached for up to 3600 seconds
     * 
     * @param requestBody
     *            The character IDs to fetch affiliations for. All characters
     *            must exist, or none will be returned (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @return List&lt;CharacterAffiliationResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterAffiliationResponse> postCharactersAffiliation(List<Integer> requestBody, String datasource)
            throws ApiException {
        ApiResponse<List<CharacterAffiliationResponse>> resp = postCharactersAffiliationWithHttpInfo(requestBody,
                datasource);
        return resp.getData();
    }

    /**
     * Character affiliation Bulk lookup of character IDs to corporation,
     * alliance and faction --- This route is cached for up to 3600 seconds
     * 
     * @param requestBody
     *            The character IDs to fetch affiliations for. All characters
     *            must exist, or none will be returned (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @return ApiResponse&lt;List&lt;CharacterAffiliationResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterAffiliationResponse>> postCharactersAffiliationWithHttpInfo(
            List<Integer> requestBody, String datasource) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersAffiliationValidateBeforeCall(requestBody, datasource, null);
        Type localVarReturnType = new TypeToken<List<CharacterAffiliationResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Character affiliation (asynchronously) Bulk lookup of character IDs to
     * corporation, alliance and faction --- This route is cached for up to 3600
     * seconds
     * 
     * @param requestBody
     *            The character IDs to fetch affiliations for. All characters
     *            must exist, or none will be returned (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersAffiliationAsync(List<Integer> requestBody, String datasource,
            final ApiCallback<List<CharacterAffiliationResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersAffiliationValidateBeforeCall(requestBody, datasource, callback);
        Type localVarReturnType = new TypeToken<List<CharacterAffiliationResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersCharacterIdCspa
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            The target characters to calculate the charge for (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdCspaCall(Integer characterId, List<Integer> requestBody,
            String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v4/characters/{character_id}/cspa/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersCharacterIdCspaValidateBeforeCall(Integer characterId,
            List<Integer> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling postCharactersCharacterIdCspa(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCharactersCharacterIdCspa(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersCharacterIdCspaCall(characterId, requestBody, datasource, token,
                callback);
        return call;

    }

    /**
     * Calculate a CSPA charge cost Takes a source character ID in the url and a
     * set of target character ID&#39;s in the body, returns a CSPA charge cost
     * --- SSO Scope: esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            The target characters to calculate the charge for (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return Float
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public Float postCharactersCharacterIdCspa(Integer characterId, List<Integer> requestBody, String datasource,
            String token) throws ApiException {
        ApiResponse<Float> resp = postCharactersCharacterIdCspaWithHttpInfo(characterId, requestBody, datasource, token);
        return resp.getData();
    }

    /**
     * Calculate a CSPA charge cost Takes a source character ID in the url and a
     * set of target character ID&#39;s in the body, returns a CSPA charge cost
     * --- SSO Scope: esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            The target characters to calculate the charge for (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;Float&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<Float> postCharactersCharacterIdCspaWithHttpInfo(Integer characterId, List<Integer> requestBody,
            String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersCharacterIdCspaValidateBeforeCall(characterId, requestBody,
                datasource, token, null);
        Type localVarReturnType = new TypeToken<Float>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Calculate a CSPA charge cost (asynchronously) Takes a source character ID
     * in the url and a set of target character ID&#39;s in the body, returns a
     * CSPA charge cost --- SSO Scope: esi-characters.read_contacts.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            The target characters to calculate the charge for (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdCspaAsync(Integer characterId, List<Integer> requestBody,
            String datasource, String token, final ApiCallback<Float> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersCharacterIdCspaValidateBeforeCall(characterId, requestBody,
                datasource, token, callback);
        Type localVarReturnType = new TypeToken<Float>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
