/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.api;

import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.ProgressRequestBody;
import net.troja.eve.esi.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import net.troja.eve.esi.model.CharacterAssetsLocationsResponse;
import net.troja.eve.esi.model.CharacterAssetsNamesResponse;
import net.troja.eve.esi.model.CharacterAssetsResponse;
import net.troja.eve.esi.model.CorporationAssetsLocationsResponse;
import net.troja.eve.esi.model.CorporationAssetsNamesResponse;
import net.troja.eve.esi.model.CorporationAssetsResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetsApi {
    private ApiClient apiClient;

    public AssetsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AssetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getCharactersCharacterIdAssets
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdAssetsCall(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/characters/{character_id}/assets/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCharactersCharacterIdAssetsValidateBeforeCall(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling getCharactersCharacterIdAssets(Async)");
        }

        com.squareup.okhttp.Call call = getCharactersCharacterIdAssetsCall(characterId, datasource, ifNoneMatch, page,
                token, callback);
        return call;

    }

    /**
     * Get character assets Return a list of the characters assets --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterAssetsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterAssetsResponse> getCharactersCharacterIdAssets(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterAssetsResponse>> resp = getCharactersCharacterIdAssetsWithHttpInfo(characterId,
                datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get character assets Return a list of the characters assets --- This
     * route is cached for up to 3600 seconds SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterAssetsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterAssetsResponse>> getCharactersCharacterIdAssetsWithHttpInfo(Integer characterId,
            String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        com.squareup.okhttp.Call call = getCharactersCharacterIdAssetsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterAssetsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character assets (asynchronously) Return a list of the characters
     * assets --- This route is cached for up to 3600 seconds SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCharactersCharacterIdAssetsAsync(Integer characterId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<CharacterAssetsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCharactersCharacterIdAssetsValidateBeforeCall(characterId, datasource,
                ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterAssetsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for getCorporationsCorporationIdAssets
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdAssetsCall(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = new Object();

        // create path and map variables
        String localVarPath = "/v3/corporations/{corporation_id}/assets/".replaceAll("\\{" + "corporation_id" + "\\}",
                apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (page != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
        }

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCorporationsCorporationIdAssetsValidateBeforeCall(Integer corporationId,
            String datasource, String ifNoneMatch, Integer page, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling getCorporationsCorporationIdAssets(Async)");
        }

        com.squareup.okhttp.Call call = getCorporationsCorporationIdAssetsCall(corporationId, datasource, ifNoneMatch,
                page, token, callback);
        return call;

    }

    /**
     * Get corporation assets Return a list of the corporation assets --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationAssetsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationAssetsResponse> getCorporationsCorporationIdAssets(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CorporationAssetsResponse>> resp = getCorporationsCorporationIdAssetsWithHttpInfo(
                corporationId, datasource, ifNoneMatch, page, token);
        return resp.getData();
    }

    /**
     * Get corporation assets Return a list of the corporation assets --- This
     * route is cached for up to 3600 seconds --- Requires one of the following
     * EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationAssetsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationAssetsResponse>> getCorporationsCorporationIdAssetsWithHttpInfo(
            Integer corporationId, String datasource, String ifNoneMatch, Integer page, String token)
            throws ApiException {
        com.squareup.okhttp.Call call = getCorporationsCorporationIdAssetsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationAssetsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation assets (asynchronously) Return a list of the corporation
     * assets --- This route is cached for up to 3600 seconds --- Requires one
     * of the following EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param ifNoneMatch
     *            ETag from a previous request. A 304 will be returned if this
     *            matches the current ETag (optional)
     * @param page
     *            Which page of results to return (optional, default to 1)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call getCorporationsCorporationIdAssetsAsync(Integer corporationId, String datasource,
            String ifNoneMatch, Integer page, String token, final ApiCallback<List<CorporationAssetsResponse>> callback)
            throws ApiException {

        com.squareup.okhttp.Call call = getCorporationsCorporationIdAssetsValidateBeforeCall(corporationId, datasource,
                ifNoneMatch, page, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationAssetsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersCharacterIdAssetsLocations
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdAssetsLocationsCall(Integer characterId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v2/characters/{character_id}/assets/locations/".replaceAll("\\{" + "character_id"
                + "\\}", apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersCharacterIdAssetsLocationsValidateBeforeCall(Integer characterId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling postCharactersCharacterIdAssetsLocations(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCharactersCharacterIdAssetsLocations(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersCharacterIdAssetsLocationsCall(characterId, requestBody,
                datasource, token, callback);
        return call;

    }

    /**
     * Get character asset locations Return locations for a set of item ids,
     * which you can get from character assets endpoint. Coordinates for items
     * in hangars or stations are set to (0,0,0) --- SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterAssetsLocationsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterAssetsLocationsResponse> postCharactersCharacterIdAssetsLocations(Integer characterId,
            List<Long> requestBody, String datasource, String token) throws ApiException {
        ApiResponse<List<CharacterAssetsLocationsResponse>> resp = postCharactersCharacterIdAssetsLocationsWithHttpInfo(
                characterId, requestBody, datasource, token);
        return resp.getData();
    }

    /**
     * Get character asset locations Return locations for a set of item ids,
     * which you can get from character assets endpoint. Coordinates for items
     * in hangars or stations are set to (0,0,0) --- SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterAssetsLocationsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterAssetsLocationsResponse>> postCharactersCharacterIdAssetsLocationsWithHttpInfo(
            Integer characterId, List<Long> requestBody, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersCharacterIdAssetsLocationsValidateBeforeCall(characterId,
                requestBody, datasource, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterAssetsLocationsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character asset locations (asynchronously) Return locations for a set
     * of item ids, which you can get from character assets endpoint.
     * Coordinates for items in hangars or stations are set to (0,0,0) --- SSO
     * Scope: esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdAssetsLocationsAsync(Integer characterId,
            List<Long> requestBody, String datasource, String token,
            final ApiCallback<List<CharacterAssetsLocationsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersCharacterIdAssetsLocationsValidateBeforeCall(characterId,
                requestBody, datasource, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterAssetsLocationsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCharactersCharacterIdAssetsNames
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdAssetsNamesCall(Integer characterId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v1/characters/{character_id}/assets/names/".replaceAll("\\{" + "character_id" + "\\}",
                apiClient.escapeString(characterId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCharactersCharacterIdAssetsNamesValidateBeforeCall(Integer characterId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'characterId' is set
        if (characterId == null) {
            throw new ApiException(
                    "Missing the required parameter 'characterId' when calling postCharactersCharacterIdAssetsNames(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCharactersCharacterIdAssetsNames(Async)");
        }

        com.squareup.okhttp.Call call = postCharactersCharacterIdAssetsNamesCall(characterId, requestBody, datasource,
                token, callback);
        return call;

    }

    /**
     * Get character asset names Return names for a set of item ids, which you
     * can get from character assets endpoint. Typically used for items that can
     * customize names, like containers or ships. --- SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CharacterAssetsNamesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CharacterAssetsNamesResponse> postCharactersCharacterIdAssetsNames(Integer characterId,
            List<Long> requestBody, String datasource, String token) throws ApiException {
        ApiResponse<List<CharacterAssetsNamesResponse>> resp = postCharactersCharacterIdAssetsNamesWithHttpInfo(
                characterId, requestBody, datasource, token);
        return resp.getData();
    }

    /**
     * Get character asset names Return names for a set of item ids, which you
     * can get from character assets endpoint. Typically used for items that can
     * customize names, like containers or ships. --- SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CharacterAssetsNamesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CharacterAssetsNamesResponse>> postCharactersCharacterIdAssetsNamesWithHttpInfo(
            Integer characterId, List<Long> requestBody, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = postCharactersCharacterIdAssetsNamesValidateBeforeCall(characterId,
                requestBody, datasource, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterAssetsNamesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get character asset names (asynchronously) Return names for a set of item
     * ids, which you can get from character assets endpoint. Typically used for
     * items that can customize names, like containers or ships. --- SSO Scope:
     * esi-assets.read_assets.v1
     * 
     * @param characterId
     *            An EVE character ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCharactersCharacterIdAssetsNamesAsync(Integer characterId,
            List<Long> requestBody, String datasource, String token,
            final ApiCallback<List<CharacterAssetsNamesResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCharactersCharacterIdAssetsNamesValidateBeforeCall(characterId,
                requestBody, datasource, token, callback);
        Type localVarReturnType = new TypeToken<List<CharacterAssetsNamesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCorporationsCorporationIdAssetsLocations
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCorporationsCorporationIdAssetsLocationsCall(Integer corporationId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v2/corporations/{corporation_id}/assets/locations/".replaceAll("\\{" + "corporation_id"
                + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCorporationsCorporationIdAssetsLocationsValidateBeforeCall(
            Integer corporationId, List<Long> requestBody, String datasource, String token, final ApiCallback callback)
            throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling postCorporationsCorporationIdAssetsLocations(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCorporationsCorporationIdAssetsLocations(Async)");
        }

        com.squareup.okhttp.Call call = postCorporationsCorporationIdAssetsLocationsCall(corporationId, requestBody,
                datasource, token, callback);
        return call;

    }

    /**
     * Get corporation asset locations Return locations for a set of item ids,
     * which you can get from corporation assets endpoint. Coordinates for items
     * in hangars or stations are set to (0,0,0) --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationAssetsLocationsResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationAssetsLocationsResponse> postCorporationsCorporationIdAssetsLocations(Integer corporationId,
            List<Long> requestBody, String datasource, String token) throws ApiException {
        ApiResponse<List<CorporationAssetsLocationsResponse>> resp = postCorporationsCorporationIdAssetsLocationsWithHttpInfo(
                corporationId, requestBody, datasource, token);
        return resp.getData();
    }

    /**
     * Get corporation asset locations Return locations for a set of item ids,
     * which you can get from corporation assets endpoint. Coordinates for items
     * in hangars or stations are set to (0,0,0) --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationAssetsLocationsResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationAssetsLocationsResponse>> postCorporationsCorporationIdAssetsLocationsWithHttpInfo(
            Integer corporationId, List<Long> requestBody, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = postCorporationsCorporationIdAssetsLocationsValidateBeforeCall(corporationId,
                requestBody, datasource, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationAssetsLocationsResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation asset locations (asynchronously) Return locations for a
     * set of item ids, which you can get from corporation assets endpoint.
     * Coordinates for items in hangars or stations are set to (0,0,0) ---
     * Requires one of the following EVE corporation role(s): Director SSO
     * Scope: esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCorporationsCorporationIdAssetsLocationsAsync(Integer corporationId,
            List<Long> requestBody, String datasource, String token,
            final ApiCallback<List<CorporationAssetsLocationsResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCorporationsCorporationIdAssetsLocationsValidateBeforeCall(corporationId,
                requestBody, datasource, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationAssetsLocationsResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    /**
     * Build call for postCorporationsCorporationIdAssetsNames
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException
     *             If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postCorporationsCorporationIdAssetsNamesCall(Integer corporationId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {
        Object localVarPostBody = requestBody;

        // create path and map variables
        String localVarPath = "/v1/corporations/{corporation_id}/assets/names/".replaceAll("\\{" + "corporation_id"
                + "\\}", apiClient.escapeString(corporationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("datasource", datasource));
        }

        if (token != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("token", token));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "evesso" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, callback);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postCorporationsCorporationIdAssetsNamesValidateBeforeCall(Integer corporationId,
            List<Long> requestBody, String datasource, String token, final ApiCallback callback) throws ApiException {

        // verify the required parameter 'corporationId' is set
        if (corporationId == null) {
            throw new ApiException(
                    "Missing the required parameter 'corporationId' when calling postCorporationsCorporationIdAssetsNames(Async)");
        }

        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new ApiException(
                    "Missing the required parameter 'requestBody' when calling postCorporationsCorporationIdAssetsNames(Async)");
        }

        com.squareup.okhttp.Call call = postCorporationsCorporationIdAssetsNamesCall(corporationId, requestBody,
                datasource, token, callback);
        return call;

    }

    /**
     * Get corporation asset names Return names for a set of item ids, which you
     * can get from corporation assets endpoint. Only valid for items that can
     * customize names, like containers or ships --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return List&lt;CorporationAssetsNamesResponse&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public List<CorporationAssetsNamesResponse> postCorporationsCorporationIdAssetsNames(Integer corporationId,
            List<Long> requestBody, String datasource, String token) throws ApiException {
        ApiResponse<List<CorporationAssetsNamesResponse>> resp = postCorporationsCorporationIdAssetsNamesWithHttpInfo(
                corporationId, requestBody, datasource, token);
        return resp.getData();
    }

    /**
     * Get corporation asset names Return names for a set of item ids, which you
     * can get from corporation assets endpoint. Only valid for items that can
     * customize names, like containers or ships --- Requires one of the
     * following EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @return ApiResponse&lt;List&lt;CorporationAssetsNamesResponse&gt;&gt;
     * @throws ApiException
     *             If fail to call the API, e.g. server error or cannot
     *             deserialize the response body
     */
    public ApiResponse<List<CorporationAssetsNamesResponse>> postCorporationsCorporationIdAssetsNamesWithHttpInfo(
            Integer corporationId, List<Long> requestBody, String datasource, String token) throws ApiException {
        com.squareup.okhttp.Call call = postCorporationsCorporationIdAssetsNamesValidateBeforeCall(corporationId,
                requestBody, datasource, token, null);
        Type localVarReturnType = new TypeToken<List<CorporationAssetsNamesResponse>>() {
        }.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get corporation asset names (asynchronously) Return names for a set of
     * item ids, which you can get from corporation assets endpoint. Only valid
     * for items that can customize names, like containers or ships --- Requires
     * one of the following EVE corporation role(s): Director SSO Scope:
     * esi-assets.read_corporation_assets.v1
     * 
     * @param corporationId
     *            An EVE corporation ID (required)
     * @param requestBody
     *            A list of item ids (required)
     * @param datasource
     *            The server name you would like data from (optional, default to
     *            tranquility)
     * @param token
     *            Access token to use if unable to set a header (optional)
     * @param callback
     *            The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException
     *             If fail to process the API call, e.g. serializing the request
     *             body object
     */
    public com.squareup.okhttp.Call postCorporationsCorporationIdAssetsNamesAsync(Integer corporationId,
            List<Long> requestBody, String datasource, String token,
            final ApiCallback<List<CorporationAssetsNamesResponse>> callback) throws ApiException {

        com.squareup.okhttp.Call call = postCorporationsCorporationIdAssetsNamesValidateBeforeCall(corporationId,
                requestBody, datasource, token, callback);
        Type localVarReturnType = new TypeToken<List<CorporationAssetsNamesResponse>>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
