/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JWT {
    private final Header header;
    private final Payload payload;
    private final String signature;

    public JWT(Header header, Payload payload, String string) {
        this.header = header;
        this.payload = payload;
        this.signature = string;
    }

    public Header getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public static class ArrayStringDeserializer
    extends JsonDeserializer<Set<String>> {
        private static final TypeReference<Set<String>> LIST_TYPE = new TypeReference<Set<String>>(){};

        public Set<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            try {
                return (Set)jsonParser.readValueAs(LIST_TYPE);
            }
            catch (IOException iOException) {
                return new HashSet<String>(Collections.singleton(jsonParser.getText()));
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Payload {
        @JsonProperty(value="scp")
        @JsonDeserialize(using=ArrayStringDeserializer.class)
        private Set<String> scopes;
        private String jti;
        private String kid;
        private String sub;
        private String azp;
        private String name;
        private String owner;
        private String exp;
        private String iss;
        private Integer characterID;

        public Set<String> getScopes() {
            return this.scopes;
        }

        public void setScopes(Set<String> set) {
            this.scopes = set;
        }

        public String getJti() {
            return this.jti;
        }

        public void setJti(String string) {
            this.jti = string;
        }

        public String getKid() {
            return this.kid;
        }

        public void setKid(String string) {
            this.kid = string;
        }

        public String getSub() {
            return this.sub;
        }

        public void setSub(String string) {
            this.sub = string;
            try {
                this.characterID = Integer.valueOf(string.substring("CHARACTER:EVE:".length()));
            }
            catch (NumberFormatException numberFormatException) {
                this.characterID = null;
            }
        }

        public Integer getCharacterID() {
            return this.characterID;
        }

        public String getAzp() {
            return this.azp;
        }

        public void setAzp(String string) {
            this.azp = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String string) {
            this.owner = string;
        }

        public String getExp() {
            return this.exp;
        }

        public void setExp(String string) {
            this.exp = string;
        }

        public String getIss() {
            return this.iss;
        }

        public void setIss(String string) {
            this.iss = string;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Header {
        private String alg;
        private String typ;

        public String getAlg() {
            return this.alg;
        }

        public void setAlg(String string) {
            this.alg = string;
        }

        public String getTyp() {
            return this.typ;
        }

        public void setTyp(String string) {
            this.typ = string;
        }
    }
}

