/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CorporationStarbasesResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="moon_id")
    private Integer moonId = null;
    @JsonProperty(value="onlined_since")
    private OffsetDateTime onlinedSince = null;
    @JsonProperty(value="reinforced_until")
    private OffsetDateTime reinforcedUntil = null;
    @JsonProperty(value="starbase_id")
    private Long starbaseId = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="system_id")
    private Integer systemId = null;
    @JsonProperty(value="type_id")
    private Integer typeId = null;
    @JsonProperty(value="unanchor_at")
    private OffsetDateTime unanchorAt = null;

    public CorporationStarbasesResponse moonId(Integer n) {
        this.moonId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="The moon this starbase (POS) is anchored on, unanchored POSes do not have this information")
    public Integer getMoonId() {
        return this.moonId;
    }

    public void setMoonId(Integer n) {
        this.moonId = n;
    }

    public CorporationStarbasesResponse onlinedSince(OffsetDateTime offsetDateTime) {
        this.onlinedSince = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="When the POS onlined, for starbases (POSes) in online state")
    public OffsetDateTime getOnlinedSince() {
        return this.onlinedSince;
    }

    public void setOnlinedSince(OffsetDateTime offsetDateTime) {
        this.onlinedSince = offsetDateTime;
    }

    public CorporationStarbasesResponse reinforcedUntil(OffsetDateTime offsetDateTime) {
        this.reinforcedUntil = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="When the POS will be out of reinforcement, for starbases (POSes) in reinforced state")
    public OffsetDateTime getReinforcedUntil() {
        return this.reinforcedUntil;
    }

    public void setReinforcedUntil(OffsetDateTime offsetDateTime) {
        this.reinforcedUntil = offsetDateTime;
    }

    public CorporationStarbasesResponse starbaseId(Long l) {
        this.starbaseId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique ID for this starbase (POS)")
    public Long getStarbaseId() {
        return this.starbaseId;
    }

    public void setStarbaseId(Long l) {
        this.starbaseId = l;
    }

    public CorporationStarbasesResponse state(StateEnum stateEnum) {
        this.state = stateEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="state string")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.state = stateEnum;
    }

    public CorporationStarbasesResponse systemId(Integer n) {
        this.systemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The solar system this starbase (POS) is in, unanchored POSes have this information")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer n) {
        this.systemId = n;
    }

    public CorporationStarbasesResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Starbase (POS) type")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CorporationStarbasesResponse unanchorAt(OffsetDateTime offsetDateTime) {
        this.unanchorAt = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="When the POS started unanchoring, for starbases (POSes) in unanchoring state")
    public OffsetDateTime getUnanchorAt() {
        return this.unanchorAt;
    }

    public void setUnanchorAt(OffsetDateTime offsetDateTime) {
        this.unanchorAt = offsetDateTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationStarbasesResponse corporationStarbasesResponse = (CorporationStarbasesResponse)object;
        return Objects.equals(this.moonId, corporationStarbasesResponse.moonId) && Objects.equals(this.onlinedSince, corporationStarbasesResponse.onlinedSince) && Objects.equals(this.reinforcedUntil, corporationStarbasesResponse.reinforcedUntil) && Objects.equals(this.starbaseId, corporationStarbasesResponse.starbaseId) && Objects.equals((Object)this.state, (Object)corporationStarbasesResponse.state) && Objects.equals(this.systemId, corporationStarbasesResponse.systemId) && Objects.equals(this.typeId, corporationStarbasesResponse.typeId) && Objects.equals(this.unanchorAt, corporationStarbasesResponse.unanchorAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.moonId, this.onlinedSince, this.reinforcedUntil, this.starbaseId, this.state, this.systemId, this.typeId, this.unanchorAt});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationStarbasesResponse {\n");
        stringBuilder.append("    moonId: ").append(this.toIndentedString(this.moonId)).append("\n");
        stringBuilder.append("    onlinedSince: ").append(this.toIndentedString(this.onlinedSince)).append("\n");
        stringBuilder.append("    reinforcedUntil: ").append(this.toIndentedString(this.reinforcedUntil)).append("\n");
        stringBuilder.append("    starbaseId: ").append(this.toIndentedString(this.starbaseId)).append("\n");
        stringBuilder.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        stringBuilder.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    unanchorAt: ").append(this.toIndentedString(this.unanchorAt)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OFFLINE("offline"),
        ONLINE("online"),
        ONLINING("onlining"),
        REINFORCED("reinforced"),
        UNANCHORING("unanchoring");

        private String value;

        private StateEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String string) {
            for (StateEnum stateEnum : StateEnum.values()) {
                if (!String.valueOf(stateEnum.value).equals(string)) continue;
                return stateEnum;
            }
            return null;
        }
    }
}

