/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import net.troja.eve.esi.model.CorporationFwStatsKills;
import net.troja.eve.esi.model.CorporationFwStatsVictoryPoints;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationFwStatsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("enlisted_on")
    private OffsetDateTime enlistedOn = null;

    @JsonProperty("faction_id")
    private Integer factionId = null;

    @JsonProperty("kills")
    private CorporationFwStatsKills kills = null;

    @JsonProperty("pilots")
    private Integer pilots = null;

    @JsonProperty("victory_points")
    private CorporationFwStatsVictoryPoints victoryPoints = null;

    public CorporationFwStatsResponse enlistedOn(OffsetDateTime enlistedOn) {
        this.enlistedOn = enlistedOn;
        return this;
    }

    /**
     * The enlistment date of the given corporation into faction warfare. Will
     * not be included if corporation is not enlisted in faction warfare
     * 
     * @return enlistedOn
     **/
    @ApiModelProperty(example = "null", value = "The enlistment date of the given corporation into faction warfare. Will not be included if corporation is not enlisted in faction warfare")
    public OffsetDateTime getEnlistedOn() {
        return enlistedOn;
    }

    public void setEnlistedOn(OffsetDateTime enlistedOn) {
        this.enlistedOn = enlistedOn;
    }

    public CorporationFwStatsResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    /**
     * The faction the given corporation is enlisted to fight for. Will not be
     * included if corporation is not enlisted in faction warfare
     * 
     * @return factionId
     **/
    @ApiModelProperty(example = "null", value = "The faction the given corporation is enlisted to fight for. Will not be included if corporation is not enlisted in faction warfare")
    public Integer getFactionId() {
        return factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public CorporationFwStatsResponse kills(CorporationFwStatsKills kills) {
        this.kills = kills;
        return this;
    }

    /**
     * Get kills
     * 
     * @return kills
     **/
    @ApiModelProperty(example = "null", value = "")
    public CorporationFwStatsKills getKills() {
        return kills;
    }

    public void setKills(CorporationFwStatsKills kills) {
        this.kills = kills;
    }

    public CorporationFwStatsResponse pilots(Integer pilots) {
        this.pilots = pilots;
        return this;
    }

    /**
     * How many pilots the enlisted corporation has. Will not be included if
     * corporation is not enlisted in faction warfare
     * 
     * @return pilots
     **/
    @ApiModelProperty(example = "null", value = "How many pilots the enlisted corporation has. Will not be included if corporation is not enlisted in faction warfare")
    public Integer getPilots() {
        return pilots;
    }

    public void setPilots(Integer pilots) {
        this.pilots = pilots;
    }

    public CorporationFwStatsResponse victoryPoints(CorporationFwStatsVictoryPoints victoryPoints) {
        this.victoryPoints = victoryPoints;
        return this;
    }

    /**
     * Get victoryPoints
     * 
     * @return victoryPoints
     **/
    @ApiModelProperty(example = "null", value = "")
    public CorporationFwStatsVictoryPoints getVictoryPoints() {
        return victoryPoints;
    }

    public void setVictoryPoints(CorporationFwStatsVictoryPoints victoryPoints) {
        this.victoryPoints = victoryPoints;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationFwStatsResponse corporationFwStatsResponse = (CorporationFwStatsResponse) o;
        return Objects.equals(this.enlistedOn, corporationFwStatsResponse.enlistedOn)
                && Objects.equals(this.factionId, corporationFwStatsResponse.factionId)
                && Objects.equals(this.kills, corporationFwStatsResponse.kills)
                && Objects.equals(this.pilots, corporationFwStatsResponse.pilots)
                && Objects.equals(this.victoryPoints, corporationFwStatsResponse.victoryPoints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(enlistedOn, factionId, kills, pilots, victoryPoints);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationFwStatsResponse {\n");

        sb.append("    enlistedOn: ").append(toIndentedString(enlistedOn)).append("\n");
        sb.append("    factionId: ").append(toIndentedString(factionId)).append("\n");
        sb.append("    kills: ").append(toIndentedString(kills)).append("\n");
        sb.append("    pilots: ").append(toIndentedString(pilots)).append("\n");
        sb.append("    victoryPoints: ").append(toIndentedString(victoryPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
