/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.Recipient;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class MailResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("body")
    private String body = null;

    @JsonProperty("from")
    private Integer from = null;

    @JsonProperty("labels")
    private List<Integer> labels = new ArrayList<Integer>();

    @JsonProperty("read")
    private Boolean read = null;

    @JsonProperty("recipients")
    private List<Recipient> recipients = new ArrayList<Recipient>();

    @JsonProperty("subject")
    private String subject = null;

    @JsonProperty("timestamp")
    private OffsetDateTime timestamp = null;

    public MailResponse body(String body) {
        this.body = body;
        return this;
    }

    /**
     * Mail's body
     * 
     * @return body
     **/
    @ApiModelProperty(example = "null", value = "Mail's body")
    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public MailResponse from(Integer from) {
        this.from = from;
        return this;
    }

    /**
     * From whom the mail was sent
     * 
     * @return from
     **/
    @ApiModelProperty(example = "null", value = "From whom the mail was sent")
    public Integer getFrom() {
        return from;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public MailResponse labels(List<Integer> labels) {
        this.labels = labels;
        return this;
    }

    public MailResponse addLabelsItem(Integer labelsItem) {
        this.labels.add(labelsItem);
        return this;
    }

    /**
     * Labels attached to the mail
     * 
     * @return labels
     **/
    @ApiModelProperty(example = "null", value = "Labels attached to the mail")
    public List<Integer> getLabels() {
        return labels;
    }

    public void setLabels(List<Integer> labels) {
        this.labels = labels;
    }

    public MailResponse read(Boolean read) {
        this.read = read;
        return this;
    }

    /**
     * Whether the mail is flagged as read
     * 
     * @return read
     **/
    @ApiModelProperty(example = "null", value = "Whether the mail is flagged as read")
    public Boolean getRead() {
        return read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public MailResponse recipients(List<Recipient> recipients) {
        this.recipients = recipients;
        return this;
    }

    public MailResponse addRecipientsItem(Recipient recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    /**
     * Recipients of the mail
     * 
     * @return recipients
     **/
    @ApiModelProperty(example = "null", value = "Recipients of the mail")
    public List<Recipient> getRecipients() {
        return recipients;
    }

    public void setRecipients(List<Recipient> recipients) {
        this.recipients = recipients;
    }

    public MailResponse subject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Mail subject
     * 
     * @return subject
     **/
    @ApiModelProperty(example = "null", value = "Mail subject")
    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MailResponse timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * When the mail was sent
     * 
     * @return timestamp
     **/
    @ApiModelProperty(example = "null", value = "When the mail was sent")
    public OffsetDateTime getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MailResponse mailResponse = (MailResponse) o;
        return Objects.equals(this.body, mailResponse.body) && Objects.equals(this.from, mailResponse.from)
                && Objects.equals(this.labels, mailResponse.labels) && Objects.equals(this.read, mailResponse.read)
                && Objects.equals(this.recipients, mailResponse.recipients)
                && Objects.equals(this.subject, mailResponse.subject)
                && Objects.equals(this.timestamp, mailResponse.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(body, from, labels, read, recipients, subject, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MailResponse {\n");

        sb.append("    body: ").append(toIndentedString(body)).append("\n");
        sb.append("    from: ").append(toIndentedString(from)).append("\n");
        sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
        sb.append("    read: ").append(toIndentedString(read)).append("\n");
        sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
