/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class FleetMembersResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("character_id")
    private Integer characterId = null;

    @JsonProperty("join_time")
    private OffsetDateTime joinTime = null;

    /**
     * Member’s role in fleet
     */
    public enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),

        WING_COMMANDER("wing_commander"),

        SQUAD_COMMANDER("squad_commander"),

        SQUAD_MEMBER("squad_member");

        private String value;

        RoleEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String text) {
            for (RoleEnum b : RoleEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("role")
    private RoleEnum role = null;

    @JsonProperty("role_name")
    private String roleName = null;

    @JsonProperty("ship_type_id")
    private Integer shipTypeId = null;

    @JsonProperty("solar_system_id")
    private Integer solarSystemId = null;

    @JsonProperty("squad_id")
    private Long squadId = null;

    @JsonProperty("station_id")
    private Long stationId = null;

    @JsonProperty("takes_fleet_warp")
    private Boolean takesFleetWarp = null;

    @JsonProperty("wing_id")
    private Long wingId = null;

    public FleetMembersResponse characterId(Integer characterId) {
        this.characterId = characterId;
        return this;
    }

    /**
     * character_id integer
     * 
     * @return characterId
     **/
    @ApiModelProperty(example = "null", required = true, value = "character_id integer")
    public Integer getCharacterId() {
        return characterId;
    }

    public void setCharacterId(Integer characterId) {
        this.characterId = characterId;
    }

    public FleetMembersResponse joinTime(OffsetDateTime joinTime) {
        this.joinTime = joinTime;
        return this;
    }

    /**
     * join_time string
     * 
     * @return joinTime
     **/
    @ApiModelProperty(example = "null", required = true, value = "join_time string")
    public OffsetDateTime getJoinTime() {
        return joinTime;
    }

    public void setJoinTime(OffsetDateTime joinTime) {
        this.joinTime = joinTime;
    }

    public FleetMembersResponse role(RoleEnum role) {
        this.role = role;
        return this;
    }

    /**
     * Member’s role in fleet
     * 
     * @return role
     **/
    @ApiModelProperty(example = "null", required = true, value = "Member’s role in fleet")
    public RoleEnum getRole() {
        return role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public FleetMembersResponse roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    /**
     * Localized role names
     * 
     * @return roleName
     **/
    @ApiModelProperty(example = "null", required = true, value = "Localized role names")
    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public FleetMembersResponse shipTypeId(Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
        return this;
    }

    /**
     * ship_type_id integer
     * 
     * @return shipTypeId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ship_type_id integer")
    public Integer getShipTypeId() {
        return shipTypeId;
    }

    public void setShipTypeId(Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
    }

    public FleetMembersResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    /**
     * Solar system the member is located in
     * 
     * @return solarSystemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Solar system the member is located in")
    public Integer getSolarSystemId() {
        return solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public FleetMembersResponse squadId(Long squadId) {
        this.squadId = squadId;
        return this;
    }

    /**
     * ID of the squad the member is in. If not applicable, will be set to -1
     * 
     * @return squadId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the squad the member is in. If not applicable, will be set to -1")
    public Long getSquadId() {
        return squadId;
    }

    public void setSquadId(Long squadId) {
        this.squadId = squadId;
    }

    public FleetMembersResponse stationId(Long stationId) {
        this.stationId = stationId;
        return this;
    }

    /**
     * Station in which the member is docked in, if applicable
     * 
     * @return stationId
     **/
    @ApiModelProperty(example = "null", value = "Station in which the member is docked in, if applicable")
    public Long getStationId() {
        return stationId;
    }

    public void setStationId(Long stationId) {
        this.stationId = stationId;
    }

    public FleetMembersResponse takesFleetWarp(Boolean takesFleetWarp) {
        this.takesFleetWarp = takesFleetWarp;
        return this;
    }

    /**
     * Whether the member take fleet warps
     * 
     * @return takesFleetWarp
     **/
    @ApiModelProperty(example = "null", required = true, value = "Whether the member take fleet warps")
    public Boolean getTakesFleetWarp() {
        return takesFleetWarp;
    }

    public void setTakesFleetWarp(Boolean takesFleetWarp) {
        this.takesFleetWarp = takesFleetWarp;
    }

    public FleetMembersResponse wingId(Long wingId) {
        this.wingId = wingId;
        return this;
    }

    /**
     * ID of the wing the member is in. If not applicable, will be set to -1
     * 
     * @return wingId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the wing the member is in. If not applicable, will be set to -1")
    public Long getWingId() {
        return wingId;
    }

    public void setWingId(Long wingId) {
        this.wingId = wingId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FleetMembersResponse fleetMembersResponse = (FleetMembersResponse) o;
        return Objects.equals(this.characterId, fleetMembersResponse.characterId)
                && Objects.equals(this.joinTime, fleetMembersResponse.joinTime)
                && Objects.equals(this.role, fleetMembersResponse.role)
                && Objects.equals(this.roleName, fleetMembersResponse.roleName)
                && Objects.equals(this.shipTypeId, fleetMembersResponse.shipTypeId)
                && Objects.equals(this.solarSystemId, fleetMembersResponse.solarSystemId)
                && Objects.equals(this.squadId, fleetMembersResponse.squadId)
                && Objects.equals(this.stationId, fleetMembersResponse.stationId)
                && Objects.equals(this.takesFleetWarp, fleetMembersResponse.takesFleetWarp)
                && Objects.equals(this.wingId, fleetMembersResponse.wingId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(characterId, joinTime, role, roleName, shipTypeId, solarSystemId, squadId, stationId,
                takesFleetWarp, wingId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetMembersResponse {\n");

        sb.append("    characterId: ").append(toIndentedString(characterId)).append("\n");
        sb.append("    joinTime: ").append(toIndentedString(joinTime)).append("\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("    roleName: ").append(toIndentedString(roleName)).append("\n");
        sb.append("    shipTypeId: ").append(toIndentedString(shipTypeId)).append("\n");
        sb.append("    solarSystemId: ").append(toIndentedString(solarSystemId)).append("\n");
        sb.append("    squadId: ").append(toIndentedString(squadId)).append("\n");
        sb.append("    stationId: ").append(toIndentedString(stationId)).append("\n");
        sb.append("    takesFleetWarp: ").append(toIndentedString(takesFleetWarp)).append("\n");
        sb.append("    wingId: ").append(toIndentedString(wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
