/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.StructureService;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationStructuresResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("corporation_id")
    private Integer corporationId = null;

    @JsonProperty("fuel_expires")
    private OffsetDateTime fuelExpires = null;

    @JsonProperty("next_reinforce_apply")
    private OffsetDateTime nextReinforceApply = null;

    @JsonProperty("next_reinforce_hour")
    private Integer nextReinforceHour = null;

    @JsonProperty("next_reinforce_weekday")
    private Integer nextReinforceWeekday = null;

    @JsonProperty("profile_id")
    private Integer profileId = null;

    @JsonProperty("reinforce_hour")
    private Integer reinforceHour = null;

    @JsonProperty("reinforce_weekday")
    private Integer reinforceWeekday = null;

    @JsonProperty("services")
    private List<StructureService> services = new ArrayList<StructureService>();

    /**
     * state string
     */
    public enum StateEnum {
        ANCHOR_VULNERABLE("anchor_vulnerable"),

        ANCHORING("anchoring"),

        ARMOR_REINFORCE("armor_reinforce"),

        ARMOR_VULNERABLE("armor_vulnerable"),

        FITTING_INVULNERABLE("fitting_invulnerable"),

        HULL_REINFORCE("hull_reinforce"),

        HULL_VULNERABLE("hull_vulnerable"),

        ONLINE_DEPRECATED("online_deprecated"),

        ONLINING_VULNERABLE("onlining_vulnerable"),

        SHIELD_VULNERABLE("shield_vulnerable"),

        UNANCHORED("unanchored"),

        UNKNOWN("unknown");

        private String value;

        StateEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("state")
    private StateEnum state = null;

    @JsonProperty("state_timer_end")
    private OffsetDateTime stateTimerEnd = null;

    @JsonProperty("state_timer_start")
    private OffsetDateTime stateTimerStart = null;

    @JsonProperty("structure_id")
    private Long structureId = null;

    @JsonProperty("system_id")
    private Integer systemId = null;

    @JsonProperty("type_id")
    private Integer typeId = null;

    @JsonProperty("unanchors_at")
    private OffsetDateTime unanchorsAt = null;

    public CorporationStructuresResponse corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    /**
     * ID of the corporation that owns the structure
     * 
     * @return corporationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the corporation that owns the structure")
    public Integer getCorporationId() {
        return corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public CorporationStructuresResponse fuelExpires(OffsetDateTime fuelExpires) {
        this.fuelExpires = fuelExpires;
        return this;
    }

    /**
     * Date on which the structure will run out of fuel
     * 
     * @return fuelExpires
     **/
    @ApiModelProperty(example = "null", value = "Date on which the structure will run out of fuel")
    public OffsetDateTime getFuelExpires() {
        return fuelExpires;
    }

    public void setFuelExpires(OffsetDateTime fuelExpires) {
        this.fuelExpires = fuelExpires;
    }

    public CorporationStructuresResponse nextReinforceApply(OffsetDateTime nextReinforceApply) {
        this.nextReinforceApply = nextReinforceApply;
        return this;
    }

    /**
     * The date and time when the structure's newly requested reinforcement
     * times (e.g. next_reinforce_hour and next_reinforce_day) will take effect
     * 
     * @return nextReinforceApply
     **/
    @ApiModelProperty(example = "null", value = "The date and time when the structure's newly requested reinforcement times (e.g. next_reinforce_hour and next_reinforce_day) will take effect")
    public OffsetDateTime getNextReinforceApply() {
        return nextReinforceApply;
    }

    public void setNextReinforceApply(OffsetDateTime nextReinforceApply) {
        this.nextReinforceApply = nextReinforceApply;
    }

    public CorporationStructuresResponse nextReinforceHour(Integer nextReinforceHour) {
        this.nextReinforceHour = nextReinforceHour;
        return this;
    }

    /**
     * The requested change to reinforce_hour that will take effect at the time
     * shown by next_reinforce_apply minimum: 0 maximum: 23
     * 
     * @return nextReinforceHour
     **/
    @ApiModelProperty(example = "null", value = "The requested change to reinforce_hour that will take effect at the time shown by next_reinforce_apply")
    public Integer getNextReinforceHour() {
        return nextReinforceHour;
    }

    public void setNextReinforceHour(Integer nextReinforceHour) {
        this.nextReinforceHour = nextReinforceHour;
    }

    public CorporationStructuresResponse nextReinforceWeekday(Integer nextReinforceWeekday) {
        this.nextReinforceWeekday = nextReinforceWeekday;
        return this;
    }

    /**
     * The requested change to reinforce_weekday that will take effect at the
     * time shown by next_reinforce_apply minimum: 0 maximum: 6
     * 
     * @return nextReinforceWeekday
     **/
    @ApiModelProperty(example = "null", value = "The requested change to reinforce_weekday that will take effect at the time shown by next_reinforce_apply")
    public Integer getNextReinforceWeekday() {
        return nextReinforceWeekday;
    }

    public void setNextReinforceWeekday(Integer nextReinforceWeekday) {
        this.nextReinforceWeekday = nextReinforceWeekday;
    }

    public CorporationStructuresResponse profileId(Integer profileId) {
        this.profileId = profileId;
        return this;
    }

    /**
     * The id of the ACL profile for this citadel
     * 
     * @return profileId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The id of the ACL profile for this citadel")
    public Integer getProfileId() {
        return profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    public CorporationStructuresResponse reinforceHour(Integer reinforceHour) {
        this.reinforceHour = reinforceHour;
        return this;
    }

    /**
     * The hour of day that determines the four hour window when the structure
     * will randomly exit its reinforcement periods and become vulnerable to
     * attack against its armor and/or hull. The structure will become
     * vulnerable at a random time that is +/- 2 hours centered on the value of
     * this property minimum: 0 maximum: 23
     * 
     * @return reinforceHour
     **/
    @ApiModelProperty(example = "null", required = true, value = "The hour of day that determines the four hour window when the structure will randomly exit its reinforcement periods and become vulnerable to attack against its armor and/or hull. The structure will become vulnerable at a random time that is +/- 2 hours centered on the value of this property")
    public Integer getReinforceHour() {
        return reinforceHour;
    }

    public void setReinforceHour(Integer reinforceHour) {
        this.reinforceHour = reinforceHour;
    }

    public CorporationStructuresResponse reinforceWeekday(Integer reinforceWeekday) {
        this.reinforceWeekday = reinforceWeekday;
        return this;
    }

    /**
     * The day of the week when the structure exits its final reinforcement
     * period and becomes vulnerable to attack against its hull. Monday is 0 and
     * Sunday is 6 minimum: 0 maximum: 6
     * 
     * @return reinforceWeekday
     **/
    @ApiModelProperty(example = "null", required = true, value = "The day of the week when the structure exits its final reinforcement period and becomes vulnerable to attack against its hull. Monday is 0 and Sunday is 6")
    public Integer getReinforceWeekday() {
        return reinforceWeekday;
    }

    public void setReinforceWeekday(Integer reinforceWeekday) {
        this.reinforceWeekday = reinforceWeekday;
    }

    public CorporationStructuresResponse services(List<StructureService> services) {
        this.services = services;
        return this;
    }

    public CorporationStructuresResponse addServicesItem(StructureService servicesItem) {
        this.services.add(servicesItem);
        return this;
    }

    /**
     * Contains a list of service upgrades, and their state
     * 
     * @return services
     **/
    @ApiModelProperty(example = "null", value = "Contains a list of service upgrades, and their state")
    public List<StructureService> getServices() {
        return services;
    }

    public void setServices(List<StructureService> services) {
        this.services = services;
    }

    public CorporationStructuresResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    /**
     * state string
     * 
     * @return state
     **/
    @ApiModelProperty(example = "null", required = true, value = "state string")
    public StateEnum getState() {
        return state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CorporationStructuresResponse stateTimerEnd(OffsetDateTime stateTimerEnd) {
        this.stateTimerEnd = stateTimerEnd;
        return this;
    }

    /**
     * Date at which the structure will move to it's next state
     * 
     * @return stateTimerEnd
     **/
    @ApiModelProperty(example = "null", value = "Date at which the structure will move to it's next state")
    public OffsetDateTime getStateTimerEnd() {
        return stateTimerEnd;
    }

    public void setStateTimerEnd(OffsetDateTime stateTimerEnd) {
        this.stateTimerEnd = stateTimerEnd;
    }

    public CorporationStructuresResponse stateTimerStart(OffsetDateTime stateTimerStart) {
        this.stateTimerStart = stateTimerStart;
        return this;
    }

    /**
     * Date at which the structure entered it's current state
     * 
     * @return stateTimerStart
     **/
    @ApiModelProperty(example = "null", value = "Date at which the structure entered it's current state")
    public OffsetDateTime getStateTimerStart() {
        return stateTimerStart;
    }

    public void setStateTimerStart(OffsetDateTime stateTimerStart) {
        this.stateTimerStart = stateTimerStart;
    }

    public CorporationStructuresResponse structureId(Long structureId) {
        this.structureId = structureId;
        return this;
    }

    /**
     * The Item ID of the structure
     * 
     * @return structureId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The Item ID of the structure")
    public Long getStructureId() {
        return structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    public CorporationStructuresResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    /**
     * The solar system the structure is in
     * 
     * @return systemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The solar system the structure is in")
    public Integer getSystemId() {
        return systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public CorporationStructuresResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * The type id of the structure
     * 
     * @return typeId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The type id of the structure")
    public Integer getTypeId() {
        return typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CorporationStructuresResponse unanchorsAt(OffsetDateTime unanchorsAt) {
        this.unanchorsAt = unanchorsAt;
        return this;
    }

    /**
     * Date at which the structure will unanchor
     * 
     * @return unanchorsAt
     **/
    @ApiModelProperty(example = "null", value = "Date at which the structure will unanchor")
    public OffsetDateTime getUnanchorsAt() {
        return unanchorsAt;
    }

    public void setUnanchorsAt(OffsetDateTime unanchorsAt) {
        this.unanchorsAt = unanchorsAt;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationStructuresResponse corporationStructuresResponse = (CorporationStructuresResponse) o;
        return Objects.equals(this.corporationId, corporationStructuresResponse.corporationId)
                && Objects.equals(this.fuelExpires, corporationStructuresResponse.fuelExpires)
                && Objects.equals(this.nextReinforceApply, corporationStructuresResponse.nextReinforceApply)
                && Objects.equals(this.nextReinforceHour, corporationStructuresResponse.nextReinforceHour)
                && Objects.equals(this.nextReinforceWeekday, corporationStructuresResponse.nextReinforceWeekday)
                && Objects.equals(this.profileId, corporationStructuresResponse.profileId)
                && Objects.equals(this.reinforceHour, corporationStructuresResponse.reinforceHour)
                && Objects.equals(this.reinforceWeekday, corporationStructuresResponse.reinforceWeekday)
                && Objects.equals(this.services, corporationStructuresResponse.services)
                && Objects.equals(this.state, corporationStructuresResponse.state)
                && Objects.equals(this.stateTimerEnd, corporationStructuresResponse.stateTimerEnd)
                && Objects.equals(this.stateTimerStart, corporationStructuresResponse.stateTimerStart)
                && Objects.equals(this.structureId, corporationStructuresResponse.structureId)
                && Objects.equals(this.systemId, corporationStructuresResponse.systemId)
                && Objects.equals(this.typeId, corporationStructuresResponse.typeId)
                && Objects.equals(this.unanchorsAt, corporationStructuresResponse.unanchorsAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(corporationId, fuelExpires, nextReinforceApply, nextReinforceHour, nextReinforceWeekday,
                profileId, reinforceHour, reinforceWeekday, services, state, stateTimerEnd, stateTimerStart,
                structureId, systemId, typeId, unanchorsAt);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationStructuresResponse {\n");

        sb.append("    corporationId: ").append(toIndentedString(corporationId)).append("\n");
        sb.append("    fuelExpires: ").append(toIndentedString(fuelExpires)).append("\n");
        sb.append("    nextReinforceApply: ").append(toIndentedString(nextReinforceApply)).append("\n");
        sb.append("    nextReinforceHour: ").append(toIndentedString(nextReinforceHour)).append("\n");
        sb.append("    nextReinforceWeekday: ").append(toIndentedString(nextReinforceWeekday)).append("\n");
        sb.append("    profileId: ").append(toIndentedString(profileId)).append("\n");
        sb.append("    reinforceHour: ").append(toIndentedString(reinforceHour)).append("\n");
        sb.append("    reinforceWeekday: ").append(toIndentedString(reinforceWeekday)).append("\n");
        sb.append("    services: ").append(toIndentedString(services)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("    stateTimerEnd: ").append(toIndentedString(stateTimerEnd)).append("\n");
        sb.append("    stateTimerStart: ").append(toIndentedString(stateTimerStart)).append("\n");
        sb.append("    structureId: ").append(toIndentedString(structureId)).append("\n");
        sb.append("    systemId: ").append(toIndentedString(systemId)).append("\n");
        sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
        sb.append("    unanchorsAt: ").append(toIndentedString(unanchorsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
