/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationActiveTotalKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationLastWeekKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationYesterdayKills;

@ApiModel(description="Top 10 rankings of corporations by number of kills from yesterday, last week and in total")
public class FactionWarfareLeaderboardCorporationsKills
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="active_total")
    private List<FactionWarfareLeaderboardCorporationActiveTotalKills> activeTotal = new ArrayList<FactionWarfareLeaderboardCorporationActiveTotalKills>();
    @JsonProperty(value="last_week")
    private List<FactionWarfareLeaderboardCorporationLastWeekKills> lastWeek = new ArrayList<FactionWarfareLeaderboardCorporationLastWeekKills>();
    @JsonProperty(value="yesterday")
    private List<FactionWarfareLeaderboardCorporationYesterdayKills> yesterday = new ArrayList<FactionWarfareLeaderboardCorporationYesterdayKills>();

    public FactionWarfareLeaderboardCorporationsKills activeTotal(List<FactionWarfareLeaderboardCorporationActiveTotalKills> list) {
        this.activeTotal = list;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsKills addActiveTotalItem(FactionWarfareLeaderboardCorporationActiveTotalKills factionWarfareLeaderboardCorporationActiveTotalKills) {
        this.activeTotal.add(factionWarfareLeaderboardCorporationActiveTotalKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 10 ranking of corporations active in faction warfare by total kills. A corporation is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardCorporationActiveTotalKills> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCorporationActiveTotalKills> list) {
        this.activeTotal = list;
    }

    public FactionWarfareLeaderboardCorporationsKills lastWeek(List<FactionWarfareLeaderboardCorporationLastWeekKills> list) {
        this.lastWeek = list;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsKills addLastWeekItem(FactionWarfareLeaderboardCorporationLastWeekKills factionWarfareLeaderboardCorporationLastWeekKills) {
        this.lastWeek.add(factionWarfareLeaderboardCorporationLastWeekKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 10 ranking of corporations by kills in the past week")
    public List<FactionWarfareLeaderboardCorporationLastWeekKills> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCorporationLastWeekKills> list) {
        this.lastWeek = list;
    }

    public FactionWarfareLeaderboardCorporationsKills yesterday(List<FactionWarfareLeaderboardCorporationYesterdayKills> list) {
        this.yesterday = list;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsKills addYesterdayItem(FactionWarfareLeaderboardCorporationYesterdayKills factionWarfareLeaderboardCorporationYesterdayKills) {
        this.yesterday.add(factionWarfareLeaderboardCorporationYesterdayKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 10 ranking of corporations by kills in the past day")
    public List<FactionWarfareLeaderboardCorporationYesterdayKills> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCorporationYesterdayKills> list) {
        this.yesterday = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCorporationsKills factionWarfareLeaderboardCorporationsKills = (FactionWarfareLeaderboardCorporationsKills)object;
        return Objects.equals(this.activeTotal, factionWarfareLeaderboardCorporationsKills.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardCorporationsKills.lastWeek) && Objects.equals(this.yesterday, factionWarfareLeaderboardCorporationsKills.yesterday);
    }

    public int hashCode() {
        return Objects.hash(this.activeTotal, this.lastWeek, this.yesterday);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FactionWarfareLeaderboardCorporationsKills {\n");
        stringBuilder.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        stringBuilder.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        stringBuilder.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

