/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.auth.Authentication;
import net.troja.eve.esi.auth.JWT;

public class OAuth
implements Authentication {
    private static final String URI_OAUTH = "https://login.eveonline.com/v2/oauth";
    private static final String URI_AUTHENTICATION = "https://login.eveonline.com/v2/oauth/authorize";
    private static final String URI_ACCESS_TOKEN = "https://login.eveonline.com/v2/oauth/token";
    private static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
    private static final SecureRandom RND = new SecureRandom();
    private static final int LEN = 128;
    private String refreshToken;
    private String clientId;
    private String codeVerifier;
    private static final Map<String, AccessTokenData> ACCESS_TOKEN_CACHE = new ConcurrentHashMap<String, AccessTokenData>();

    @Override
    public void applyToParams(List<Pair> list, Map<String, String> map) {
        AccessTokenData accessTokenData = this.getAccessTokenData();
        if (accessTokenData != null) {
            map.put("Authorization", "Bearer " + accessTokenData.getAccessToken());
        }
    }

    public void setAccessToken(String string) {
        ACCESS_TOKEN_CACHE.put(this.getAuthKey(), new AccessTokenData(string, 0L));
    }

    public void setRefreshToken(String string) {
        this.refreshToken = string;
    }

    public void setClientId(String string) {
        this.clientId = string;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAccessToken() {
        AccessTokenData accessTokenData = this.getAccessTokenData();
        if (accessTokenData != null) {
            return accessTokenData.getAccessToken();
        }
        return null;
    }

    public JWT getJWT() {
        AccessTokenData accessTokenData = this.getAccessTokenData();
        if (accessTokenData == null) {
            return null;
        }
        try {
            String string = accessTokenData.getAccessToken();
            String[] stringArray = string.split("\\.");
            if (stringArray.length != 3) {
                return null;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            JWT.Header header = (JWT.Header)objectMapper.readValue(new String(Base64.getUrlDecoder().decode(stringArray[0])), JWT.Header.class);
            JWT.Payload payload = (JWT.Payload)objectMapper.readValue(new String(Base64.getUrlDecoder().decode(stringArray[1])), JWT.Payload.class);
            String string2 = stringArray[2];
            return new JWT(header, payload, string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenData getAccessTokenData() {
        Class<OAuth> clazz = OAuth.class;
        synchronized (OAuth.class) {
            AccessTokenData accessTokenData = ACCESS_TOKEN_CACHE.get(this.getAuthKey());
            if (this.refreshToken != null && (accessTokenData == null || accessTokenData.getValidUntil() < System.currentTimeMillis())) {
                try {
                    this.refreshToken();
                }
                catch (ApiException apiException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ACCESS_TOKEN_CACHE.get(this.getAuthKey());
        }
    }

    public String getAuthorizationUri(String string, Set<String> set, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(URI_AUTHENTICATION);
        stringBuilder.append("?");
        stringBuilder.append("response_type=code");
        stringBuilder.append("&redirect_uri=");
        stringBuilder.append(string);
        stringBuilder.append("&client_id=");
        stringBuilder.append(this.clientId);
        stringBuilder.append("&scope=");
        stringBuilder.append(this.getScopesString(set));
        stringBuilder.append("&state=");
        stringBuilder.append(string2);
        stringBuilder.append("&code_challenge");
        stringBuilder.append(this.getCodeChallenge());
        stringBuilder.append("&code_challenge_method=S256");
        return stringBuilder.toString();
    }

    public void finishFlow(String string, String string2) throws ApiException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("grant_type=authorization_code");
            stringBuilder.append("&client_id=");
            stringBuilder.append(URLEncoder.encode(this.clientId, "UTF-8"));
            stringBuilder.append("&code=");
            stringBuilder.append(string);
            stringBuilder.append("&code_verifier=");
            stringBuilder.append(this.codeVerifier);
            this.update(stringBuilder.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ApiException(unsupportedEncodingException);
        }
    }

    private void refreshToken() throws ApiException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("grant_type=refresh_token");
            stringBuilder.append("&client_id=");
            stringBuilder.append(URLEncoder.encode(this.clientId, "UTF-8"));
            stringBuilder.append("&refresh_token=");
            stringBuilder.append(URLEncoder.encode(this.refreshToken, "UTF-8"));
            this.update(stringBuilder.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ApiException(unsupportedEncodingException);
        }
    }

    private void update(String string) throws ApiException {
        try {
            String string2;
            URL uRL = new URL(URI_ACCESS_TOKEN);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpsURLConnection.setRequestProperty("Host", "login.eveonline.com");
            httpsURLConnection.setDoOutput(true);
            Object object = new DataOutputStream(httpsURLConnection.getOutputStream());
            Object object2 = null;
            try {
                ((DataOutputStream)object).writeBytes(string);
                ((DataOutputStream)object).flush();
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((FilterOutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((FilterOutputStream)object).close();
                    }
                }
            }
            object2 = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            Object object3 = null;
            try {
                object = new StringBuilder();
                while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                    ((StringBuilder)object).append(string2);
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
            object2 = new ObjectMapper();
            object3 = (Result)object2.readValue(((StringBuilder)object).toString(), Result.class);
            this.refreshToken = ((Result)object3).getRefreshToken();
            string2 = ((Result)object3).getAccessToken();
            long l = System.currentTimeMillis() + ((Result)object3).getExpiresIn() * 1000L - 5000L;
            ACCESS_TOKEN_CACHE.put(this.getAuthKey(), new AccessTokenData(string2, l));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ApiException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
    }

    private String getScopesString(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        if (set != null) {
            for (String string : set) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
            }
        }
        try {
            return URLEncoder.encode(stringBuilder.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private String getAuthKey() {
        return this.clientId + this.refreshToken;
    }

    private String getCodeChallenge() {
        try {
            StringBuilder stringBuilder = new StringBuilder(128);
            for (int i = 0; i < 128; ++i) {
                stringBuilder.append(AB.charAt(RND.nextInt(AB.length())));
            }
            this.codeVerifier = stringBuilder.toString();
            byte[] byArray = this.codeVerifier.getBytes(StandardCharsets.US_ASCII);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = messageDigest.digest(byArray);
            return Base64.getUrlEncoder().encodeToString(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static class Result {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="expires_in")
        private Long expiresIn;
        @JsonProperty(value="token_type")
        private String tokenType;
        @JsonProperty(value="refresh_token")
        private String refreshToken;

        private Result() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String string) {
            this.accessToken = string;
        }

        public Long getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Long l) {
            this.expiresIn = l;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setTokenType(String string) {
            this.tokenType = string;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String string) {
            this.refreshToken = string;
        }
    }

    private static class AccessTokenData {
        private final String accessToken;
        private final long validUntil;

        public AccessTokenData(String string, long l) {
            this.accessToken = string;
            this.validUntil = l;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public long getValidUntil() {
            return this.validUntil;
        }
    }
}

