/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationStarbasesResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("moon_id")
    private Integer moonId = null;

    @JsonProperty("onlined_since")
    private OffsetDateTime onlinedSince = null;

    @JsonProperty("reinforced_until")
    private OffsetDateTime reinforcedUntil = null;

    @JsonProperty("starbase_id")
    private Long starbaseId = null;

    /**
     * state string
     */
    public enum StateEnum {
        OFFLINE("offline"),

        ONLINE("online"),

        ONLINING("onlining"),

        REINFORCED("reinforced"),

        UNANCHORING("unanchoring");

        private String value;

        StateEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("state")
    private StateEnum state = null;

    @JsonProperty("system_id")
    private Integer systemId = null;

    @JsonProperty("type_id")
    private Integer typeId = null;

    @JsonProperty("unanchor_at")
    private OffsetDateTime unanchorAt = null;

    public CorporationStarbasesResponse moonId(Integer moonId) {
        this.moonId = moonId;
        return this;
    }

    /**
     * The moon this starbase (POS) is anchored on, unanchored POSes do not have
     * this information
     * 
     * @return moonId
     **/
    @ApiModelProperty(example = "null", value = "The moon this starbase (POS) is anchored on, unanchored POSes do not have this information")
    public Integer getMoonId() {
        return moonId;
    }

    public void setMoonId(Integer moonId) {
        this.moonId = moonId;
    }

    public CorporationStarbasesResponse onlinedSince(OffsetDateTime onlinedSince) {
        this.onlinedSince = onlinedSince;
        return this;
    }

    /**
     * When the POS onlined, for starbases (POSes) in online state
     * 
     * @return onlinedSince
     **/
    @ApiModelProperty(example = "null", value = "When the POS onlined, for starbases (POSes) in online state")
    public OffsetDateTime getOnlinedSince() {
        return onlinedSince;
    }

    public void setOnlinedSince(OffsetDateTime onlinedSince) {
        this.onlinedSince = onlinedSince;
    }

    public CorporationStarbasesResponse reinforcedUntil(OffsetDateTime reinforcedUntil) {
        this.reinforcedUntil = reinforcedUntil;
        return this;
    }

    /**
     * When the POS will be out of reinforcement, for starbases (POSes) in
     * reinforced state
     * 
     * @return reinforcedUntil
     **/
    @ApiModelProperty(example = "null", value = "When the POS will be out of reinforcement, for starbases (POSes) in reinforced state")
    public OffsetDateTime getReinforcedUntil() {
        return reinforcedUntil;
    }

    public void setReinforcedUntil(OffsetDateTime reinforcedUntil) {
        this.reinforcedUntil = reinforcedUntil;
    }

    public CorporationStarbasesResponse starbaseId(Long starbaseId) {
        this.starbaseId = starbaseId;
        return this;
    }

    /**
     * Unique ID for this starbase (POS)
     * 
     * @return starbaseId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Unique ID for this starbase (POS)")
    public Long getStarbaseId() {
        return starbaseId;
    }

    public void setStarbaseId(Long starbaseId) {
        this.starbaseId = starbaseId;
    }

    public CorporationStarbasesResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    /**
     * state string
     * 
     * @return state
     **/
    @ApiModelProperty(example = "null", value = "state string")
    public StateEnum getState() {
        return state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CorporationStarbasesResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    /**
     * The solar system this starbase (POS) is in, unanchored POSes have this
     * information
     * 
     * @return systemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The solar system this starbase (POS) is in, unanchored POSes have this information")
    public Integer getSystemId() {
        return systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public CorporationStarbasesResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * Starbase (POS) type
     * 
     * @return typeId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Starbase (POS) type")
    public Integer getTypeId() {
        return typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CorporationStarbasesResponse unanchorAt(OffsetDateTime unanchorAt) {
        this.unanchorAt = unanchorAt;
        return this;
    }

    /**
     * When the POS started unanchoring, for starbases (POSes) in unanchoring
     * state
     * 
     * @return unanchorAt
     **/
    @ApiModelProperty(example = "null", value = "When the POS started unanchoring, for starbases (POSes) in unanchoring state")
    public OffsetDateTime getUnanchorAt() {
        return unanchorAt;
    }

    public void setUnanchorAt(OffsetDateTime unanchorAt) {
        this.unanchorAt = unanchorAt;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationStarbasesResponse corporationStarbasesResponse = (CorporationStarbasesResponse) o;
        return Objects.equals(this.moonId, corporationStarbasesResponse.moonId)
                && Objects.equals(this.onlinedSince, corporationStarbasesResponse.onlinedSince)
                && Objects.equals(this.reinforcedUntil, corporationStarbasesResponse.reinforcedUntil)
                && Objects.equals(this.starbaseId, corporationStarbasesResponse.starbaseId)
                && Objects.equals(this.state, corporationStarbasesResponse.state)
                && Objects.equals(this.systemId, corporationStarbasesResponse.systemId)
                && Objects.equals(this.typeId, corporationStarbasesResponse.typeId)
                && Objects.equals(this.unanchorAt, corporationStarbasesResponse.unanchorAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(moonId, onlinedSince, reinforcedUntil, starbaseId, state, systemId, typeId, unanchorAt);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationStarbasesResponse {\n");

        sb.append("    moonId: ").append(toIndentedString(moonId)).append("\n");
        sb.append("    onlinedSince: ").append(toIndentedString(onlinedSince)).append("\n");
        sb.append("    reinforcedUntil: ").append(toIndentedString(reinforcedUntil)).append("\n");
        sb.append("    starbaseId: ").append(toIndentedString(starbaseId)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("    systemId: ").append(toIndentedString(systemId)).append("\n");
        sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
        sb.append("    unanchorAt: ").append(toIndentedString(unanchorAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
