/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import net.troja.eve.esi.model.CorporationFwStatsKills;
import net.troja.eve.esi.model.CorporationFwStatsVictoryPoints;

@ApiModel(description="200 ok object")
public class CorporationFwStatsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="enlisted_on")
    private OffsetDateTime enlistedOn = null;
    @JsonProperty(value="faction_id")
    private Integer factionId = null;
    @JsonProperty(value="kills")
    private CorporationFwStatsKills kills = null;
    @JsonProperty(value="pilots")
    private Integer pilots = null;
    @JsonProperty(value="victory_points")
    private CorporationFwStatsVictoryPoints victoryPoints = null;

    public CorporationFwStatsResponse enlistedOn(OffsetDateTime offsetDateTime) {
        this.enlistedOn = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The enlistment date of the given corporation into faction warfare. Will not be included if corporation is not enlisted in faction warfare")
    public OffsetDateTime getEnlistedOn() {
        return this.enlistedOn;
    }

    public void setEnlistedOn(OffsetDateTime offsetDateTime) {
        this.enlistedOn = offsetDateTime;
    }

    public CorporationFwStatsResponse factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="The faction the given corporation is enlisted to fight for. Will not be included if corporation is not enlisted in faction warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public CorporationFwStatsResponse kills(CorporationFwStatsKills corporationFwStatsKills) {
        this.kills = corporationFwStatsKills;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CorporationFwStatsKills getKills() {
        return this.kills;
    }

    public void setKills(CorporationFwStatsKills corporationFwStatsKills) {
        this.kills = corporationFwStatsKills;
    }

    public CorporationFwStatsResponse pilots(Integer n) {
        this.pilots = n;
        return this;
    }

    @ApiModelProperty(example="null", value="How many pilots the enlisted corporation has. Will not be included if corporation is not enlisted in faction warfare")
    public Integer getPilots() {
        return this.pilots;
    }

    public void setPilots(Integer n) {
        this.pilots = n;
    }

    public CorporationFwStatsResponse victoryPoints(CorporationFwStatsVictoryPoints corporationFwStatsVictoryPoints) {
        this.victoryPoints = corporationFwStatsVictoryPoints;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CorporationFwStatsVictoryPoints getVictoryPoints() {
        return this.victoryPoints;
    }

    public void setVictoryPoints(CorporationFwStatsVictoryPoints corporationFwStatsVictoryPoints) {
        this.victoryPoints = corporationFwStatsVictoryPoints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationFwStatsResponse corporationFwStatsResponse = (CorporationFwStatsResponse)object;
        return Objects.equals(this.enlistedOn, corporationFwStatsResponse.enlistedOn) && Objects.equals(this.factionId, corporationFwStatsResponse.factionId) && Objects.equals(this.kills, corporationFwStatsResponse.kills) && Objects.equals(this.pilots, corporationFwStatsResponse.pilots) && Objects.equals(this.victoryPoints, corporationFwStatsResponse.victoryPoints);
    }

    public int hashCode() {
        return Objects.hash(this.enlistedOn, this.factionId, this.kills, this.pilots, this.victoryPoints);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationFwStatsResponse {\n");
        stringBuilder.append("    enlistedOn: ").append(this.toIndentedString(this.enlistedOn)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("    kills: ").append(this.toIndentedString(this.kills)).append("\n");
        stringBuilder.append("    pilots: ").append(this.toIndentedString(this.pilots)).append("\n");
        stringBuilder.append("    victoryPoints: ").append(this.toIndentedString(this.victoryPoints)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

