/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class IncursionsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("constellation_id")
    private Integer constellationId = null;

    @JsonProperty("faction_id")
    private Integer factionId = null;

    @JsonProperty("has_boss")
    private Boolean hasBoss = null;

    @JsonProperty("infested_solar_systems")
    private List<Integer> infestedSolarSystems = new ArrayList<Integer>();

    @JsonProperty("influence")
    private Float influence = null;

    @JsonProperty("staging_solar_system_id")
    private Integer stagingSolarSystemId = null;

    /**
     * The state of this incursion
     */
    public enum StateEnum {
        WITHDRAWING("withdrawing"),

        MOBILIZING("mobilizing"),

        ESTABLISHED("established");

        private String value;

        StateEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("state")
    private StateEnum state = null;

    @JsonProperty("type")
    private String type = null;

    public IncursionsResponse constellationId(Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    /**
     * The constellation id in which this incursion takes place
     * 
     * @return constellationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The constellation id in which this incursion takes place")
    public Integer getConstellationId() {
        return constellationId;
    }

    public void setConstellationId(Integer constellationId) {
        this.constellationId = constellationId;
    }

    public IncursionsResponse factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    /**
     * The attacking faction's id
     * 
     * @return factionId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The attacking faction's id")
    public Integer getFactionId() {
        return factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public IncursionsResponse hasBoss(Boolean hasBoss) {
        this.hasBoss = hasBoss;
        return this;
    }

    /**
     * Whether the final encounter has boss or not
     * 
     * @return hasBoss
     **/
    @ApiModelProperty(example = "null", required = true, value = "Whether the final encounter has boss or not")
    public Boolean getHasBoss() {
        return hasBoss;
    }

    public void setHasBoss(Boolean hasBoss) {
        this.hasBoss = hasBoss;
    }

    public IncursionsResponse infestedSolarSystems(List<Integer> infestedSolarSystems) {
        this.infestedSolarSystems = infestedSolarSystems;
        return this;
    }

    public IncursionsResponse addInfestedSolarSystemsItem(Integer infestedSolarSystemsItem) {
        this.infestedSolarSystems.add(infestedSolarSystemsItem);
        return this;
    }

    /**
     * A list of infested solar system ids that are a part of this incursion
     * 
     * @return infestedSolarSystems
     **/
    @ApiModelProperty(example = "null", required = true, value = "A list of infested solar system ids that are a part of this incursion")
    public List<Integer> getInfestedSolarSystems() {
        return infestedSolarSystems;
    }

    public void setInfestedSolarSystems(List<Integer> infestedSolarSystems) {
        this.infestedSolarSystems = infestedSolarSystems;
    }

    public IncursionsResponse influence(Float influence) {
        this.influence = influence;
        return this;
    }

    /**
     * Influence of this incursion as a float from 0 to 1
     * 
     * @return influence
     **/
    @ApiModelProperty(example = "null", required = true, value = "Influence of this incursion as a float from 0 to 1")
    public Float getInfluence() {
        return influence;
    }

    public void setInfluence(Float influence) {
        this.influence = influence;
    }

    public IncursionsResponse stagingSolarSystemId(Integer stagingSolarSystemId) {
        this.stagingSolarSystemId = stagingSolarSystemId;
        return this;
    }

    /**
     * Staging solar system for this incursion
     * 
     * @return stagingSolarSystemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Staging solar system for this incursion")
    public Integer getStagingSolarSystemId() {
        return stagingSolarSystemId;
    }

    public void setStagingSolarSystemId(Integer stagingSolarSystemId) {
        this.stagingSolarSystemId = stagingSolarSystemId;
    }

    public IncursionsResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    /**
     * The state of this incursion
     * 
     * @return state
     **/
    @ApiModelProperty(example = "null", required = true, value = "The state of this incursion")
    public StateEnum getState() {
        return state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public IncursionsResponse type(String type) {
        this.type = type;
        return this;
    }

    /**
     * The type of this incursion
     * 
     * @return type
     **/
    @ApiModelProperty(example = "null", required = true, value = "The type of this incursion")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IncursionsResponse incursionsResponse = (IncursionsResponse) o;
        return Objects.equals(this.constellationId, incursionsResponse.constellationId)
                && Objects.equals(this.factionId, incursionsResponse.factionId)
                && Objects.equals(this.hasBoss, incursionsResponse.hasBoss)
                && Objects.equals(this.infestedSolarSystems, incursionsResponse.infestedSolarSystems)
                && Objects.equals(this.influence, incursionsResponse.influence)
                && Objects.equals(this.stagingSolarSystemId, incursionsResponse.stagingSolarSystemId)
                && Objects.equals(this.state, incursionsResponse.state)
                && Objects.equals(this.type, incursionsResponse.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(constellationId, factionId, hasBoss, infestedSolarSystems, influence, stagingSolarSystemId,
                state, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncursionsResponse {\n");

        sb.append("    constellationId: ").append(toIndentedString(constellationId)).append("\n");
        sb.append("    factionId: ").append(toIndentedString(factionId)).append("\n");
        sb.append("    hasBoss: ").append(toIndentedString(hasBoss)).append("\n");
        sb.append("    infestedSolarSystems: ").append(toIndentedString(infestedSolarSystems)).append("\n");
        sb.append("    influence: ").append(toIndentedString(influence)).append("\n");
        sb.append("    stagingSolarSystemId: ").append(toIndentedString(stagingSolarSystemId)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
