/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersLastWeekVictoryPoints;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersYesterdayVictoryPoints;
import java.io.Serializable;

/**
 * Top 100 rankings of pilots by victory points from yesterday, last week and in
 * total
 */
@ApiModel(description = "Top 100 rankings of pilots by victory points from yesterday, last week and in total")
public class FactionWarfareLeaderboardCharacterVictoryPoints implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("active_total")
    private List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> activeTotal = new ArrayList<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints>();

    @JsonProperty("last_week")
    private List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> lastWeek = new ArrayList<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints>();

    @JsonProperty("yesterday")
    private List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> yesterday = new ArrayList<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints>();

    public FactionWarfareLeaderboardCharacterVictoryPoints activeTotal(
            List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints addActiveTotalItem(
            FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    /**
     * Top 100 ranking of pilots active in faction warfare by total victory
     * points. A pilot is considered \"active\" if they have participated in
     * faction warfare in the past 14 days.
     * 
     * @return activeTotal
     **/
    @ApiModelProperty(example = "null", required = true, value = "Top 100 ranking of pilots active in faction warfare by total victory points. A pilot is considered \"active\" if they have participated in faction warfare in the past 14 days.")
    public List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> getActiveTotal() {
        return activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCharactersActiveTotalVictoryPoints> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints lastWeek(
            List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints addLastWeekItem(
            FactionWarfareLeaderboardCharactersLastWeekVictoryPoints lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    /**
     * Top 100 ranking of pilots by victory points in the past week
     * 
     * @return lastWeek
     **/
    @ApiModelProperty(example = "null", required = true, value = "Top 100 ranking of pilots by victory points in the past week")
    public List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> getLastWeek() {
        return lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCharactersLastWeekVictoryPoints> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints yesterday(
            List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardCharacterVictoryPoints addYesterdayItem(
            FactionWarfareLeaderboardCharactersYesterdayVictoryPoints yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    /**
     * Top 100 ranking of pilots by victory points in the past day
     * 
     * @return yesterday
     **/
    @ApiModelProperty(example = "null", required = true, value = "Top 100 ranking of pilots by victory points in the past day")
    public List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> getYesterday() {
        return yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCharactersYesterdayVictoryPoints> yesterday) {
        this.yesterday = yesterday;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCharacterVictoryPoints factionWarfareLeaderboardCharacterVictoryPoints = (FactionWarfareLeaderboardCharacterVictoryPoints) o;
        return Objects.equals(this.activeTotal, factionWarfareLeaderboardCharacterVictoryPoints.activeTotal)
                && Objects.equals(this.lastWeek, factionWarfareLeaderboardCharacterVictoryPoints.lastWeek)
                && Objects.equals(this.yesterday, factionWarfareLeaderboardCharacterVictoryPoints.yesterday);
    }

    @Override
    public int hashCode() {
        return Objects.hash(activeTotal, lastWeek, yesterday);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardCharacterVictoryPoints {\n");

        sb.append("    activeTotal: ").append(toIndentedString(activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(toIndentedString(lastWeek)).append("\n");
        sb.append("    yesterday: ").append(toIndentedString(yesterday)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
