/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CorporationRolesHistoryResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="changed_at")
    private OffsetDateTime changedAt = null;
    @JsonProperty(value="character_id")
    private Integer characterId = null;
    @JsonProperty(value="issuer_id")
    private Integer issuerId = null;
    @JsonProperty(value="new_roles")
    private List<NewRolesEnum> newRoles = new ArrayList<NewRolesEnum>();
    @JsonProperty(value="old_roles")
    private List<OldRolesEnum> oldRoles = new ArrayList<OldRolesEnum>();
    @JsonProperty(value="role_type")
    private RoleTypeEnum roleType = null;

    public CorporationRolesHistoryResponse changedAt(OffsetDateTime offsetDateTime) {
        this.changedAt = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="changed_at string")
    public OffsetDateTime getChangedAt() {
        return this.changedAt;
    }

    public void setChangedAt(OffsetDateTime offsetDateTime) {
        this.changedAt = offsetDateTime;
    }

    public CorporationRolesHistoryResponse characterId(Integer n) {
        this.characterId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The character whose roles are changed")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer n) {
        this.characterId = n;
    }

    public CorporationRolesHistoryResponse issuerId(Integer n) {
        this.issuerId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the character who issued this change")
    public Integer getIssuerId() {
        return this.issuerId;
    }

    public void setIssuerId(Integer n) {
        this.issuerId = n;
    }

    public CorporationRolesHistoryResponse newRoles(List<NewRolesEnum> list) {
        this.newRoles = list;
        return this;
    }

    public CorporationRolesHistoryResponse addNewRolesItem(NewRolesEnum newRolesEnum) {
        this.newRoles.add(newRolesEnum);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="new_roles array")
    public List<NewRolesEnum> getNewRoles() {
        return this.newRoles;
    }

    public void setNewRoles(List<NewRolesEnum> list) {
        this.newRoles = list;
    }

    public CorporationRolesHistoryResponse oldRoles(List<OldRolesEnum> list) {
        this.oldRoles = list;
        return this;
    }

    public CorporationRolesHistoryResponse addOldRolesItem(OldRolesEnum oldRolesEnum) {
        this.oldRoles.add(oldRolesEnum);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="old_roles array")
    public List<OldRolesEnum> getOldRoles() {
        return this.oldRoles;
    }

    public void setOldRoles(List<OldRolesEnum> list) {
        this.oldRoles = list;
    }

    public CorporationRolesHistoryResponse roleType(RoleTypeEnum roleTypeEnum) {
        this.roleType = roleTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="role_type string")
    public RoleTypeEnum getRoleType() {
        return this.roleType;
    }

    public void setRoleType(RoleTypeEnum roleTypeEnum) {
        this.roleType = roleTypeEnum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationRolesHistoryResponse corporationRolesHistoryResponse = (CorporationRolesHistoryResponse)object;
        return Objects.equals(this.changedAt, corporationRolesHistoryResponse.changedAt) && Objects.equals(this.characterId, corporationRolesHistoryResponse.characterId) && Objects.equals(this.issuerId, corporationRolesHistoryResponse.issuerId) && Objects.equals(this.newRoles, corporationRolesHistoryResponse.newRoles) && Objects.equals(this.oldRoles, corporationRolesHistoryResponse.oldRoles) && Objects.equals((Object)this.roleType, (Object)corporationRolesHistoryResponse.roleType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changedAt, this.characterId, this.issuerId, this.newRoles, this.oldRoles, this.roleType});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationRolesHistoryResponse {\n");
        stringBuilder.append("    changedAt: ").append(this.toIndentedString(this.changedAt)).append("\n");
        stringBuilder.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        stringBuilder.append("    issuerId: ").append(this.toIndentedString(this.issuerId)).append("\n");
        stringBuilder.append("    newRoles: ").append(this.toIndentedString(this.newRoles)).append("\n");
        stringBuilder.append("    oldRoles: ").append(this.toIndentedString(this.oldRoles)).append("\n");
        stringBuilder.append("    roleType: ").append(this.toIndentedString((Object)this.roleType)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum RoleTypeEnum {
        GRANTABLE_ROLES("grantable_roles"),
        GRANTABLE_ROLES_AT_BASE("grantable_roles_at_base"),
        GRANTABLE_ROLES_AT_HQ("grantable_roles_at_hq"),
        GRANTABLE_ROLES_AT_OTHER("grantable_roles_at_other"),
        ROLES("roles"),
        ROLES_AT_BASE("roles_at_base"),
        ROLES_AT_HQ("roles_at_hq"),
        ROLES_AT_OTHER("roles_at_other");

        private String value;

        private RoleTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleTypeEnum fromValue(String string) {
            for (RoleTypeEnum roleTypeEnum : RoleTypeEnum.values()) {
                if (!String.valueOf(roleTypeEnum.value).equals(string)) continue;
                return roleTypeEnum;
            }
            return null;
        }
    }

    public static enum OldRolesEnum {
        ACCOUNT_TAKE_1("Account_Take_1"),
        ACCOUNT_TAKE_2("Account_Take_2"),
        ACCOUNT_TAKE_3("Account_Take_3"),
        ACCOUNT_TAKE_4("Account_Take_4"),
        ACCOUNT_TAKE_5("Account_Take_5"),
        ACCOUNT_TAKE_6("Account_Take_6"),
        ACCOUNT_TAKE_7("Account_Take_7"),
        ACCOUNTANT("Accountant"),
        AUDITOR("Auditor"),
        COMMUNICATIONS_OFFICER("Communications_Officer"),
        CONFIG_EQUIPMENT("Config_Equipment"),
        CONFIG_STARBASE_EQUIPMENT("Config_Starbase_Equipment"),
        CONTAINER_TAKE_1("Container_Take_1"),
        CONTAINER_TAKE_2("Container_Take_2"),
        CONTAINER_TAKE_3("Container_Take_3"),
        CONTAINER_TAKE_4("Container_Take_4"),
        CONTAINER_TAKE_5("Container_Take_5"),
        CONTAINER_TAKE_6("Container_Take_6"),
        CONTAINER_TAKE_7("Container_Take_7"),
        CONTRACT_MANAGER("Contract_Manager"),
        DIPLOMAT("Diplomat"),
        DIRECTOR("Director"),
        FACTORY_MANAGER("Factory_Manager"),
        FITTING_MANAGER("Fitting_Manager"),
        HANGAR_QUERY_1("Hangar_Query_1"),
        HANGAR_QUERY_2("Hangar_Query_2"),
        HANGAR_QUERY_3("Hangar_Query_3"),
        HANGAR_QUERY_4("Hangar_Query_4"),
        HANGAR_QUERY_5("Hangar_Query_5"),
        HANGAR_QUERY_6("Hangar_Query_6"),
        HANGAR_QUERY_7("Hangar_Query_7"),
        HANGAR_TAKE_1("Hangar_Take_1"),
        HANGAR_TAKE_2("Hangar_Take_2"),
        HANGAR_TAKE_3("Hangar_Take_3"),
        HANGAR_TAKE_4("Hangar_Take_4"),
        HANGAR_TAKE_5("Hangar_Take_5"),
        HANGAR_TAKE_6("Hangar_Take_6"),
        HANGAR_TAKE_7("Hangar_Take_7"),
        JUNIOR_ACCOUNTANT("Junior_Accountant"),
        PERSONNEL_MANAGER("Personnel_Manager"),
        RENT_FACTORY_FACILITY("Rent_Factory_Facility"),
        RENT_OFFICE("Rent_Office"),
        RENT_RESEARCH_FACILITY("Rent_Research_Facility"),
        SECURITY_OFFICER("Security_Officer"),
        STARBASE_DEFENSE_OPERATOR("Starbase_Defense_Operator"),
        STARBASE_FUEL_TECHNICIAN("Starbase_Fuel_Technician"),
        STATION_MANAGER("Station_Manager"),
        TERRESTRIAL_COMBAT_OFFICER("Terrestrial_Combat_Officer"),
        TERRESTRIAL_LOGISTICS_OFFICER("Terrestrial_Logistics_Officer"),
        TRADER("Trader");

        private String value;

        private OldRolesEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OldRolesEnum fromValue(String string) {
            for (OldRolesEnum oldRolesEnum : OldRolesEnum.values()) {
                if (!String.valueOf(oldRolesEnum.value).equals(string)) continue;
                return oldRolesEnum;
            }
            return null;
        }
    }

    public static enum NewRolesEnum {
        ACCOUNT_TAKE_1("Account_Take_1"),
        ACCOUNT_TAKE_2("Account_Take_2"),
        ACCOUNT_TAKE_3("Account_Take_3"),
        ACCOUNT_TAKE_4("Account_Take_4"),
        ACCOUNT_TAKE_5("Account_Take_5"),
        ACCOUNT_TAKE_6("Account_Take_6"),
        ACCOUNT_TAKE_7("Account_Take_7"),
        ACCOUNTANT("Accountant"),
        AUDITOR("Auditor"),
        COMMUNICATIONS_OFFICER("Communications_Officer"),
        CONFIG_EQUIPMENT("Config_Equipment"),
        CONFIG_STARBASE_EQUIPMENT("Config_Starbase_Equipment"),
        CONTAINER_TAKE_1("Container_Take_1"),
        CONTAINER_TAKE_2("Container_Take_2"),
        CONTAINER_TAKE_3("Container_Take_3"),
        CONTAINER_TAKE_4("Container_Take_4"),
        CONTAINER_TAKE_5("Container_Take_5"),
        CONTAINER_TAKE_6("Container_Take_6"),
        CONTAINER_TAKE_7("Container_Take_7"),
        CONTRACT_MANAGER("Contract_Manager"),
        DIPLOMAT("Diplomat"),
        DIRECTOR("Director"),
        FACTORY_MANAGER("Factory_Manager"),
        FITTING_MANAGER("Fitting_Manager"),
        HANGAR_QUERY_1("Hangar_Query_1"),
        HANGAR_QUERY_2("Hangar_Query_2"),
        HANGAR_QUERY_3("Hangar_Query_3"),
        HANGAR_QUERY_4("Hangar_Query_4"),
        HANGAR_QUERY_5("Hangar_Query_5"),
        HANGAR_QUERY_6("Hangar_Query_6"),
        HANGAR_QUERY_7("Hangar_Query_7"),
        HANGAR_TAKE_1("Hangar_Take_1"),
        HANGAR_TAKE_2("Hangar_Take_2"),
        HANGAR_TAKE_3("Hangar_Take_3"),
        HANGAR_TAKE_4("Hangar_Take_4"),
        HANGAR_TAKE_5("Hangar_Take_5"),
        HANGAR_TAKE_6("Hangar_Take_6"),
        HANGAR_TAKE_7("Hangar_Take_7"),
        JUNIOR_ACCOUNTANT("Junior_Accountant"),
        PERSONNEL_MANAGER("Personnel_Manager"),
        RENT_FACTORY_FACILITY("Rent_Factory_Facility"),
        RENT_OFFICE("Rent_Office"),
        RENT_RESEARCH_FACILITY("Rent_Research_Facility"),
        SECURITY_OFFICER("Security_Officer"),
        STARBASE_DEFENSE_OPERATOR("Starbase_Defense_Operator"),
        STARBASE_FUEL_TECHNICIAN("Starbase_Fuel_Technician"),
        STATION_MANAGER("Station_Manager"),
        TERRESTRIAL_COMBAT_OFFICER("Terrestrial_Combat_Officer"),
        TERRESTRIAL_LOGISTICS_OFFICER("Terrestrial_Logistics_Officer"),
        TRADER("Trader");

        private String value;

        private NewRolesEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewRolesEnum fromValue(String string) {
            for (NewRolesEnum newRolesEnum : NewRolesEnum.values()) {
                if (!String.valueOf(newRolesEnum.value).equals(string)) continue;
                return newRolesEnum;
            }
            return null;
        }
    }
}

