/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import net.troja.eve.esi.model.CharacterFwStatsKills;
import net.troja.eve.esi.model.CharacterFwStatsVictoryPoints;

@ApiModel(description="200 ok object")
public class CharacterFwStatsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="current_rank")
    private Integer currentRank = null;
    @JsonProperty(value="enlisted_on")
    private OffsetDateTime enlistedOn = null;
    @JsonProperty(value="faction_id")
    private Integer factionId = null;
    @JsonProperty(value="highest_rank")
    private Integer highestRank = null;
    @JsonProperty(value="kills")
    private CharacterFwStatsKills kills = null;
    @JsonProperty(value="victory_points")
    private CharacterFwStatsVictoryPoints victoryPoints = null;

    public CharacterFwStatsResponse currentRank(Integer n) {
        this.currentRank = n;
        return this;
    }

    @ApiModelProperty(example="null", value="The given character's current faction rank")
    public Integer getCurrentRank() {
        return this.currentRank;
    }

    public void setCurrentRank(Integer n) {
        this.currentRank = n;
    }

    public CharacterFwStatsResponse enlistedOn(OffsetDateTime offsetDateTime) {
        this.enlistedOn = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The enlistment date of the given character into faction warfare. Will not be included if character is not enlisted in faction warfare")
    public OffsetDateTime getEnlistedOn() {
        return this.enlistedOn;
    }

    public void setEnlistedOn(OffsetDateTime offsetDateTime) {
        this.enlistedOn = offsetDateTime;
    }

    public CharacterFwStatsResponse factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="The faction the given character is enlisted to fight for. Will not be included if character is not enlisted in faction warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public CharacterFwStatsResponse highestRank(Integer n) {
        this.highestRank = n;
        return this;
    }

    @ApiModelProperty(example="null", value="The given character's highest faction rank achieved")
    public Integer getHighestRank() {
        return this.highestRank;
    }

    public void setHighestRank(Integer n) {
        this.highestRank = n;
    }

    public CharacterFwStatsResponse kills(CharacterFwStatsKills characterFwStatsKills) {
        this.kills = characterFwStatsKills;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CharacterFwStatsKills getKills() {
        return this.kills;
    }

    public void setKills(CharacterFwStatsKills characterFwStatsKills) {
        this.kills = characterFwStatsKills;
    }

    public CharacterFwStatsResponse victoryPoints(CharacterFwStatsVictoryPoints characterFwStatsVictoryPoints) {
        this.victoryPoints = characterFwStatsVictoryPoints;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CharacterFwStatsVictoryPoints getVictoryPoints() {
        return this.victoryPoints;
    }

    public void setVictoryPoints(CharacterFwStatsVictoryPoints characterFwStatsVictoryPoints) {
        this.victoryPoints = characterFwStatsVictoryPoints;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterFwStatsResponse characterFwStatsResponse = (CharacterFwStatsResponse)object;
        return Objects.equals(this.currentRank, characterFwStatsResponse.currentRank) && Objects.equals(this.enlistedOn, characterFwStatsResponse.enlistedOn) && Objects.equals(this.factionId, characterFwStatsResponse.factionId) && Objects.equals(this.highestRank, characterFwStatsResponse.highestRank) && Objects.equals(this.kills, characterFwStatsResponse.kills) && Objects.equals(this.victoryPoints, characterFwStatsResponse.victoryPoints);
    }

    public int hashCode() {
        return Objects.hash(this.currentRank, this.enlistedOn, this.factionId, this.highestRank, this.kills, this.victoryPoints);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterFwStatsResponse {\n");
        stringBuilder.append("    currentRank: ").append(this.toIndentedString(this.currentRank)).append("\n");
        stringBuilder.append("    enlistedOn: ").append(this.toIndentedString(this.enlistedOn)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("    highestRank: ").append(this.toIndentedString(this.highestRank)).append("\n");
        stringBuilder.append("    kills: ").append(this.toIndentedString(this.kills)).append("\n");
        stringBuilder.append("    victoryPoints: ").append(this.toIndentedString(this.victoryPoints)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

