/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CharacterPlanetsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("solar_system_id")
    private Integer solarSystemId = null;

    @JsonProperty("planet_id")
    private Integer planetId = null;

    @JsonProperty("owner_id")
    private Integer ownerId = null;

    @JsonProperty("upgrade_level")
    private Integer upgradeLevel = null;

    @JsonProperty("num_pins")
    private Integer numPins = null;

    @JsonProperty("last_update")
    private OffsetDateTime lastUpdate = null;

    /**
     * planet_type string
     */
    public enum PlanetTypeEnum {
        TEMPERATE("temperate"),

        BARREN("barren"),

        OCEANIC("oceanic"),

        ICE("ice"),

        GAS("gas"),

        LAVA("lava"),

        STORM("storm"),

        PLASMA("plasma");

        private String value;

        PlanetTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static PlanetTypeEnum fromValue(String text) {
            for (PlanetTypeEnum b : PlanetTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("planet_type")
    private PlanetTypeEnum planetType = null;

    public CharacterPlanetsResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    /**
     * solar_system_id integer
     * 
     * @return solarSystemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "solar_system_id integer")
    public Integer getSolarSystemId() {
        return solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public CharacterPlanetsResponse planetId(Integer planetId) {
        this.planetId = planetId;
        return this;
    }

    /**
     * planet_id integer
     * 
     * @return planetId
     **/
    @ApiModelProperty(example = "null", required = true, value = "planet_id integer")
    public Integer getPlanetId() {
        return planetId;
    }

    public void setPlanetId(Integer planetId) {
        this.planetId = planetId;
    }

    public CharacterPlanetsResponse ownerId(Integer ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    /**
     * owner_id integer
     * 
     * @return ownerId
     **/
    @ApiModelProperty(example = "null", required = true, value = "owner_id integer")
    public Integer getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public CharacterPlanetsResponse upgradeLevel(Integer upgradeLevel) {
        this.upgradeLevel = upgradeLevel;
        return this;
    }

    /**
     * upgrade_level integer minimum: 0 maximum: 5
     * 
     * @return upgradeLevel
     **/
    @ApiModelProperty(example = "null", required = true, value = "upgrade_level integer")
    public Integer getUpgradeLevel() {
        return upgradeLevel;
    }

    public void setUpgradeLevel(Integer upgradeLevel) {
        this.upgradeLevel = upgradeLevel;
    }

    public CharacterPlanetsResponse numPins(Integer numPins) {
        this.numPins = numPins;
        return this;
    }

    /**
     * num_pins integer minimum: 1
     * 
     * @return numPins
     **/
    @ApiModelProperty(example = "null", required = true, value = "num_pins integer")
    public Integer getNumPins() {
        return numPins;
    }

    public void setNumPins(Integer numPins) {
        this.numPins = numPins;
    }

    public CharacterPlanetsResponse lastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    /**
     * last_update string
     * 
     * @return lastUpdate
     **/
    @ApiModelProperty(example = "null", required = true, value = "last_update string")
    public OffsetDateTime getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public CharacterPlanetsResponse planetType(PlanetTypeEnum planetType) {
        this.planetType = planetType;
        return this;
    }

    /**
     * planet_type string
     * 
     * @return planetType
     **/
    @ApiModelProperty(example = "null", required = true, value = "planet_type string")
    public PlanetTypeEnum getPlanetType() {
        return planetType;
    }

    public void setPlanetType(PlanetTypeEnum planetType) {
        this.planetType = planetType;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterPlanetsResponse characterPlanetsResponse = (CharacterPlanetsResponse) o;
        return Objects.equals(this.solarSystemId, characterPlanetsResponse.solarSystemId)
                && Objects.equals(this.planetId, characterPlanetsResponse.planetId)
                && Objects.equals(this.ownerId, characterPlanetsResponse.ownerId)
                && Objects.equals(this.upgradeLevel, characterPlanetsResponse.upgradeLevel)
                && Objects.equals(this.numPins, characterPlanetsResponse.numPins)
                && Objects.equals(this.lastUpdate, characterPlanetsResponse.lastUpdate)
                && Objects.equals(this.planetType, characterPlanetsResponse.planetType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(solarSystemId, planetId, ownerId, upgradeLevel, numPins, lastUpdate, planetType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterPlanetsResponse {\n");

        sb.append("    solarSystemId: ").append(toIndentedString(solarSystemId)).append("\n");
        sb.append("    planetId: ").append(toIndentedString(planetId)).append("\n");
        sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
        sb.append("    upgradeLevel: ").append(toIndentedString(upgradeLevel)).append("\n");
        sb.append("    numPins: ").append(toIndentedString(numPins)).append("\n");
        sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
        sb.append("    planetType: ").append(toIndentedString(planetType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
