/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterOrdersHistoryResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="order_id")
    private Long orderId = null;
    @JsonProperty(value="type_id")
    private Integer typeId = null;
    @JsonProperty(value="region_id")
    private Integer regionId = null;
    @JsonProperty(value="location_id")
    private Long locationId = null;
    @JsonProperty(value="range")
    private RangeEnum range = null;
    @JsonProperty(value="price")
    private Double price = null;
    @JsonProperty(value="volume_total")
    private Integer volumeTotal = null;
    @JsonProperty(value="volume_remain")
    private Integer volumeRemain = null;
    @JsonProperty(value="issued")
    private OffsetDateTime issued = null;
    @JsonProperty(value="is_buy_order")
    private Boolean isBuyOrder = null;
    @JsonProperty(value="min_volume")
    private Integer minVolume = null;
    @JsonProperty(value="escrow")
    private Double escrow = null;
    @JsonProperty(value="duration")
    private Integer duration = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="is_corporation")
    private Boolean isCorporation = null;

    public CharacterOrdersHistoryResponse orderId(Long l) {
        this.orderId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique order ID")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long l) {
        this.orderId = l;
    }

    public CharacterOrdersHistoryResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type ID of the item transacted in this order")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CharacterOrdersHistoryResponse regionId(Integer n) {
        this.regionId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the region where order was placed")
    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer n) {
        this.regionId = n;
    }

    public CharacterOrdersHistoryResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the location where order was placed")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public CharacterOrdersHistoryResponse range(RangeEnum rangeEnum) {
        this.range = rangeEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Valid order range, numbers are ranges in jumps")
    public RangeEnum getRange() {
        return this.range;
    }

    public void setRange(RangeEnum rangeEnum) {
        this.range = rangeEnum;
    }

    public CharacterOrdersHistoryResponse price(Double d) {
        this.price = d;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Cost per unit for this order")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double d) {
        this.price = d;
    }

    public CharacterOrdersHistoryResponse volumeTotal(Integer n) {
        this.volumeTotal = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Quantity of items required or offered at time order was placed")
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Integer n) {
        this.volumeTotal = n;
    }

    public CharacterOrdersHistoryResponse volumeRemain(Integer n) {
        this.volumeRemain = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Quantity of items still required or offered")
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(Integer n) {
        this.volumeRemain = n;
    }

    public CharacterOrdersHistoryResponse issued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time when this order was issued")
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
    }

    public CharacterOrdersHistoryResponse isBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the order is a bid (buy) order")
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
    }

    public CharacterOrdersHistoryResponse minVolume(Integer n) {
        this.minVolume = n;
        return this;
    }

    @ApiModelProperty(example="null", value="For buy orders, the minimum quantity that will be accepted in a matching sell order")
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(Integer n) {
        this.minVolume = n;
    }

    public CharacterOrdersHistoryResponse escrow(Double d) {
        this.escrow = d;
        return this;
    }

    @ApiModelProperty(example="null", value="For buy orders, the amount of ISK in escrow")
    public Double getEscrow() {
        return this.escrow;
    }

    public void setEscrow(Double d) {
        this.escrow = d;
    }

    public CharacterOrdersHistoryResponse duration(Integer n) {
        this.duration = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Number of days the order was valid for (starting from the issued date). An order expires at time issued + duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer n) {
        this.duration = n;
    }

    public CharacterOrdersHistoryResponse state(StateEnum stateEnum) {
        this.state = stateEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Current order state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.state = stateEnum;
    }

    public CharacterOrdersHistoryResponse isCorporation(Boolean bl) {
        this.isCorporation = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Signifies whether the buy/sell order was placed on behalf of a corporation.")
    public Boolean getIsCorporation() {
        return this.isCorporation;
    }

    public void setIsCorporation(Boolean bl) {
        this.isCorporation = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterOrdersHistoryResponse characterOrdersHistoryResponse = (CharacterOrdersHistoryResponse)object;
        return Objects.equals(this.orderId, characterOrdersHistoryResponse.orderId) && Objects.equals(this.typeId, characterOrdersHistoryResponse.typeId) && Objects.equals(this.regionId, characterOrdersHistoryResponse.regionId) && Objects.equals(this.locationId, characterOrdersHistoryResponse.locationId) && Objects.equals((Object)this.range, (Object)characterOrdersHistoryResponse.range) && Objects.equals(this.price, characterOrdersHistoryResponse.price) && Objects.equals(this.volumeTotal, characterOrdersHistoryResponse.volumeTotal) && Objects.equals(this.volumeRemain, characterOrdersHistoryResponse.volumeRemain) && Objects.equals(this.issued, characterOrdersHistoryResponse.issued) && Objects.equals(this.isBuyOrder, characterOrdersHistoryResponse.isBuyOrder) && Objects.equals(this.minVolume, characterOrdersHistoryResponse.minVolume) && Objects.equals(this.escrow, characterOrdersHistoryResponse.escrow) && Objects.equals(this.duration, characterOrdersHistoryResponse.duration) && Objects.equals((Object)this.state, (Object)characterOrdersHistoryResponse.state) && Objects.equals(this.isCorporation, characterOrdersHistoryResponse.isCorporation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderId, this.typeId, this.regionId, this.locationId, this.range, this.price, this.volumeTotal, this.volumeRemain, this.issued, this.isBuyOrder, this.minVolume, this.escrow, this.duration, this.state, this.isCorporation});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterOrdersHistoryResponse {\n");
        stringBuilder.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    regionId: ").append(this.toIndentedString(this.regionId)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("    range: ").append(this.toIndentedString((Object)this.range)).append("\n");
        stringBuilder.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        stringBuilder.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        stringBuilder.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        stringBuilder.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        stringBuilder.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        stringBuilder.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        stringBuilder.append("    escrow: ").append(this.toIndentedString(this.escrow)).append("\n");
        stringBuilder.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        stringBuilder.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        stringBuilder.append("    isCorporation: ").append(this.toIndentedString(this.isCorporation)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        CANCELLED("cancelled"),
        EXPIRED("expired");

        private String value;

        private StateEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String string) {
            for (StateEnum stateEnum : StateEnum.values()) {
                if (!String.valueOf(stateEnum.value).equals(string)) continue;
                return stateEnum;
            }
            return null;
        }
    }

    public static enum RangeEnum {
        _1("1"),
        _10("10"),
        _2("2"),
        _20("20"),
        _3("3"),
        _30("30"),
        _4("4"),
        _40("40"),
        _5("5"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        STATION("station");

        private String value;

        private RangeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RangeEnum fromValue(String string) {
            for (RangeEnum rangeEnum : RangeEnum.values()) {
                if (!String.valueOf(rangeEnum.value).equals(string)) continue;
                return rangeEnum;
            }
            return null;
        }
    }
}

