/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="route object")
public class PlanetRoute
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="route_id")
    private Long routeId = null;
    @JsonProperty(value="source_pin_id")
    private Long sourcePinId = null;
    @JsonProperty(value="destination_pin_id")
    private Long destinationPinId = null;
    @JsonProperty(value="content_type_id")
    private Integer contentTypeId = null;
    @JsonProperty(value="quantity")
    private Float quantity = null;
    @JsonProperty(value="waypoints")
    private List<Long> waypoints = new ArrayList<Long>();

    public PlanetRoute routeId(Long l) {
        this.routeId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="route_id integer")
    public Long getRouteId() {
        return this.routeId;
    }

    public void setRouteId(Long l) {
        this.routeId = l;
    }

    public PlanetRoute sourcePinId(Long l) {
        this.sourcePinId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="source_pin_id integer")
    public Long getSourcePinId() {
        return this.sourcePinId;
    }

    public void setSourcePinId(Long l) {
        this.sourcePinId = l;
    }

    public PlanetRoute destinationPinId(Long l) {
        this.destinationPinId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="destination_pin_id integer")
    public Long getDestinationPinId() {
        return this.destinationPinId;
    }

    public void setDestinationPinId(Long l) {
        this.destinationPinId = l;
    }

    public PlanetRoute contentTypeId(Integer n) {
        this.contentTypeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="content_type_id integer")
    public Integer getContentTypeId() {
        return this.contentTypeId;
    }

    public void setContentTypeId(Integer n) {
        this.contentTypeId = n;
    }

    public PlanetRoute quantity(Float f) {
        this.quantity = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="quantity number")
    public Float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Float f) {
        this.quantity = f;
    }

    public PlanetRoute waypoints(List<Long> list) {
        this.waypoints = list;
        return this;
    }

    public PlanetRoute addWaypointsItem(Long l) {
        this.waypoints.add(l);
        return this;
    }

    @ApiModelProperty(example="null", value="list of pin ID waypoints")
    public List<Long> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<Long> list) {
        this.waypoints = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlanetRoute planetRoute = (PlanetRoute)object;
        return Objects.equals(this.routeId, planetRoute.routeId) && Objects.equals(this.sourcePinId, planetRoute.sourcePinId) && Objects.equals(this.destinationPinId, planetRoute.destinationPinId) && Objects.equals(this.contentTypeId, planetRoute.contentTypeId) && Objects.equals(this.quantity, planetRoute.quantity) && Objects.equals(this.waypoints, planetRoute.waypoints);
    }

    public int hashCode() {
        return Objects.hash(this.routeId, this.sourcePinId, this.destinationPinId, this.contentTypeId, this.quantity, this.waypoints);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class PlanetRoute {\n");
        stringBuilder.append("    routeId: ").append(this.toIndentedString(this.routeId)).append("\n");
        stringBuilder.append("    sourcePinId: ").append(this.toIndentedString(this.sourcePinId)).append("\n");
        stringBuilder.append("    destinationPinId: ").append(this.toIndentedString(this.destinationPinId)).append("\n");
        stringBuilder.append("    contentTypeId: ").append(this.toIndentedString(this.contentTypeId)).append("\n");
        stringBuilder.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        stringBuilder.append("    waypoints: ").append(this.toIndentedString(this.waypoints)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

