/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationContactsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("standing")
    private Float standing = null;

    /**
     * contact_type string
     */
    public enum ContactTypeEnum {
        CHARACTER("character"),

        CORPORATION("corporation"),

        ALLIANCE("alliance"),

        FACTION("faction");

        private String value;

        ContactTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ContactTypeEnum fromValue(String text) {
            for (ContactTypeEnum b : ContactTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("contact_type")
    private ContactTypeEnum contactType = null;

    @JsonProperty("contact_id")
    private Integer contactId = null;

    @JsonProperty("is_watched")
    private Boolean isWatched = null;

    @JsonProperty("label_id")
    private Long labelId = null;

    public CorporationContactsResponse standing(Float standing) {
        this.standing = standing;
        return this;
    }

    /**
     * Standing of the contact
     * 
     * @return standing
     **/
    @ApiModelProperty(example = "null", required = true, value = "Standing of the contact")
    public Float getStanding() {
        return standing;
    }

    public void setStanding(Float standing) {
        this.standing = standing;
    }

    public CorporationContactsResponse contactType(ContactTypeEnum contactType) {
        this.contactType = contactType;
        return this;
    }

    /**
     * contact_type string
     * 
     * @return contactType
     **/
    @ApiModelProperty(example = "null", required = true, value = "contact_type string")
    public ContactTypeEnum getContactType() {
        return contactType;
    }

    public void setContactType(ContactTypeEnum contactType) {
        this.contactType = contactType;
    }

    public CorporationContactsResponse contactId(Integer contactId) {
        this.contactId = contactId;
        return this;
    }

    /**
     * contact_id integer
     * 
     * @return contactId
     **/
    @ApiModelProperty(example = "null", required = true, value = "contact_id integer")
    public Integer getContactId() {
        return contactId;
    }

    public void setContactId(Integer contactId) {
        this.contactId = contactId;
    }

    public CorporationContactsResponse isWatched(Boolean isWatched) {
        this.isWatched = isWatched;
        return this;
    }

    /**
     * Whether this contact is being watched
     * 
     * @return isWatched
     **/
    @ApiModelProperty(example = "null", value = "Whether this contact is being watched")
    public Boolean getIsWatched() {
        return isWatched;
    }

    public void setIsWatched(Boolean isWatched) {
        this.isWatched = isWatched;
    }

    public CorporationContactsResponse labelId(Long labelId) {
        this.labelId = labelId;
        return this;
    }

    /**
     * Custom label of the contact
     * 
     * @return labelId
     **/
    @ApiModelProperty(example = "null", value = "Custom label of the contact")
    public Long getLabelId() {
        return labelId;
    }

    public void setLabelId(Long labelId) {
        this.labelId = labelId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationContactsResponse corporationContactsResponse = (CorporationContactsResponse) o;
        return Objects.equals(this.standing, corporationContactsResponse.standing)
                && Objects.equals(this.contactType, corporationContactsResponse.contactType)
                && Objects.equals(this.contactId, corporationContactsResponse.contactId)
                && Objects.equals(this.isWatched, corporationContactsResponse.isWatched)
                && Objects.equals(this.labelId, corporationContactsResponse.labelId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(standing, contactType, contactId, isWatched, labelId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationContactsResponse {\n");

        sb.append("    standing: ").append(toIndentedString(standing)).append("\n");
        sb.append("    contactType: ").append(toIndentedString(contactType)).append("\n");
        sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
        sb.append("    isWatched: ").append(toIndentedString(isWatched)).append("\n");
        sb.append("    labelId: ").append(toIndentedString(labelId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
